/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.configurables.groups;

import com.vmware.srm.client.impex.configurables.groups.IeProtectionGroup;
import com.vmware.srm.client.impex.configurables.groups.IeSpProtectionGroup;
import com.vmware.srm.client.impex.configurables.groups.ProtectionGroupConverter;
import com.vmware.srm.client.impex.utils.GroupUtil;
import com.vmware.srm.client.infrastructure.pc.utils.PcResult;
import com.vmware.vim.binding.pbm.profile.Profile;
import com.vmware.vim.binding.pbm.profile.ProfileId;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.constants.dr.replication.STORAGE_PROFILE_PROTECTION_GROUP;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;

public abstract class SpProtectionGroupConverter<T extends IeSpProtectionGroup>
extends ProtectionGroupConverter {
    private final Map<String, String> _localProfileIdToName;
    private final Map<String, String> _remoteProfileIdToName;

    public SpProtectionGroupConverter(PcResult pcResult, Profile[] localProfiles, Profile[] remoteProfiles) {
        super(pcResult);
        this._localProfileIdToName = GroupUtil.buildProfileIdToName(localProfiles);
        this._remoteProfileIdToName = GroupUtil.buildProfileIdToName(remoteProfiles);
    }

    public T fromVmodl(ManagedObjectReference protectionGroup) {
        T ieProtectionGroup = this.getIeSpProtectionGroup();
        this.setBasicSettings(protectionGroup, (IeProtectionGroup)ieProtectionGroup);
        this.setProfileSettings(protectionGroup, ieProtectionGroup);
        return ieProtectionGroup;
    }

    protected abstract T getIeSpProtectionGroup();

    private void setProfileSettings(ManagedObjectReference protectionGroup, T ieProtectionGroup) {
        ProfileId[] profileIds = (ProfileId[])this._pcResult.getProperty(protectionGroup, STORAGE_PROFILE_PROTECTION_GROUP.SETTINGS_.STORAGE_PROFILE);
        ((IeSpProtectionGroup)ieProtectionGroup).setProfiles(((IeProtectionGroup)ieProtectionGroup).isProtectedSiteLocal() ? this.profileIdsFromVmodl(profileIds, this._localProfileIdToName) : this.profileIdsFromVmodl(profileIds, this._remoteProfileIdToName));
    }

    private String[] profileIdsFromVmodl(ProfileId[] profileIds, Map<String, String> profileIdToName) {
        if (Objects.isNull(profileIds)) {
            return null;
        }
        return (String[])Arrays.stream(profileIds).filter(Objects::nonNull).map(ProfileId::getUniqueId).filter(Objects::nonNull).map(profileIdToName::get).toArray(String[]::new);
    }
}

