/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.configurables.plans;

import com.vmware.srm.client.impex.configurables.Configurable;
import com.vmware.srm.client.impex.configurables.mappings.IeTestNetworkMapping;
import com.vmware.srm.client.impex.configurables.plans.IeCalloutSpec;
import com.vmware.vim.binding.dr.recovery.RecoveryPlan;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.collections.CollectionUtils;

@XmlType(propOrder={"name", "description", "protectionGroupType", "protectionGroups", "recoverySiteLocal", "networks", "calloutSpecs", "keyedVms"})
@XmlRootElement(name="RecoveryPlan")
public class IeRecoveryPlan
extends Configurable {
    private static final long serialVersionUID = 1L;
    private String name;
    private String description;
    private List<String> protectionGroups;
    private ProtectionGroupType protectionGroupType;
    private boolean recoverySiteLocal;
    private List<IeTestNetworkMapping> networks;
    private List<IeCalloutSpec> calloutSpecs;
    private List<String> keyedVms;

    public IeRecoveryPlan() {
    }

    public IeRecoveryPlan(RecoveryPlan.Info info) {
        this.name = info.name;
        this.description = info.description;
        this.protectionGroupType = IeRecoveryPlan.getPgType(info.protectionGroupType);
    }

    @XmlElement(required=false)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlElement(required=false)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @XmlElement(required=false)
    public ProtectionGroupType getProtectionGroupType() {
        return this.protectionGroupType;
    }

    public void setProtectionGroupType(ProtectionGroupType protectionGroupType) {
        this.protectionGroupType = protectionGroupType;
    }

    @XmlElement(required=false, nillable=true)
    public List<String> getProtectionGroups() {
        return this.protectionGroups;
    }

    public void setProtectionGroups(List<String> protectionGroups) {
        this.protectionGroups = protectionGroups;
    }

    public boolean isRecoverySiteLocal() {
        return this.recoverySiteLocal;
    }

    public void setRecoverySiteLocal(boolean recoverySiteLocal) {
        this.recoverySiteLocal = recoverySiteLocal;
    }

    @XmlElementRef(required=false)
    public List<IeTestNetworkMapping> getNetworks() {
        return this.networks;
    }

    public void setNetworks(List<IeTestNetworkMapping> networks) {
        this.networks = networks;
    }

    @XmlElementRef(required=false)
    @XmlElementWrapper(name="callouts")
    public List<IeCalloutSpec> getCalloutSpecs() {
        if (CollectionUtils.isEmpty(this.calloutSpecs)) {
            return null;
        }
        return this.calloutSpecs;
    }

    public void setCalloutSpecs(List<IeCalloutSpec> calloutSpecs) {
        this.calloutSpecs = calloutSpecs;
    }

    @XmlElement(required=false, nillable=true)
    public List<String> getKeyedVms() {
        return this.keyedVms;
    }

    public void setKeyedVms(List<String> keyedVms) {
        this.keyedVms = keyedVms;
    }

    private static ProtectionGroupType getPgType(RecoveryPlan.ProtectionGroupType pgType) {
        if (pgType == null) {
            return null;
        }
        ProtectionGroupType iePgType = null;
        switch (pgType) {
            case vmGroup: {
                iePgType = ProtectionGroupType.vmGroup;
                break;
            }
            case spGroup: {
                iePgType = ProtectionGroupType.spGroup;
            }
        }
        return iePgType;
    }

    public static enum ProtectionGroupType {
        vmGroup,
        spGroup;

    }
}

