/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.exporters.groups;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.srm.client.impex.configurables.Configurable;
import com.vmware.srm.client.impex.configurables.folders.IeFolder;
import com.vmware.srm.client.impex.configurables.groups.IeProtectionGroup;
import com.vmware.srm.client.impex.configurables.groups.IeSpProtectionGroup;
import com.vmware.srm.client.impex.configurables.groups.IeVmProtectionGroup;
import com.vmware.srm.client.impex.configurables.groups.SpProtectionGroupConverter;
import com.vmware.srm.client.impex.configurables.groups.VmProtectionGroupConverter;
import com.vmware.srm.client.impex.exporters.Exporter;
import com.vmware.srm.client.impex.tool.IdBuilder;
import com.vmware.srm.client.impex.tool.ImpexExportSrmContext;
import com.vmware.srm.client.infrastructure.pc.utils.PcResult;
import com.vmware.srm.client.topology.client.view.availability.srm.SrmServer;
import com.vmware.srm.client.topology.impl.vmomi.ClientUtils;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ProtectionGroupFolderExporter<V extends IeVmProtectionGroup, S extends IeSpProtectionGroup>
extends Exporter<IeFolder> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProtectionGroupFolderExporter.class);
    protected final ManagedObjectReference rootFolderMoRef = ClientUtils.createMoRef((String)"DrFolder", (String)"DrReplicationRootFolder", (String)((SrmServer)ImpexExportSrmContext.getServersDataWrapper().getLocalPair().server()).guid());

    @Override
    public Promise<List<IeFolder>> getConfigurables() {
        return this.getProtectionGroups().thenCompose(pgPcResult -> this.getSppgExporter((PcResult)pgPcResult).thenCombine(this.getVmpgExporter((PcResult)pgPcResult), (sppgExporter, vmpgExporter) -> {
            IeFolder ieRoot = new IeFolder();
            String name = (String)pgPcResult.getProperty(this.rootFolderMoRef, "name");
            ieRoot.setName(name);
            List<Configurable> children = this.getChildren(this.rootFolderMoRef, (PcResult)pgPcResult, (SpProtectionGroupConverter<S>)sppgExporter, (VmProtectionGroupConverter<V>)vmpgExporter);
            ieRoot.setChildren(children);
            return Collections.singletonList(ieRoot);
        }));
    }

    protected abstract Promise<PcResult> getProtectionGroups();

    protected abstract Promise<SpProtectionGroupConverter<S>> getSppgExporter(PcResult var1);

    protected abstract Promise<VmProtectionGroupConverter<V>> getVmpgExporter(PcResult var1);

    private List<Configurable> getChildren(ManagedObjectReference parent, PcResult pgPcResult, SpProtectionGroupConverter<S> sppgExporter, VmProtectionGroupConverter<V> vmpgExporter) {
        ManagedObjectReference[] childrenMoRefs = (ManagedObjectReference[])pgPcResult.getProperty(parent, "childEntity");
        IdBuilder idBuilder = ImpexExportSrmContext.getIdBuilder();
        return Arrays.stream(childrenMoRefs).map(child -> {
            String type;
            switch (type = child.getType()) {
                case "DrFolder": {
                    List<Configurable> grandChildren = this.getChildren((ManagedObjectReference)child, pgPcResult, sppgExporter, vmpgExporter);
                    IeFolder ieFolder = new IeFolder();
                    String name = (String)pgPcResult.getProperty(child, "name");
                    ieFolder.setName(name);
                    ieFolder.setChildren(grandChildren);
                    return ieFolder;
                }
                case "DrReplicationVmProtectionGroup": {
                    IeProtectionGroup ieVmPg = vmpgExporter.fromVmodl((ManagedObjectReference)child);
                    ieVmPg.setId(idBuilder.buildId((ManagedObjectReference)child));
                    return ieVmPg;
                }
                case "DrReplicationStorageProfileProtectionGroup": {
                    IeProtectionGroup ieSpPg = sppgExporter.fromVmodl((ManagedObjectReference)child);
                    ieSpPg.setId(idBuilder.buildId((ManagedObjectReference)child));
                    return ieSpPg;
                }
            }
            LOGGER.error("Parent '{}' has child: '{}' with unexpected type.", (Object)parent, child);
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

