/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.importers.folders;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.srm.client.impex.utils.TaskUtil;
import com.vmware.srm.client.infrastructure.pc.utils.PcResult;
import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.srm.client.topology.client.vmomi.availability.srm.SrmService;
import com.vmware.vim.binding.dr.Folder;
import com.vmware.vim.binding.dr.fault.DuplicateName;
import com.vmware.vim.binding.vim.fault.InvalidName;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.Future;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FolderImporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(FolderImporter.class);
    protected final SrmService _srmService;
    protected final PcResult _basicElementsPcResult;

    public FolderImporter(SrmService srmService, PcResult basicElementsPcResult) {
        this._srmService = srmService;
        this._basicElementsPcResult = basicElementsPcResult;
    }

    protected Promise<ManagedObjectReference> createFolder(ManagedObjectReference parent, Folder folder, String name) {
        return this.createFolder(folder, name).materialize().thenApply(result -> {
            if (result.isSuccessful()) {
                LOGGER.info("Folder '{}' was created successfully.", (Object)name);
                return (ManagedObjectReference)result.getResult();
            }
            if (result.getError() instanceof DuplicateName) {
                LOGGER.info("Folder '{}' already exists.", (Object)name);
                return this.getExistingFolder(parent, name);
            }
            if (result.getError() instanceof InvalidName) {
                LOGGER.info("Contents from folder '{}' will be mapped to it's parent folder.", (Object)name);
                return this.getExistingFolder(parent, name);
            }
            LOGGER.warn("Failed to create folder '{}', error: '{}'.", (Object)name, (Object)result.getError());
            return null;
        });
    }

    protected Promise<ManagedObjectReference> createFolder(Folder parent, String name) {
        LOGGER.info("Creating Folder '{}'.", (Object)name);
        FuturePromise taskPromise = new FuturePromise();
        parent.createFolder(name, (Future)taskPromise);
        return taskPromise.thenCompose(taskMoRef -> TaskUtil.monitorTask(this._srmService, taskMoRef));
    }

    protected ManagedObjectReference getExistingFolder(ManagedObjectReference folder, String name) {
        ManagedObjectReference[] children = (ManagedObjectReference[])this._basicElementsPcResult.getProperty(folder, "childEntity");
        return Arrays.stream(children).filter(child -> "DrFolder".equals(child.getType())).filter(child -> name.equals(this._basicElementsPcResult.getProperty(child, "name"))).findFirst().orElse(null);
    }
}

