/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.utils;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.srm.client.impex.importers.folders.groups.GroupImporter;
import com.vmware.srm.client.impex.utils.IContextUtil;
import com.vmware.srm.client.infrastructure.pc.utils.ObjectSpecBuilder;
import com.vmware.srm.client.infrastructure.pc.utils.PCUtil;
import com.vmware.srm.client.infrastructure.pc.utils.PcResult;
import com.vmware.srm.client.infrastructure.tuple.Tuple2;
import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.srm.client.topology.client.view.ServersView;
import com.vmware.srm.client.topology.client.view.availability.srm.SrmServersView;
import com.vmware.srm.client.topology.impl.vmomi.ClientUtils;
import com.vmware.vim.binding.dr.replication.ReplicationManager;
import com.vmware.vim.binding.dr.replication.VvolProvider;
import com.vmware.vim.binding.dr.vvolProvider.DomainInfo;
import com.vmware.vim.binding.pbm.profile.Profile;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.query.PropertyCollector;
import com.vmware.vim.constants.dr.replication.PROTECTED_VM;
import com.vmware.vim.constants.dr.replication.PROTECTION_GROUP;
import com.vmware.vim.constants.dr.replication.STORAGE_PROFILE_PROTECTION_GROUP;
import com.vmware.vim.constants.dr.replication.VM_PROTECTION_GROUP;
import com.vmware.vim.vmomi.core.Future;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class GroupUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(GroupUtil.class);

    public static ManagedObjectReference getRootFolder(String guid) {
        return ClientUtils.createMoRef((String)"DrFolder", (String)"DrReplicationRootFolder", (String)guid);
    }

    public static Promise<PcResult> getProtectionGroups(ServersView view, ManagedObjectReference rootFolder, ManagedObjectReference storageManager) {
        return GroupUtil.getProtectionGroups(view, rootFolder, storageManager, new PropsProvider());
    }

    public static Promise<PcResult> getProtectionGroups(ServersView view, ManagedObjectReference rootFolder, ManagedObjectReference storageManager, PropsProvider propsProvider) {
        PropertyCollector.PropertySpec folderSpec = GroupUtil.getFolderSpec();
        PropertyCollector.PropertySpec vmProtectionGroupSpec = PCUtil.createPropertySpec((String)"DrReplicationVmProtectionGroup", (String[])propsProvider.getVmpgProperties());
        PropertyCollector.PropertySpec protectedVmSpec = PCUtil.createPropertySpec((String)"DrReplicationProtectedVm", (String[])new String[]{"placeholderVmInfo", "recoveryLocationSettings", PROTECTED_VM.VM_INFO_.VM});
        PropertyCollector.PropertySpec spProtectionGroupSpec = PCUtil.createPropertySpec((String)"DrReplicationStorageProfileProtectionGroup", (String[])propsProvider.getSppgProperties());
        PropertyCollector.PropertySpec arrayPairSpec = PCUtil.createPropertySpec((String)"DrStorageReplicatedArrayPair", (String[])new String[]{"info", "peer"});
        ObjectSpecBuilder folderSpecBuilder = new ObjectSpecBuilder(rootFolder);
        ObjectSpecBuilder.TraversalSpecBuilder rootTraversal = folderSpecBuilder.traverseTo("childEntity");
        rootTraversal.loopTo(rootTraversal.getName());
        rootTraversal.traverseTo("DrReplicationVmProtectionGroup", "protectedVm");
        ObjectSpecBuilder arrayPairSpecBuilder = new ObjectSpecBuilder(storageManager);
        ObjectSpecBuilder.TraversalSpecBuilder arrayPairTraversal = arrayPairSpecBuilder.traverseTo("arrayManager");
        arrayPairTraversal.traverseTo("arrayPair");
        PropertyCollector.FilterSpec filterSpec = new PropertyCollector.FilterSpec(new PropertyCollector.PropertySpec[]{folderSpec, vmProtectionGroupSpec, protectedVmSpec, spProtectionGroupSpec, arrayPairSpec}, new PropertyCollector.ObjectSpec[]{folderSpecBuilder.build(), arrayPairSpecBuilder.build()}, Boolean.valueOf(true));
        return PCUtil.retrieveProperties((ServersView)view, (PropertyCollector.FilterSpec[])new PropertyCollector.FilterSpec[]{filterSpec});
    }

    public static Promise<PcResult> getBasicProtectionGroupInfo(ServersView view, ManagedObjectReference rootFolder) {
        PropertyCollector.PropertySpec protectionGroupSpec = PCUtil.createPropertySpec((String)"DrReplicationProtectionGroup", (String[])new String[]{PROTECTION_GROUP.BASIC_SETTINGS_.NAME});
        ObjectSpecBuilder specBuilder = new ObjectSpecBuilder(rootFolder);
        ObjectSpecBuilder.TraversalSpecBuilder rootTraversal = specBuilder.traverseTo("childEntity");
        rootTraversal.loopTo(rootTraversal.getName());
        PropertyCollector.PropertySpec folderSpec = GroupUtil.getFolderSpec();
        PropertyCollector.FilterSpec filterSpec = new PropertyCollector.FilterSpec(new PropertyCollector.PropertySpec[]{folderSpec, protectionGroupSpec}, new PropertyCollector.ObjectSpec[]{specBuilder.build()}, Boolean.valueOf(true));
        return PCUtil.retrieveProperties((ServersView)view, (PropertyCollector.FilterSpec[])new PropertyCollector.FilterSpec[]{filterSpec});
    }

    public static ManagedObjectReference getProvider(ManagedObjectReference[] providers, String type) {
        return Arrays.stream(providers).filter(provider -> type.equals(provider.getType())).findFirst().orElseThrow(() -> new NoSuchElementException("Provider of type " + type));
    }

    private static PropertyCollector.PropertySpec getFolderSpec() {
        return PCUtil.createPropertySpec((String)"DrFolder", (String[])new String[]{"name", "childEntity"});
    }

    public static Promise<GroupImporter.GroupsLookup> getGroupsPeers(SrmServersView view, GroupImporter.GroupsLookup groupsLookup) {
        LOGGER.info("Started collecting peer groups.");
        Collection<ManagedObjectReference> groupMoRefs = groupsLookup.values();
        if (CollectionUtils.isEmpty(groupMoRefs)) {
            LOGGER.info("Groups are empty, no peers to collect.");
            return Promises.resolve((Object)new GroupImporter.GroupsLookup(Collections.emptyMap()));
        }
        HashSet<ManagedObjectReference> groups = new HashSet<ManagedObjectReference>(groupMoRefs);
        return PCUtil.retrieveProperties((ServersView)view, groups, (String[])new String[]{PROTECTION_GROUP.PEER_BASIC_INFO_.GROUP}).thenApply(peersPcResult -> new GroupImporter.GroupsLookup(groupsLookup.keySet().stream().map(key -> {
            ManagedObjectReference peerMoRef = (ManagedObjectReference)peersPcResult.tryGetProperty((ManagedObjectReference)groupsLookup.get(key), PROTECTION_GROUP.PEER_BASIC_INFO_.GROUP, e -> {
                LOGGER.info("Could not get peer group of '{}', reason: {}", groupsLookup.get(key), (Object)e.getCause());
                return null;
            });
            if (Objects.isNull(peerMoRef)) {
                return null;
            }
            return new Tuple2(key, (Object)peerMoRef);
        }).filter(Objects::nonNull).collect(Collectors.toMap(Tuple2::getFirst, Tuple2::getSecond)))).thenApply(result -> {
            LOGGER.info("Done collecting peer groups.");
            return result;
        });
    }

    public static ReplicationManager getReplicationManager(boolean local) {
        return (ReplicationManager)IContextUtil.getSrmService(local).createStub(IContextUtil.getSrmContent(local).getReplicationManager());
    }

    public static Promise<ManagedObjectReference[]> getProviders(boolean local) {
        FuturePromise providersPromise = new FuturePromise();
        GroupUtil.getReplicationManager(local).getReplicationProvider((Future)providersPromise);
        return providersPromise;
    }

    public static Promise<DomainInfo[]> getDomainInfos(boolean local) {
        return GroupUtil.getProviders(local).thenCompose(providers -> {
            ManagedObjectReference provider;
            if (ArrayUtils.isEmpty((Object[])providers)) {
                LOGGER.debug("No domain infos due to no available providers. Local: '{}'.", (Object)local);
                return Promises.resolve((Object)new DomainInfo[0]);
            }
            try {
                provider = GroupUtil.getProvider(providers, "DrReplicationVvolProvider");
            }
            catch (NoSuchElementException e) {
                LOGGER.debug("No domain infos due to missing vVol provider. Local: '{}'. Providers: '{}'", (Object)local, (Object)Arrays.toString(providers));
                return Promises.resolve((Object)new DomainInfo[0]);
            }
            VvolProvider vvolProvider = (VvolProvider)IContextUtil.getSrmService(local).createStub(provider);
            if (vvolProvider == null) {
                LOGGER.debug("No domain infos due to no available vVol provider. Local: '{}'.", (Object)local);
                return Promises.resolve((Object)new DomainInfo[0]);
            }
            FuturePromise domainInfosFp = new FuturePromise();
            vvolProvider.getDomains((Future)domainInfosFp);
            return domainInfosFp;
        });
    }

    public static Map<String, String> buildProfileIdToName(Profile[] profiles) {
        return ArrayUtils.isEmpty((Object[])profiles) ? Collections.emptyMap() : Arrays.stream(profiles).collect(Collectors.toMap(profile -> profile.profileId.uniqueId, profile -> profile.name));
    }

    public static class PropsProvider {
        protected String[] getVmpgProperties() {
            return new String[]{"state", "basicSettings", "provider", "providerDetails", VM_PROTECTION_GROUP.PEER_.PROVIDER_DETAILS, "protectedVm"};
        }

        protected String[] getSppgProperties() {
            return new String[]{"state", "basicSettings", STORAGE_PROFILE_PROTECTION_GROUP.SETTINGS_.STORAGE_PROFILE};
        }
    }
}

