/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.client;

import com.vmware.vapi.bindings.StubConfiguration;
import com.vmware.vapi.internal.util.Validate;
import com.vmware.vapi.protocol.HttpConfiguration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class Configuration {
    private Map<String, Object> configProps;
    public static final String HTTP_CONFIG_CFG = "http.client.config";
    public static final String STUB_CONFIG_CFG = "vapi.stub.config";

    protected Configuration(Map<String, Object> props) {
        Validate.notNull(props);
        this.configProps = new HashMap<String, Object>(props);
    }

    public Set<String> properties() {
        return Collections.unmodifiableSet(this.configProps.keySet());
    }

    public <T> T getProperty(String propName, Class<T> propClass) {
        Validate.notNull(propName);
        Validate.notNull(propClass);
        Object value = this.configProps.get(propName);
        if (value == null) {
            return null;
        }
        if (!propClass.isAssignableFrom(value.getClass())) {
            throw new ClassCastException("Unexpected class for property: " + propName);
        }
        return propClass.cast(value);
    }

    protected Map<String, Object> getAllProperties() {
        return Collections.unmodifiableMap(this.configProps);
    }

    public static Configuration newEmptyConfig() {
        return new Builder().build();
    }

    public static Configuration newHttpConfig(HttpConfiguration httpConfig) {
        return new Builder().register(HTTP_CONFIG_CFG, httpConfig).build();
    }

    public static Configuration newStubConfig(StubConfiguration stubConfig) {
        return new Builder().register(STUB_CONFIG_CFG, stubConfig).build();
    }

    public static final class Builder {
        private Map<String, Object> configProps;

        public Builder() {
            this(new HashMap<String, Object>());
        }

        public Builder(Configuration config) {
            this(config.getAllProperties());
        }

        public Builder(Map<String, Object> properties) {
            Validate.notNull(properties);
            this.configProps = new HashMap<String, Object>(properties);
        }

        public Builder register(String propName, Object value) {
            Validate.notNull(propName);
            Validate.notNull(value);
            this.configProps.put(propName, value);
            return this;
        }

        public Configuration build() {
            return new Configuration(this.configProps);
        }
    }
}

