/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.bindings;

import com.vmware.vapi.CoreException;
import com.vmware.vapi.Message;
import com.vmware.vapi.MessageFactory;
import com.vmware.vapi.bindings.DynamicStructure;
import com.vmware.vapi.bindings.DynamicStructureImpl;
import com.vmware.vapi.bindings.StaticStructure;
import com.vmware.vapi.bindings.Structure;
import com.vmware.vapi.bindings.convert.ConverterException;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.Type;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.bindings.TypeConverter;
import com.vmware.vapi.internal.bindings.TypeConverterImpl;
import com.vmware.vapi.internal.bindings.convert.impl.JavaUtilCalendarDateTimeConverter;
import com.vmware.vapi.internal.util.Validate;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;

public final class BindingsUtil {
    private static final TypeConverter converter = new TypeConverterImpl();
    private static final JavaUtilCalendarDateTimeConverter calendarConverter = new JavaUtilCalendarDateTimeConverter();
    private static final String SINGLE_INDENT = "    ";
    private static final ThreadLocal<SimpleDateFormat> dateTimeFormatter = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("M/d/yy HH:mm:ss Z");
        }
    };
    private static final TimeZone defaultTimeZone = TimeZone.getDefault();

    private BindingsUtil() {
    }

    public static boolean areEqual(StaticStructure leftStruct, Object rightStruct) {
        Set<String> rightDynamicFields;
        if (leftStruct == null) {
            return rightStruct == null;
        }
        if (leftStruct == rightStruct) {
            return true;
        }
        if (rightStruct == null) {
            return false;
        }
        if (leftStruct.getClass() != rightStruct.getClass()) {
            return false;
        }
        StaticStructure staticRightStruct = (StaticStructure)rightStruct;
        for (String field : leftStruct._getType().getFieldNames()) {
            Object right;
            Method getter = leftStruct._getType().getGetterMethodForField(field);
            Object left = BindingsUtil.invokeGetter(getter, leftStruct);
            if (BindingsUtil.compareStructureField(left, right = BindingsUtil.invokeGetter(getter, staticRightStruct))) continue;
            return false;
        }
        Set<String> leftDynamicFieldNames = leftStruct._getDynamicFieldNames();
        if (!leftDynamicFieldNames.equals(rightDynamicFields = staticRightStruct._getDynamicFieldNames())) {
            return false;
        }
        for (String fieldName : leftDynamicFieldNames) {
            DataValue rightValue;
            DataValue leftValue = leftStruct._getDynamicField(fieldName);
            if (leftValue.equals(rightValue = staticRightStruct._getDynamicField(fieldName))) continue;
            return false;
        }
        return true;
    }

    private static boolean compareStructureField(Object left, Object right) {
        if (left == null ^ right == null) {
            return false;
        }
        if (left == right) {
            return true;
        }
        if (left.getClass() == char[].class) {
            if (right.getClass() != char[].class || !Arrays.equals((char[])left, (char[])right)) {
                return false;
            }
        } else if (left.getClass() == byte[].class) {
            if (right.getClass() != byte[].class || !Arrays.equals((byte[])left, (byte[])right)) {
                return false;
            }
        } else if (left instanceof Calendar) {
            if (!calendarConverter.toValue(left).equals(calendarConverter.toValue(right))) {
                return false;
            }
        } else if (left instanceof List) {
            List leftList = (List)left;
            List rightList = (List)right;
            if (leftList.size() != rightList.size()) {
                return false;
            }
            for (int i = 0; i < leftList.size(); ++i) {
                if (BindingsUtil.compareStructureField(leftList.get(i), rightList.get(i))) continue;
                return false;
            }
        } else if (left instanceof Map) {
            Map leftMap = (Map)left;
            Map rightMap = (Map)right;
            if (!leftMap.keySet().equals(rightMap.keySet())) {
                return false;
            }
            for (Object key : leftMap.keySet()) {
                if (BindingsUtil.compareStructureField(leftMap.get(key), rightMap.get(key))) continue;
                return false;
            }
        } else if (!left.equals(right)) {
            return false;
        }
        return true;
    }

    private static int generateHashCode(Object value) {
        if (value == null) {
            return 0;
        }
        int hashCode = 1;
        if (value.getClass() == char[].class) {
            hashCode = Arrays.hashCode((char[])value);
        } else if (value.getClass() == byte[].class) {
            hashCode = Arrays.hashCode((byte[])value);
        } else if (value instanceof Calendar) {
            hashCode = calendarConverter.toValue(value).hashCode();
        } else if (value instanceof List) {
            List list = (List)value;
            for (int i = 0; i < list.size(); ++i) {
                hashCode = 31 * hashCode + BindingsUtil.generateHashCode(list.get(i));
            }
        } else if (value instanceof Map) {
            Map map = (Map)value;
            for (Map.Entry e : map.entrySet()) {
                hashCode += Objects.hashCode(e.getKey()) ^ BindingsUtil.generateHashCode(e.getValue());
            }
        } else {
            hashCode = 31 * hashCode + value.hashCode();
        }
        return hashCode;
    }

    public static int computeHashCode(StaticStructure struct) {
        if (struct == null) {
            throw new NullPointerException();
        }
        StructType type = struct._getType();
        int hashCode = type.getName().hashCode();
        for (String field : type.getFieldNames()) {
            Method getter = type.getGetterMethodForField(field);
            Object value = BindingsUtil.invokeGetter(getter, struct);
            hashCode += field.hashCode() ^ Objects.hashCode(BindingsUtil.generateHashCode(value));
        }
        for (String fieldName : struct._getDynamicFieldNames()) {
            hashCode += Objects.hashCode(fieldName) ^ Objects.hashCode(struct._getDynamicField(fieldName));
        }
        return hashCode;
    }

    private static Object invokeGetter(Method getter, StaticStructure struct) {
        try {
            return getter.invoke((Object)struct, new Object[0]);
        }
        catch (Exception e) {
            throw new CoreException("vapi.bindings.structbinding.struct.getter.error", getter.getName(), struct.getClass().getCanonicalName());
        }
    }

    public static String convertToString(StaticStructure struct, StructValue dynamicFields) {
        return BindingsUtil.convertToString(struct, dynamicFields, 1);
    }

    static String convertToString(StaticStructure struct, StructValue dynamicFields, int indent) {
        Validate.notNull(struct);
        Validate.isTrue(indent >= 0);
        StructType type = struct._getType();
        StringBuilder result = new StringBuilder();
        result.append(struct.getClass().getSimpleName());
        result.append(" (").append(type.getName()).append(")");
        result.append(" => {\n");
        boolean isFirst = true;
        for (String field : type.getFieldNames()) {
            StructType.FieldNameDetails fnd = type.getFieldNameDetails(field);
            Method getter = type.getGetterMethodForField(field);
            Object value = BindingsUtil.invokeGetter(getter, struct);
            if (isFirst) {
                isFirst = false;
            } else {
                result.append(",\n");
            }
            BindingsUtil.writeIndentation(indent, result);
            result.append(fnd.getMixedCaseName()).append(" = ");
            BindingsUtil.appendObject(value, indent + 1, result);
        }
        if (dynamicFields != null) {
            BindingsUtil.printDynamicFields(dynamicFields, indent, type, result);
        }
        result.append("\n");
        BindingsUtil.writeIndentation(indent - 1, result);
        result.append("}");
        return result.toString();
    }

    private static void printDynamicFields(StructValue dynamicFields, int indent, StructType type, StringBuilder output) {
        boolean isFirst = true;
        for (String field : dynamicFields.getFieldNames()) {
            if (type.getFieldNames().contains(field)) continue;
            if (isFirst) {
                output.append("\n");
                BindingsUtil.writeIndentation(indent, output);
                output.append("[dynamic fields]: {\n");
                isFirst = false;
            } else {
                output.append(",\n");
            }
            BindingsUtil.writeIndentation(indent + 1, output);
            output.append(field);
            output.append(" = ");
            output.append(dynamicFields.getField(field));
        }
        if (!isFirst) {
            output.append("\n");
            BindingsUtil.writeIndentation(indent, output);
            output.append("}");
        }
    }

    private static void writeIndentation(int indent, StringBuilder output) {
        for (int i = 0; i < indent; ++i) {
            output.append(SINGLE_INDENT);
        }
    }

    private static void appendObject(Object value, int indent, StringBuilder output) {
        Validate.isTrue(indent >= 0);
        if (value == null) {
            output.append("<null>");
        } else if (value instanceof Calendar) {
            BindingsUtil.appendCalendar((Calendar)value, output);
        } else if (value.getClass() == char[].class) {
            output.append("<secret>");
        } else if (value.getClass() == byte[].class) {
            output.append("<array of ");
            output.append(((byte[])value).length);
            output.append(" bytes>");
        } else if (value instanceof StaticStructure) {
            StaticStructure staticStruct = (StaticStructure)value;
            output.append(BindingsUtil.convertToString(staticStruct, staticStruct._getDataValue(), indent));
        } else {
            output.append(value.toString());
        }
    }

    private static void appendCalendar(Calendar cal, StringBuilder output) {
        TimeZone targetZone = null;
        targetZone = cal.getTimeZone() != null ? cal.getTimeZone() : defaultTimeZone;
        dateTimeFormatter.get().setTimeZone(targetZone);
        output.append(dateTimeFormatter.get().format(cal.getTime()));
    }

    public static boolean hasTypeNameOf(StructValue structValue, Class<? extends Structure> targetBindingClass) {
        Validate.notNull(structValue);
        Validate.notNull(targetBindingClass);
        if (DynamicStructure.class.isAssignableFrom(targetBindingClass)) {
            return false;
        }
        if (!StaticStructure.class.isAssignableFrom(targetBindingClass)) {
            throw new IllegalArgumentException(String.format("Unknown structure binding class '%s'", targetBindingClass.getCanonicalName()));
        }
        Class<? extends Structure> staticStructClass = targetBindingClass;
        StructType targetType = BindingsUtil.extractBindingType(staticStructClass);
        return BindingsUtil.matchesStructValueName(structValue, targetType) || BindingsUtil.matchesDiscriminatorValue(structValue, targetType);
    }

    static boolean matchesStructValueName(StructValue structValue, StructType targetType) {
        return targetType.getName().equals(structValue.getName());
    }

    static boolean matchesDiscriminatorValue(StructValue structValue, StructType targetType) {
        String discrBy = targetType.getDiscriminatedBy();
        if (discrBy == null) {
            return false;
        }
        String discriminator = targetType.getDiscriminator();
        if (!structValue.hasField(discriminator)) {
            return false;
        }
        return discrBy.equals(structValue.getString(discriminator));
    }

    public static <T extends Structure> T convertTo(Structure struct, Class<T> clazz) {
        return BindingsUtil.convertTo(struct, clazz, null);
    }

    public static <T extends Structure> T convertTo(Structure struct, Class<T> clazz, TypeConverter converter) {
        Validate.notNull(struct);
        Validate.notNull(clazz);
        if (clazz == DynamicStructure.class) {
            return (T)((Structure)clazz.cast(new DynamicStructureImpl(struct._getDataValue(), converter)));
        }
        if (StaticStructure.class.isAssignableFrom(clazz)) {
            StructType targetType = BindingsUtil.extractBindingType(clazz);
            if (converter == null) {
                converter = new TypeConverterImpl(true);
            }
            Structure staticStructure = (Structure)converter.convertToJava(struct._getDataValue().copy(), targetType);
            return (T)((Structure)clazz.cast(staticStructure));
        }
        throw new IllegalArgumentException("Unknown structure type " + clazz.getName());
    }

    public static <T extends StaticStructure> StructType extractBindingType(Class<T> targetClass) {
        Validate.notNull(targetClass);
        StructType structType = null;
        try {
            structType = (StructType)targetClass.getMethod("_getClassType", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can not extract type information from non-binding object.", e);
        }
        if (structType == null) {
            throw new IllegalArgumentException(String.format("Structure binding class '%s' provides no type information", targetClass.getCanonicalName()));
        }
        return structType;
    }

    public static DataValue toDataValue(Object object, Type type) {
        return converter.convertToVapi(object, type);
    }

    public static Object getStructureFieldValue(StaticStructure structure, StructType declaredType, String fieldName) {
        Method getterMethod = declaredType.getGetterMethodForField(fieldName);
        try {
            return getterMethod.invoke((Object)structure, new Object[0]);
        }
        catch (Exception ex) {
            Message msg = MessageFactory.getMessage("vapi.bindings.structbinding.struct.getter.error", getterMethod.getName(), structure.getClass().getCanonicalName());
            throw new ConverterException(msg, (Throwable)ex);
        }
    }

    public static void setStructureFieldValue(StaticStructure structure, StructType declaredType, String fieldName, Object fieldValue) {
        Method setterMethod = declaredType.getSetterMethodForField(fieldName);
        try {
            setterMethod.invoke((Object)structure, fieldValue);
        }
        catch (Exception ex) {
            String fieldValueClass = fieldValue != null ? fieldValue.getClass().getCanonicalName() : "null";
            Message msg = MessageFactory.getMessage("vapi.bindings.structbinding.struct.set.field.error", setterMethod.getName(), structure.getClass().getCanonicalName(), fieldValueClass);
            throw new ConverterException(msg, (Throwable)ex);
        }
    }
}

