/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.bindings;

import com.vmware.vapi.bindings.type.Type;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.Consumer;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.bindings.ResultTranslatingHandle;
import com.vmware.vapi.internal.bindings.Stub;
import java.util.Collection;

abstract class RetryingHandle<T>
extends ResultTranslatingHandle<T> {
    private final ResultTranslatingHandle<T> decoratedHandle;
    private final String serviceId;
    private final String operationId;
    private final ExecutionContext executionContext;
    private final StructValue inputValue;
    private final int invocationAttempt;

    RetryingHandle(Stub stub, Type outputType, Collection<Type> errorTypes, ResultTranslatingHandle<T> decoratedHandle, String serviceId, String operationId, ExecutionContext executionContext, StructValue inputValue, int invocationAttempt) {
        super(stub, outputType, errorTypes);
        this.decoratedHandle = decoratedHandle;
        this.serviceId = serviceId;
        this.operationId = operationId;
        this.executionContext = executionContext;
        this.inputValue = inputValue;
        this.invocationAttempt = invocationAttempt;
    }

    @Override
    public void updateProgress(DataValue progress) {
        this.decoratedHandle.updateProgress(progress);
    }

    @Override
    void onSuccess(T result, Consumer<AsyncHandle<MethodResult>> next) {
        this.decoratedHandle.onSuccess(result, next);
    }

    @Override
    void onFailure(RuntimeException error) {
        ExecutionContext ctx = this.stub.getRetryContext(this.serviceId, this.operationId, this.executionContext, this.inputValue, error, this.invocationAttempt);
        if (ctx == null) {
            this.decoratedHandle.onFailure(error);
            return;
        }
        this.onRetry(ctx);
    }

    abstract void onRetry(ExecutionContext var1);
}

