/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.client;

import com.vmware.vapi.bindings.Service;
import com.vmware.vapi.bindings.StubConfiguration;
import com.vmware.vapi.bindings.StubConfigurationBase;
import com.vmware.vapi.bindings.StubFactory;
import com.vmware.vapi.client.ApiClient;
import com.vmware.vapi.client.Configuration;
import com.vmware.vapi.core.ApiProvider;
import com.vmware.vapi.internal.client.Protocol;
import com.vmware.vapi.internal.protocol.client.rpc.http.ApacheBioHttpClientBuilder;
import com.vmware.vapi.internal.util.Validate;
import com.vmware.vapi.protocol.HttpConfiguration;
import java.io.IOException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.CloseableHttpClient;

public final class ApiClientImpl
implements ApiClient {
    private final Configuration config;
    private final String url;
    private final Protocol protocol;
    private final StubConfigurationBase stubConfig;
    private CloseableHttpClient bioHttpClient;
    private ApacheBioHttpClientBuilder bioHttpClientBuilder;
    private final ApiProvider apiProvider;

    public ApiClientImpl(String url, Protocol protocol, Configuration config) {
        Validate.notNull(url);
        Validate.notNull(protocol);
        Validate.notNull(config);
        this.url = url;
        this.config = config;
        this.protocol = protocol;
        this.stubConfig = config.getProperty("vapi.stub.config", StubConfiguration.class);
        this.prepareSharedTransport(config);
        this.apiProvider = this.prepareSharedApiProvider();
    }

    @Override
    public <T extends Service> T createStub(Class<T> vapiIface) {
        return this.createStub(vapiIface, null);
    }

    @Override
    public <T extends Service> T createStub(Class<T> vapiIface, StubConfigurationBase stubConfiguration) {
        StubConfigurationBase effectiveStubConfig = stubConfiguration != null ? stubConfiguration : this.stubConfig;
        StubFactory stubFactory = new StubFactory(this.findRestApiProvider(vapiIface), this.protocol.getTypeConverter(effectiveStubConfig));
        return stubFactory.createStub(vapiIface, effectiveStubConfig);
    }

    @Override
    public void close() throws IOException {
        if (this.bioHttpClient != null) {
            this.bioHttpClient.close();
        }
    }

    final ApiProvider prepareSharedApiProvider() {
        if (this.protocol.getApiProviderCardinality() == Protocol.ApiProviderCardinality.SINGLE) {
            return this.buildApiProvider(null);
        }
        return null;
    }

    final void prepareSharedTransport(Configuration config) {
        HttpConfiguration httpConfig = config.getProperty("http.client.config", HttpConfiguration.class);
        if (httpConfig == null) {
            httpConfig = new HttpConfiguration.Builder().getConfig();
        }
        switch (httpConfig.getLibraryType()) {
            case APACHE_HTTP_ASYNC_CLIENT: {
                throw new RuntimeException("NIO Apache Client is not supported yet!");
            }
            case APACHE_HTTP_CLIENT: {
                this.bioHttpClientBuilder = new ApacheBioHttpClientBuilder();
                this.bioHttpClient = this.bioHttpClientBuilder.buildAndConfigure(httpConfig);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported library type: " + (Object)((Object)httpConfig.getLibraryType()));
            }
        }
    }

    ApiProvider findRestApiProvider(Class<? extends Service> vapiIface) {
        if (this.apiProvider != null) {
            return this.apiProvider;
        }
        return this.buildApiProvider(vapiIface);
    }

    ApiProvider buildApiProvider(Class<? extends Service> vapiIface) {
        RequestConfig defaultRequestConfig;
        Configuration.Builder enhancedConfig = new Configuration.Builder(this.config);
        if (this.bioHttpClient != null) {
            enhancedConfig.register("apache.bio.http.client", this.bioHttpClient);
        }
        if ((defaultRequestConfig = this.bioHttpClientBuilder.getDefaultRequestConfig()) != null) {
            enhancedConfig.register("apache.http.request.config", defaultRequestConfig);
        }
        if (vapiIface != null) {
            enhancedConfig.register("vapi.interface", vapiIface);
        }
        return this.protocol.getProtocolConnection(this.url, enhancedConfig.build()).getApiProvider();
    }
}

