/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.client.rest.authn;

import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.internal.protocol.client.rpc.HttpRequest;
import com.vmware.vapi.protocol.client.http.RequestPreProcessor;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicAuthenticationAppender
implements RequestPreProcessor {
    private static final Logger logger = LoggerFactory.getLogger(BasicAuthenticationAppender.class);

    @Override
    public HttpRequest handle(String serviceId, String operationId, HttpRequest request, DataValue params, ExecutionContext context) {
        logger.trace("Trying to append HTTP Basic Authorization header to request: {} {}", (Object)request.getUrl(), (Object)request.getMethod());
        ExecutionContext.SecurityContext securityContext = context.retrieveSecurityContext();
        if (securityContext == null) {
            logger.debug("No security context available - HTTP Basic Authorization header will not be added to request: {} {}", (Object)request.getUrl(), (Object)request.getMethod());
            return request;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("SecurityContext properties: {}", securityContext.getAllProperties().keySet());
        }
        Object authnSchemeId = securityContext.getProperty("authn_scheme_id");
        logger.trace("Authentication scheme is {}.", authnSchemeId);
        if (!"com.vmware.vapi.std.security.user_pass".equals(authnSchemeId)) {
            logger.debug("Security scheme is not User Pass - HTTP Basic Authorization header will not be added to request: {} {}", (Object)request.getUrl(), (Object)request.getMethod());
            return request;
        }
        String username = (String)securityContext.getProperty("userName");
        char[] password = (char[])securityContext.getProperty("password");
        if (username == null || password == null) {
            logger.warn("Either username or password is missing from security context - HTTP Basic Authorization header will not be added to request: {} {}", (Object)request.getUrl(), (Object)request.getMethod());
            return request;
        }
        return BasicAuthenticationAppender.addAuthorizationHeader(username, password, request);
    }

    private static HttpRequest addAuthorizationHeader(String username, char[] password, HttpRequest request) {
        String authString = username + ":" + new String(password);
        String authEncodedString = Base64.encodeBase64String((byte[])authString.getBytes(StandardCharsets.UTF_8));
        String headerValue = String.format("Basic %s", authEncodedString);
        request.addHeader("Authorization", headerValue);
        logger.debug("HTTP Basic Authorization header appended successfully to request: {} {}.", (Object)request.getUrl(), (Object)request.getMethod());
        return request;
    }
}

