/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.client.rpc.http;

import com.vmware.vapi.internal.protocol.client.rpc.http.ApacheClientHeadersProvider;
import com.vmware.vapi.internal.protocol.client.rpc.http.ApacheHttpUtil;
import com.vmware.vapi.internal.protocol.client.rpc.http.ConnectionMonitor;
import com.vmware.vapi.internal.protocol.client.rpc.http.SslClientUtil;
import com.vmware.vapi.protocol.HttpConfiguration;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheBioHttpClientBuilder {
    private static final String HTTP_SHEME = "http";
    private static final String HTTPS_SHEME = "https";
    private PoolingHttpClientConnectionManager connManager;
    private RequestConfig defaultRequestConfig;
    private static Logger logger = LoggerFactory.getLogger(ApacheBioHttpClientBuilder.class);
    private ConnectionMonitor.CleanableConnectionPool pool;

    public RequestConfig getDefaultRequestConfig() {
        return this.defaultRequestConfig;
    }

    public HttpClientConnectionManager getConnectionManager() {
        return this.connManager;
    }

    public CloseableHttpClient buildAndConfigure(final HttpConfiguration httpConfig) {
        this.connManager = this.createConnectionManager(httpConfig);
        this.defaultRequestConfig = ApacheHttpUtil.createDefaultRequestConfig(httpConfig);
        HttpClientBuilder builder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.connManager).setUserAgent(ApacheHttpUtil.VAPI_USER_AGENT).setDefaultRequestConfig(this.defaultRequestConfig);
        builder.setKeepAliveStrategy(new ConnectionKeepAliveStrategy(){

            public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                return httpConfig.getKeepAlivePeriod();
            }
        });
        builder.setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy());
        HttpConfiguration.HeadersProvider headersProvider = httpConfig.getHeadersProvider();
        if (headersProvider != null) {
            builder.addInterceptorFirst((HttpRequestInterceptor)new ApacheClientHeadersProvider(headersProvider));
        }
        return builder.build();
    }

    public ConnectionMonitor.CleanableConnectionPool registerClientWithConnectionMonitor() {
        if (this.connManager == null) {
            throw new IllegalStateException();
        }
        if (this.pool == null) {
            this.pool = new ConnectionMonitor.CleanableConnectionPool(){

                @Override
                public void closeExpiredConnections() {
                    ApacheBioHttpClientBuilder.this.connManager.closeExpiredConnections();
                }
            };
            ConnectionMonitor.register(this.pool);
        } else {
            logger.warn("Unable to register client more than once!");
        }
        return this.pool;
    }

    private PoolingHttpClientConnectionManager createConnectionManager(HttpConfiguration httpConfig) {
        Registry<ConnectionSocketFactory> registry = this.createConnectionSocketFactoryRegistry(httpConfig.getSslConfiguration());
        PoolingHttpClientConnectionManager result = new PoolingHttpClientConnectionManager(registry);
        result.setMaxTotal(httpConfig.getMaxConnections());
        result.setDefaultMaxPerRoute(httpConfig.getMaxConnections());
        return result;
    }

    private Registry<ConnectionSocketFactory> createConnectionSocketFactoryRegistry(HttpConfiguration.SslConfiguration sslConfig) {
        X509HostnameVerifier hostnameVerifier = SslClientUtil.createHostnameVerifier(sslConfig.isHostnameVerificationDisabled(), SSLConnectionSocketFactory.STRICT_HOSTNAME_VERIFIER);
        return RegistryBuilder.create().register(HTTP_SHEME, (Object)PlainConnectionSocketFactory.INSTANCE).register(HTTPS_SHEME, (Object)new SSLConnectionSocketFactory(SslClientUtil.createSslContext(sslConfig), sslConfig.getEnabledProtocols(), sslConfig.getEnabledCipherSuites(), hostnameVerifier)).build();
    }
}

