/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.client.rpc.http;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConnectionMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectionMonitor.class);
    public static final String THREAD_NAME_PROP = "com.vmware.vapi.internal.protocol.client.http.cleanupThreadName";
    public static final String DEFAULT_THREAD_NAME = "vAPI-client-connection-monitor";
    public static final String CLEANUP_PERIOD_IN_SECONDS_PROP = "com.vmware.vapi.internal.protocol.client.http.cleanupPeriod";
    public static final int DEFAULT_CLEANUP_PERIOD_IN_SECONDS = 30;
    public static final String KEEP_ALIVE_IN_SECONDS_PROP = "com.vmware.vapi.internal.protocol.client.http.keepAlive";
    public static final int DEFAULT_KEEP_ALIVE_IN_SECONDS = 45;
    private static volatile boolean initialized = false;
    private static final ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            String name = System.getProperty(ConnectionMonitor.THREAD_NAME_PROP, ConnectionMonitor.DEFAULT_THREAD_NAME);
            if (LOG.isTraceEnabled()) {
                LOG.debug(String.format("Starting thread %s to monitor for expired connections", name));
            }
            Thread t = new Thread(r, name);
            t.setDaemon(true);
            return t;
        }
    });
    private static final ConcurrentLinkedQueue<WeakReference<CleanableConnectionPool>> connectionPools;
    private static ScheduledFuture<?> task;

    ConnectionMonitor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(CleanableConnectionPool pool) {
        if (pool == null) {
            throw new NullPointerException("pool cannot be null");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("A connection pool (%h) is being added for monitoring", pool));
        }
        ConcurrentLinkedQueue<WeakReference<CleanableConnectionPool>> concurrentLinkedQueue = connectionPools;
        synchronized (concurrentLinkedQueue) {
            connectionPools.add(new WeakReference<CleanableConnectionPool>(pool));
            ConnectionMonitor.initialize();
        }
    }

    private static void initialize() {
        if (initialized) {
            return;
        }
        LOG.debug("Starting to monitor connection pools for expired connections");
        Integer period = Integer.getInteger(CLEANUP_PERIOD_IN_SECONDS_PROP, 30);
        task = executor.scheduleAtFixedRate(new ConnectionCleaner(), period.intValue(), period.intValue(), TimeUnit.SECONDS);
        initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void reset() {
        ConcurrentLinkedQueue<WeakReference<CleanableConnectionPool>> concurrentLinkedQueue = connectionPools;
        synchronized (concurrentLinkedQueue) {
            connectionPools.clear();
            ConnectionMonitor.stop();
        }
    }

    private static void stop() {
        if (!initialized || !connectionPools.isEmpty()) {
            return;
        }
        LOG.trace("Stopping connection monitoring");
        initialized = false;
        task.cancel(false);
        executor.getQueue().remove(task);
        task = null;
    }

    static {
        Integer keepAlive = Integer.getInteger(KEEP_ALIVE_IN_SECONDS_PROP, 45);
        executor.setKeepAliveTime(keepAlive.intValue(), TimeUnit.SECONDS);
        executor.allowCoreThreadTimeOut(true);
        connectionPools = new ConcurrentLinkedQueue();
    }

    static interface CleanableConnectionPool {
        public void closeExpiredConnections();
    }

    private static class ConnectionCleaner
    implements Runnable {
        private ConnectionCleaner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block6: {
                try {
                    LOG.trace("Starting to clean-up expired vAPI-client connections");
                    int cleanedUp = this.closeConnections();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(String.format("Cleaned-up %s connection pool(s)", cleanedUp));
                    }
                    if (cleanedUp != 0) break block6;
                    ConcurrentLinkedQueue concurrentLinkedQueue = connectionPools;
                    synchronized (concurrentLinkedQueue) {
                        ConnectionMonitor.stop();
                    }
                }
                catch (RuntimeException e) {
                    LOG.error("An exception occured while iterating over thevAPI-client connection pools", (Throwable)e);
                }
            }
        }

        private int closeConnections() {
            int i = 0;
            int cleanedUp = 0;
            Iterator cpIterator = connectionPools.iterator();
            while (cpIterator.hasNext() && !Thread.currentThread().isInterrupted()) {
                block6: {
                    ++i;
                    WeakReference cpRef = (WeakReference)cpIterator.next();
                    CleanableConnectionPool cp = (CleanableConnectionPool)cpRef.get();
                    if (cp == null) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace(String.format("Removing GCed connection pool at position %s of the pools queue", i - 1));
                        }
                        cpIterator.remove();
                        continue;
                    }
                    if (LOG.isTraceEnabled()) {
                        LOG.trace(String.format("Closing expired connections for pool %h", cp));
                    }
                    try {
                        cp.closeExpiredConnections();
                    }
                    catch (RuntimeException e) {
                        if (!LOG.isWarnEnabled()) break block6;
                        LOG.warn(String.format("Unable to clean-up expired connections for pool %h", cp), (Throwable)e);
                    }
                }
                ++cleanedUp;
            }
            return cleanedUp;
        }
    }
}

