/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.provider.introspection;

import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.ErrorValueException;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.DataValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class IntrospectionAsyncHandle<T>
extends AsyncHandle<T> {
    private static final Logger logger = LoggerFactory.getLogger(IntrospectionAsyncHandle.class);
    private final AsyncHandle<MethodResult> resultHandle;

    public IntrospectionAsyncHandle(AsyncHandle<MethodResult> resultHandle) {
        this.resultHandle = resultHandle;
    }

    protected abstract DataValue convert(T var1);

    @Override
    public void updateProgress(DataValue progress) {
        this.resultHandle.updateProgress(progress);
    }

    @Override
    public void setResult(T result) {
        DataValue converted;
        try {
            converted = this.convert(result);
        }
        catch (ErrorValueException ex) {
            this.resultHandle.setResult(MethodResult.newErrorResult(ex.getErrorValue()));
            return;
        }
        catch (RuntimeException ex) {
            logger.error("Could not serialize the result of an introspection operation", (Throwable)ex);
            this.resultHandle.setError(ex);
            return;
        }
        if (converted == null) {
            return;
        }
        this.resultHandle.setResult(MethodResult.newResult(converted));
    }

    @Override
    public void setError(RuntimeException error) {
        if (error instanceof ErrorValueException) {
            ErrorValueException ex = (ErrorValueException)error;
            this.resultHandle.setResult(MethodResult.newErrorResult(ex.getErrorValue()));
        } else {
            this.resultHandle.setError(error);
        }
    }
}

