/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.protocol;

import com.vmware.vapi.protocol.RequestProcessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;

public final class ClientConfiguration {
    private final List<RequestProcessor> proc;
    private final Executor executor;
    private final boolean hasUserDefinedProc;
    boolean steamingEnabled;

    private ClientConfiguration(List<RequestProcessor> requestProcessors, Executor executor, boolean steamingEnabled) {
        this.hasUserDefinedProc = requestProcessors != null;
        this.proc = Collections.unmodifiableList(this.createRequestProcessorsList(requestProcessors));
        this.executor = executor;
        this.steamingEnabled = steamingEnabled;
    }

    public List<RequestProcessor> getRequestProcessors() {
        return this.proc;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public boolean isSteamingEnabled() {
        return this.steamingEnabled;
    }

    private ArrayList<RequestProcessor> createRequestProcessorsList(List<RequestProcessor> additionalProcessors) {
        ArrayList<RequestProcessor> proc = new ArrayList<RequestProcessor>();
        if (additionalProcessors != null) {
            proc.addAll(additionalProcessors);
        }
        return proc;
    }

    private boolean hasUserDefinedProc() {
        return this.hasUserDefinedProc;
    }

    public static final class Builder {
        private List<RequestProcessor> requestProcessors;
        private Executor executor;
        private boolean streamingEnabled = true;

        public Builder() {
        }

        public Builder(ClientConfiguration config) {
            if (config != null) {
                this.executor = config.getExecutor();
                if (config.hasUserDefinedProc()) {
                    this.requestProcessors = new ArrayList<RequestProcessor>(config.getRequestProcessors());
                }
            }
        }

        public Builder setRequestProcessors(List<RequestProcessor> processors) {
            this.requestProcessors = processors;
            return this;
        }

        public List<RequestProcessor> getRequestProcessors() {
            return this.requestProcessors;
        }

        public Builder setExecutor(Executor executor) {
            this.executor = executor;
            return this;
        }

        public Builder setStreamingEnabled(boolean enabled) {
            this.streamingEnabled = enabled;
            return this;
        }

        public ClientConfiguration getConfig() {
            return new ClientConfiguration(this.requestProcessors, this.executor, this.streamingEnabled);
        }
    }
}

