/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.provider.aggregator;

import com.vmware.vapi.ErrorValueFactory;
import com.vmware.vapi.Message;
import com.vmware.vapi.MessageFactory;
import com.vmware.vapi.core.ApiProvider;
import com.vmware.vapi.core.ApiProviderStubImpl;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.core.InterfaceDefinition;
import com.vmware.vapi.core.InterfaceIdentifier;
import com.vmware.vapi.core.MethodDefinition;
import com.vmware.vapi.core.MethodIdentifier;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.core.ProviderDefinition;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.ErrorDefinition;
import com.vmware.vapi.data.ErrorValue;
import com.vmware.vapi.internal.provider.introspection.SyncToAsyncApiIntrospectionAdapter;
import com.vmware.vapi.internal.util.async.SetAccumulator;
import com.vmware.vapi.provider.introspection.ApiIntrospection;
import com.vmware.vapi.provider.introspection.SyncApiIntrospection;
import com.vmware.vapi.std.StandardDataFactory;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProviderAggregation
implements ApiIntrospection,
ApiProvider {
    private static final Logger logger = LoggerFactory.getLogger(ProviderAggregation.class);
    static final Set<ErrorDefinition> AGGREGATOR_ERROR_DEFS = Collections.unmodifiableSet(new HashSet<ErrorDefinition>(Arrays.asList(StandardDataFactory.createStandardErrorDefinition("com.vmware.vapi.std.errors.internal_server_error"), StandardDataFactory.createStandardErrorDefinition("com.vmware.vapi.std.errors.operation_not_found"))));
    private final String name;
    private final Map<String, ApiProvider> ifaceMap;
    private final Set<ApiProvider> providers;

    public ProviderAggregation(String name, Map<String, ApiProvider> ifaceMap) {
        this.name = name;
        this.ifaceMap = ifaceMap;
        this.providers = new HashSet<ApiProvider>(this.ifaceMap.values());
    }

    @Override
    public void getDefinition(ExecutionContext ctx, final AsyncHandle<ProviderDefinition> asyncHandle) {
        AsyncHandle<Set<ProviderDefinition>> reducer = new AsyncHandle<Set<ProviderDefinition>>(){

            @Override
            public void updateProgress(DataValue progress) {
                asyncHandle.updateProgress(progress);
            }

            @Override
            public void setResult(Set<ProviderDefinition> result) {
                String checkSum = ProviderAggregation.computeCheckSum(result);
                asyncHandle.setResult(new ProviderDefinition(ProviderAggregation.this.name, checkSum));
            }

            @Override
            public void setError(RuntimeException error) {
                asyncHandle.setError(error);
            }
        };
        SetAccumulator<ProviderDefinition> accumulator = new SetAccumulator<ProviderDefinition>(reducer, this.providers.size());
        for (ApiProvider p : this.providers) {
            this.introspect(p).getDefinition(ctx, accumulator.createSlaveForOneElement());
        }
    }

    private static String computeCheckSum(Set<ProviderDefinition> defs) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            for (ProviderDefinition def : defs) {
                md.update(def.getCheckSum().getBytes("UTF-8"));
            }
            return Hex.encodeHexString((byte[])md.digest());
        }
        catch (UnsupportedEncodingException ex) {
            logger.error("Unable to get UTF-8 bytes for data for checksum", (Throwable)ex);
            return "";
        }
        catch (NoSuchAlgorithmException ex) {
            logger.error("Unable to load algorithm to compute provider checksum", (Throwable)ex);
            return "";
        }
    }

    @Override
    public void getInterfaceIdentifiers(ExecutionContext ctx, AsyncHandle<Set<InterfaceIdentifier>> asyncHandle) {
        HashSet<InterfaceIdentifier> result = new HashSet<InterfaceIdentifier>();
        for (String serviceId : this.ifaceMap.keySet()) {
            result.add(new InterfaceIdentifier(serviceId));
        }
        asyncHandle.setResult(result);
    }

    @Override
    public void getInterface(ExecutionContext ctx, InterfaceIdentifier iface, AsyncHandle<InterfaceDefinition> asyncHandle) {
        if (iface == null) {
            asyncHandle.setResult(null);
            return;
        }
        ApiProvider p = this.ifaceMap.get(iface.getName());
        if (p != null) {
            this.introspect(p).getInterface(ctx, iface, asyncHandle);
        } else {
            asyncHandle.setResult(null);
        }
    }

    @Override
    public void getMethod(ExecutionContext ctx, MethodIdentifier method, AsyncHandle<MethodDefinition> asyncHandle) {
        if (method == null) {
            asyncHandle.setResult(null);
            return;
        }
        InterfaceIdentifier iface = method.getInterfaceIdentifier();
        ApiProvider prov = this.ifaceMap.get(iface.getName());
        if (prov != null) {
            this.introspect(prov).getMethod(ctx, method, asyncHandle);
        } else {
            asyncHandle.setResult(null);
        }
    }

    private ApiIntrospection introspect(ApiProvider p) {
        if (p instanceof ApiIntrospection) {
            return (ApiIntrospection)((Object)p);
        }
        if (p instanceof SyncApiIntrospection) {
            return new SyncToAsyncApiIntrospectionAdapter((SyncApiIntrospection)((Object)p));
        }
        return new ApiProviderStubImpl(p);
    }

    private void invokeMethodImpl(ExecutionContext ctx, final String serviceId, final String operationId, DataValue input, final AsyncHandle<MethodResult> asyncHandle) {
        ApiProvider prov = this.ifaceMap.get(serviceId);
        if (prov == null) {
            logger.warn("Could not find provider for service '{}'", (Object)serviceId);
            ErrorValue errValue = ErrorValueFactory.buildErrorValue("com.vmware.vapi.std.errors.operation_not_found", "vapi.method.input.invalid.interface", serviceId);
            asyncHandle.setResult(MethodResult.newErrorResult(errValue));
            return;
        }
        logger.debug("Invoking operation '{}.{}'", (Object)serviceId, (Object)operationId);
        AsyncHandle<MethodResult> cb = new AsyncHandle<MethodResult>(){

            @Override
            public void updateProgress(DataValue progress) {
                asyncHandle.updateProgress(progress);
            }

            @Override
            public void setResult(MethodResult result) {
                asyncHandle.setResult(result);
            }

            @Override
            public void setError(RuntimeException ex) {
                logger.error(String.format("Error while invoking operation '%s.%s'", serviceId, operationId), (Throwable)ex);
                asyncHandle.setResult(ProviderAggregation.invokeMethodError(serviceId, operationId));
            }
        };
        prov.invoke(serviceId, operationId, input, ctx, cb);
    }

    private static MethodResult invokeMethodError(String serviceId, String operationId) {
        String methodId = serviceId + "." + operationId;
        Message message = MessageFactory.getMessage("vapi.provider.aggregator.invokemethod.exception", methodId);
        return MethodResult.newErrorResult(StandardDataFactory.createErrorValueForMessages("com.vmware.vapi.std.errors.internal_server_error", Arrays.asList(message)));
    }

    @Override
    public void invoke(String serviceId, String operationId, DataValue input, ExecutionContext ctx, AsyncHandle<MethodResult> asyncHandle) {
        try {
            this.invokeMethodImpl(ctx, serviceId, operationId, input, asyncHandle);
        }
        catch (RuntimeException ex) {
            logger.error("Exception thrown in invokeMethod", (Throwable)ex);
            asyncHandle.setError(ex);
        }
    }
}

