/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.binding.dr;

import com.vmware.vim.binding.dr.UserSession;
import com.vmware.vim.binding.dr.version.version0;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.faults;
import com.vmware.vim.binding.vmodl.fullyQualifiedVmodlName;
import com.vmware.vim.binding.vmodl.managed;
import com.vmware.vim.binding.vmodl.managedObjectType;
import com.vmware.vim.binding.vmodl.map;
import com.vmware.vim.binding.vmodl.name;
import com.vmware.vim.binding.vmodl.optional;
import com.vmware.vim.binding.vmodl.privilege;
import com.vmware.vim.binding.vmodl.readonly;
import com.vmware.vim.binding.vmodl.versionClass;
import com.vmware.vim.binding.vmodl.wsdlName;
import com.vmware.vim.vmomi.core.Future;

@fullyQualifiedVmodlName(value="dr.SessionManager")
@managed
@versionClass(value=version0.class)
@wsdlName(value="DrSessionManager")
public interface SessionManager
extends ManagedObject {
    @readonly
    @name(value="sessionList")
    @privilege(value="Sessions.TerminateSession")
    @versionClass(value=version0.class)
    @optional
    @map
    public void getSessionList(@optional Future<UserSession[]> var1);

    @readonly
    @name(value="currentSession")
    @privilege(value="System.Anonymous")
    @versionClass(value=version0.class)
    @optional
    public void getCurrentSession(@optional Future<UserSession> var1);

    @readonly
    @name(value="supportedLocaleList")
    @privilege(value="System.Anonymous")
    @versionClass(value=version0.class)
    @optional
    @map
    public void getSupportedLocaleList(@optional Future<String[]> var1);

    @readonly
    @name(value="defaultLocale")
    @privilege(value="System.Anonymous")
    @versionClass(value=version0.class)
    public void getDefaultLocale(Future<String> var1);

    @versionClass(value=version0.class)
    @wsdlName(value="DrLoginByToken")
    @privilege(value="System.Anonymous")
    @faults(value={"InvalidLogin", "InvalidLocale", "DrFaultCancelled", "NoPermission", "DrFaultAlreadyLoggedInFault", "DrFaultCertificateVerificationError", "DrFaultSessionLimitExceeded"})
    public void loginByToken(@name(value="locale") @versionClass(value=version0.class) @optional String var1, Future<UserSession> var2);

    @versionClass(value=version0.class)
    @wsdlName(value="LoginRemoteSiteByToken")
    @privilege(value="System.Read")
    @faults(value={"InvalidLogin", "DrFaultCancelled", "NotAuthenticated", "DrFaultRemoteSiteNotFound", "DrFaultAlreadyLoggedInFault", "DrFaultSiteNotEnabled", "DrFaultCertificateVerificationError", "DrFaultSessionLimitExceeded", "DrFaultLoginDrInVcFailed", "DrFaultLoginDrInDrFailed"})
    public void loginRemoteSiteByToken(@name(value="site") @versionClass(value=version0.class) @managedObjectType(value="com.vmware.vim.binding.dr.site.RemoteSite") @privilege(value="System.Read") ManagedObjectReference var1, @name(value="locale") @versionClass(value=version0.class) @optional String var2, Future<Void> var3);

    @versionClass(value=version0.class)
    @wsdlName(value="LogoutRemoteSite")
    @privilege(value="System.Anonymous")
    @faults(value={"NotAuthenticated", "DrFaultSiteNotEnabled", "DrFaultRemoteSiteNotAuthenticated", "DrFaultRemoteSiteNotFound"})
    public void logoutRemoteSite(@name(value="site") @versionClass(value=version0.class) @managedObjectType(value="com.vmware.vim.binding.dr.site.RemoteSite") @privilege(value="System.View") ManagedObjectReference var1, Future<Void> var2);

    @versionClass(value=version0.class)
    @wsdlName(value="DrLogout")
    @privilege(value="System.View")
    @faults(value={"NotAuthenticated"})
    public void logout(Future<Void> var1);

    @versionClass(value=version0.class)
    @wsdlName(value="Terminate")
    @privilege(value="Sessions.TerminateSession")
    @faults(value={"NotFound"})
    public void terminate(@name(value="sessionId") @versionClass(value=version0.class) @optional @map String[] var1, Future<Void> var2);

    @versionClass(value=version0.class)
    @wsdlName(value="SetDrLocale")
    @privilege(value="System.View")
    @faults(value={"InvalidLocale"})
    public void setLocale(@name(value="locale") @versionClass(value=version0.class) String var1, Future<Void> var2);
}

