/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.binding.dr.recovery;

import com.vmware.vim.binding.dr.recovery.RecoveryOptions;
import com.vmware.vim.binding.dr.recovery.RecoveryPlan;
import com.vmware.vim.binding.dr.recovery.RecoveryPlanSpec;
import com.vmware.vim.binding.dr.recovery.RecoveryViewport;
import com.vmware.vim.binding.dr.recovery.VmRecoverySettings;
import com.vmware.vim.binding.dr.version.version0;
import com.vmware.vim.binding.impl.vmodl.DynamicDataImpl;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.data;
import com.vmware.vim.binding.vmodl.faults;
import com.vmware.vim.binding.vmodl.fullyQualifiedVmodlName;
import com.vmware.vim.binding.vmodl.list;
import com.vmware.vim.binding.vmodl.managed;
import com.vmware.vim.binding.vmodl.managedObjectType;
import com.vmware.vim.binding.vmodl.map;
import com.vmware.vim.binding.vmodl.name;
import com.vmware.vim.binding.vmodl.optional;
import com.vmware.vim.binding.vmodl.privilege;
import com.vmware.vim.binding.vmodl.propertyOrder;
import com.vmware.vim.binding.vmodl.readonly;
import com.vmware.vim.binding.vmodl.task;
import com.vmware.vim.binding.vmodl.versionClass;
import com.vmware.vim.binding.vmodl.wsdlName;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.util.StringUtil;

@fullyQualifiedVmodlName(value="dr.recovery.RecoveryManager")
@managed
@versionClass(value=version0.class)
@wsdlName(value="DrRecoveryRecoveryManager")
public interface RecoveryManager
extends ManagedObject {
    @readonly
    @name(value="planFolder")
    @privilege(value="System.View")
    @versionClass(value=version0.class)
    @managedObjectType(value="com.vmware.vim.binding.dr.Folder")
    public void getPlanFolder(@managedObjectType(value="com.vmware.vim.binding.dr.Folder") Future<ManagedObjectReference> var1);

    @readonly
    @name(value="plans")
    @privilege(value="System.Read")
    @versionClass(value=version0.class)
    @optional
    @managedObjectType(value="com.vmware.vim.binding.dr.recovery.RecoveryPlan")
    @map
    public void getPlans(@optional @managedObjectType(value="com.vmware.vim.binding.dr.recovery.RecoveryPlan") Future<ManagedObjectReference[]> var1);

    @readonly
    @name(value="vmSettingMappings")
    @privilege(value="System.Read")
    @versionClass(value=version0.class)
    @optional
    @map
    @Deprecated
    public void getVmSettingMappings(@optional Future<VmSettingMapping[]> var1);

    @readonly
    @name(value="ipSubnetMapper")
    @privilege(value="System.View")
    @versionClass(value=version0.class)
    @managedObjectType(value="com.vmware.vim.binding.dr.IpSubnetMapper")
    public void getIpSubnetMapper(@managedObjectType(value="com.vmware.vim.binding.dr.IpSubnetMapper") Future<ManagedObjectReference> var1);

    @versionClass(value=version0.class)
    @wsdlName(value="CreateRecoveryPlan_Task")
    @privilege(value="System.Read")
    @task
    public void createRecoveryPlan(@name(value="location") @versionClass(value=version0.class) @managedObjectType(value="com.vmware.vim.binding.dr.Folder") @privilege(value="VcDr.RecoveryProfile.com.vmware.vcDr.Create") ManagedObjectReference var1, @name(value="spec") @versionClass(value=version0.class) RecoveryPlanSpec var2, @name(value="site") @versionClass(value=version0.class) @managedObjectType(value="com.vmware.vim.binding.dr.site.RemoteSite") ManagedObjectReference var3, @managedObjectType(value="com.vmware.vim.binding.vim.Task") Future<ManagedObjectReference> var4);

    @versionClass(value=version0.class)
    @wsdlName(value="CloneRecoveryPlan_Task")
    @privilege(value="dynamic")
    @task
    @faults(value={"DrFaultDuplicateName", "DrFaultStringArgumentTooLong"})
    public void cloneRecoveryPlan(@name(value="plan") @versionClass(value=version0.class) @managedObjectType(value="com.vmware.vim.binding.dr.recovery.RecoveryPlan") @privilege(value="System.Read") ManagedObjectReference var1, @name(value="newName") @versionClass(value=version0.class) String var2, @managedObjectType(value="com.vmware.vim.binding.vim.Task") Future<ManagedObjectReference> var3);

    @versionClass(value=version0.class)
    @wsdlName(value="DestroyRecoveryPlan_Task")
    @privilege(value="System.Read")
    @task
    @faults(value={"DrRecoveryFaultRecoveryPlanLocked"})
    public void destroyRecoveryPlan(@name(value="plan") @versionClass(value=version0.class) @managedObjectType(value="com.vmware.vim.binding.dr.recovery.RecoveryPlan") @privilege(value="VcDr.RecoveryProfile.com.vmware.vcDr.Delete") ManagedObjectReference var1, @managedObjectType(value="com.vmware.vim.binding.vim.Task") Future<ManagedObjectReference> var2);

    @versionClass(value=version0.class)
    @wsdlName(value="CreateRecoveryViewport_Task")
    @privilege(value="System.Read")
    @task
    public void createRecoveryViewport(@name(value="plan") @versionClass(value=version0.class) @managedObjectType(value="com.vmware.vim.binding.dr.recovery.RecoveryPlan") @privilege(value="System.Read") ManagedObjectReference var1, @name(value="mode") @versionClass(value=version0.class) RecoveryViewport.Mode var2, @managedObjectType(value="com.vmware.vim.binding.vim.Task") Future<ManagedObjectReference> var3);

    @versionClass(value=version0.class)
    @wsdlName(value="FailoverPlan")
    @privilege(value="System.Read")
    @faults(value={"DrRecoveryFaultRecoveryPlanLocked", "DrRecoveryFaultInvalidRecoveryState", "DrFaultInsufficientLicensesFault", "NoPermission", "DrFaultConnectionDownFault"})
    public void failover(@name(value="plan") @versionClass(value=version0.class) @managedObjectType(value="com.vmware.vim.binding.dr.recovery.RecoveryPlan") @privilege(value="VcDr.RecoveryProfile.com.vmware.vcDr.Failover") ManagedObjectReference var1, @name(value="options") @versionClass(value=version0.class) RecoveryOptions var2, @managedObjectType(value="com.vmware.vim.binding.dr.recovery.RecoveryTask") Future<ManagedObjectReference> var3);

    @versionClass(value=version0.class)
    @wsdlName(value="TestPlan")
    @privilege(value="System.Read")
    @faults(value={"DrRecoveryFaultRecoveryPlanLocked", "DrRecoveryFaultInvalidRecoveryState", "NoPermission"})
    public void test(@name(value="plan") @versionClass(value=version0.class) @managedObjectType(value="com.vmware.vim.binding.dr.recovery.RecoveryPlan") @privilege(value="VcDr.RecoveryProfile.com.vmware.vcDr.Run") ManagedObjectReference var1, @name(value="options") @versionClass(value=version0.class) RecoveryOptions var2, @managedObjectType(value="com.vmware.vim.binding.dr.recovery.RecoveryTask") Future<ManagedObjectReference> var3);

    @versionClass(value=version0.class)
    @wsdlName(value="CleanupPlan")
    @privilege(value="System.Read")
    @faults(value={"DrRecoveryFaultRecoveryPlanLocked", "DrRecoveryFaultInvalidRecoveryState", "NoPermission"})
    public void cleanupTest(@name(value="plan") @versionClass(value=version0.class) @managedObjectType(value="com.vmware.vim.binding.dr.recovery.RecoveryPlan") @privilege(value="VcDr.RecoveryProfile.com.vmware.vcDr.Run") ManagedObjectReference var1, @name(value="ignoreErrors") @versionClass(value=version0.class) boolean var2, @managedObjectType(value="com.vmware.vim.binding.dr.recovery.RecoveryTask") Future<ManagedObjectReference> var3);

    @versionClass(value=version0.class)
    @wsdlName(value="ReprotectPlan")
    @privilege(value="System.Read")
    @faults(value={"DrRecoveryFaultRecoveryPlanLocked", "DrRecoveryFaultRemoteSiteDisconnected", "DrRecoveryFaultInvalidRecoveryState", "DrFaultInsufficientLicensesFault", "NoPermission"})
    public void reprotect(@name(value="plan") @versionClass(value=version0.class) @managedObjectType(value="com.vmware.vim.binding.dr.recovery.RecoveryPlan") @privilege(value="VcDr.RecoveryProfile.com.vmware.vcDr.Reprotect") ManagedObjectReference var1, @name(value="ignoreErrors") @versionClass(value=version0.class) boolean var2, @managedObjectType(value="com.vmware.vim.binding.dr.recovery.RecoveryTask") Future<ManagedObjectReference> var3);

    @versionClass(value=version0.class)
    @wsdlName(value="RetrieveVmSettingMappingsByIdentity")
    @privilege(value="System.Read")
    @map
    @Deprecated
    public void retrieveVmSettingMappingsByIdentity(@name(value="vmIdentities") @versionClass(value=version0.class) @optional @map String[] var1, @optional @map Future<VmSettingMapping[]> var2);

    @versionClass(value=version0.class)
    @wsdlName(value="RetrieveAllPlanVmSettingMappings")
    @privilege(value="System.Read")
    @map
    @Deprecated
    public void retrieveAllPlanVmSettingMappings(@name(value="recoveryPlan") @versionClass(value=version0.class) @managedObjectType(value="com.vmware.vim.binding.dr.recovery.RecoveryPlan") @privilege(value="System.View") ManagedObjectReference var1, @optional @map Future<PlanVmSettingMapping[]> var2);

    @versionClass(value=version0.class)
    @wsdlName(value="RetrievePlanVmSettingMappingsByIdentity")
    @privilege(value="System.Read")
    @map
    @Deprecated
    public void retrievePlanVmSettingMappingsByIdentity(@name(value="recoveryPlan") @versionClass(value=version0.class) @managedObjectType(value="com.vmware.vim.binding.dr.recovery.RecoveryPlan") @privilege(value="System.View") ManagedObjectReference var1, @name(value="vmIdentities") @versionClass(value=version0.class) @optional @map String[] var2, @optional @map Future<PlanVmSettingMapping[]> var3);

    @versionClass(value=version0.class)
    @wsdlName(value="UpdatePlanVmSettingMappings_Task")
    @privilege(value="VcDr.RecoveryProfile.com.vmware.vcDr.Edit")
    @task
    @faults(value={"DrFaultVersionConflict", "DrRecoveryFaultRecoveryPlanLocked", "DrRecoveryFaultDependencyConflict"})
    @Deprecated
    public void updatePlanVmSettingMappings(@name(value="recoveryPlan") @versionClass(value=version0.class) @managedObjectType(value="com.vmware.vim.binding.dr.recovery.RecoveryPlan") ManagedObjectReference var1, @name(value="settings") @versionClass(value=version0.class) @optional @map PlanVmSettingMapping[] var2, @managedObjectType(value="com.vmware.vim.binding.vim.Task") Future<ManagedObjectReference> var3);

    @versionClass(value=version0.class)
    @wsdlName(value="MovePlan_Task")
    @task
    @faults(value={"DrFaultDuplicateName", "DrFaultConnectionDownFault"})
    public void movePlan(@name(value="recoveryPlan") @versionClass(value=version0.class) @managedObjectType(value="com.vmware.vim.binding.dr.recovery.RecoveryPlan") @privilege(value="VcDr.RecoveryProfile.com.vmware.vcDr.Edit") ManagedObjectReference var1, @name(value="destination") @versionClass(value=version0.class) @managedObjectType(value="com.vmware.vim.binding.dr.Folder") @privilege(value="VcDr.RecoveryProfile.com.vmware.vcDr.Edit") ManagedObjectReference var2, @managedObjectType(value="com.vmware.vim.binding.vim.Task") Future<ManagedObjectReference> var3);

    @versionClass(value=version0.class)
    @wsdlName(value="ReconfigurePlan_Task")
    @task
    public void reconfigurePlan(@name(value="recoveryPlan") @versionClass(value=version0.class) @managedObjectType(value="com.vmware.vim.binding.dr.recovery.RecoveryPlan") @privilege(value="VcDr.RecoveryProfile.com.vmware.vcDr.Edit") ManagedObjectReference var1, @name(value="spec") @versionClass(value=version0.class) RecoveryPlanSpec var2, @managedObjectType(value="com.vmware.vim.binding.vim.Task") Future<ManagedObjectReference> var3);

    @versionClass(value=version0.class)
    @wsdlName(value="ForcePlanSynchronization_Task")
    @task
    public void forcePlanSynchronization(@name(value="recoveryPlan") @versionClass(value=version0.class) @managedObjectType(value="com.vmware.vim.binding.dr.recovery.RecoveryPlan") @privilege(value="VcDr.RecoveryProfile.com.vmware.vcDr.Edit") ManagedObjectReference var1, @managedObjectType(value="com.vmware.vim.binding.vim.Task") Future<ManagedObjectReference> var2);

    @versionClass(value=version0.class)
    @wsdlName(value="RetrieveRecoveryPlan")
    @privilege(value="System.Read")
    public void retrieveRecoveryPlan(@name(value="uuid") @versionClass(value=version0.class) String var1, @managedObjectType(value="com.vmware.vim.binding.dr.recovery.RecoveryPlan") Future<ManagedObjectReference> var2);

    @versionClass(value=version0.class)
    @wsdlName(value="RetrievePlanOperationStatus")
    @privilege(value="System.Read")
    public void retrievePlanOperationStatus(@name(value="recoveryPlan") @versionClass(value=version0.class) @managedObjectType(value="com.vmware.vim.binding.dr.recovery.RecoveryPlan") @privilege(value="System.View") ManagedObjectReference var1, Future<RecoveryPlanOperationStatus> var2);

    @versionClass(value=version0.class)
    @wsdlName(value="PowerOffRemoteVm_Task")
    @privilege(value="VcDr.Internal.com.vmware.vcDr.InternalAccess")
    @task
    public void powerOffVm(@name(value="vm") @versionClass(value=version0.class) @managedObjectType(value="com.vmware.vim.binding.vim.VirtualMachine") ManagedObjectReference var1, @name(value="skipGuestShutdown") @versionClass(value=version0.class) boolean var2, @name(value="guestShutdownTimeout") @versionClass(value=version0.class) int var3, @name(value="stopOnError") @versionClass(value=version0.class) boolean var4, @managedObjectType(value="com.vmware.vim.binding.vim.Task") Future<ManagedObjectReference> var5);

    @versionClass(value=version0.class)
    @wsdlName(value="PowerOnRemoteVm_Task")
    @privilege(value="VcDr.Internal.com.vmware.vcDr.InternalAccess")
    @task
    public void powerOnVm(@name(value="vm") @versionClass(value=version0.class) @managedObjectType(value="com.vmware.vim.binding.vim.VirtualMachine") ManagedObjectReference var1, @managedObjectType(value="com.vmware.vim.binding.vim.Task") Future<ManagedObjectReference> var2);

    @versionClass(value=version0.class)
    @wsdlName(value="discoverClustersForPlan_Task")
    @privilege(value="System.Read")
    @task
    public void discoverClustersForPlan(@name(value="recoveryPlan") @versionClass(value=version0.class) @managedObjectType(value="com.vmware.vim.binding.dr.recovery.RecoveryPlan") @privilege(value="System.View") ManagedObjectReference var1, @managedObjectType(value="com.vmware.vim.binding.vim.Task") Future<ManagedObjectReference> var2);

    @versionClass(value=version0.class)
    @wsdlName(value="DiscoverClustersForResourcePools_Task")
    @privilege(value="System.Read")
    @task
    @map
    public void discoverClustersForResourcePools(@name(value="resourcePools") @versionClass(value=version0.class) @optional @managedObjectType(value="com.vmware.vim.binding.vim.ResourcePool") @map ManagedObjectReference[] var1, @managedObjectType(value="com.vmware.vim.binding.vim.Task") Future<ManagedObjectReference> var2);

    @versionClass(value=version0.class)
    @wsdlName(value="acquireDpmLockForCluster_Task")
    @privilege(value="VcDr.Internal.com.vmware.vcDr.InternalAccess")
    @task
    public void acquireDpmLockForCluster(@name(value="cluster") @versionClass(value=version0.class) @managedObjectType(value="com.vmware.vim.binding.vim.ClusterComputeResource") @privilege(value="System.Read") ManagedObjectReference var1, @managedObjectType(value="com.vmware.vim.binding.vim.Task") Future<ManagedObjectReference> var2);

    @versionClass(value=version0.class)
    @wsdlName(value="disableDpmForCluster_Task")
    @privilege(value="VcDr.Internal.com.vmware.vcDr.InternalAccess")
    @task
    @faults(value={"DrRecoveryFaultDpmLockNotAcquiredFault"})
    public void disableDpmForCluster(@name(value="clusterToken") @versionClass(value=version0.class) DpmClusterAcquisitionToken var1, @managedObjectType(value="com.vmware.vim.binding.vim.Task") Future<ManagedObjectReference> var2);

    @versionClass(value=version0.class)
    @wsdlName(value="releaseDpmLockForCluster_Task")
    @privilege(value="VcDr.Internal.com.vmware.vcDr.InternalAccess")
    @task
    @faults(value={"DrRecoveryFaultDpmLockNotAcquiredFault"})
    public void releaseDpmLockForCluster(@name(value="clusterToken") @versionClass(value=version0.class) DpmClusterAcquisitionToken var1, @managedObjectType(value="com.vmware.vim.binding.vim.Task") Future<ManagedObjectReference> var2);

    @versionClass(value=version0.class)
    @wsdlName(value="DrRecoveryRecoveryManagerDpmClusterAcquisitionToken")
    @data
    @propertyOrder(value={"cluster", "clusterToken"})
    public static class DpmClusterAcquisitionToken
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public ManagedObjectReference cluster;
        public int clusterToken;

        public DpmClusterAcquisitionToken() {
        }

        public DpmClusterAcquisitionToken(ManagedObjectReference cluster, int clusterToken) {
            this.cluster = cluster;
            this.clusterToken = clusterToken;
        }

        @managedObjectType(value="com.vmware.vim.binding.vim.ClusterComputeResource")
        @versionClass(value=version0.class)
        public ManagedObjectReference getCluster() {
            return this.cluster;
        }

        @managedObjectType(value="com.vmware.vim.binding.vim.ClusterComputeResource")
        @versionClass(value=version0.class)
        public void setCluster(ManagedObjectReference cluster) {
            this.cluster = cluster;
        }

        @versionClass(value=version0.class)
        public int getClusterToken() {
            return this.clusterToken;
        }

        @versionClass(value=version0.class)
        public void setClusterToken(int clusterToken) {
            this.clusterToken = clusterToken;
        }

        public String toString() {
            StringBuilder objString = new StringBuilder(160);
            objString.append("(dr.recovery.DpmClusterAcquisitionToken) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("cluster = ");
            if (this.getCluster() == null) {
                objString.append("null");
            } else {
                objString.append(StringUtil.indent((String)("" + this.getCluster()), (boolean)false));
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("clusterToken = ");
            objString.append(this.getClusterToken());
            objString.append("\n}");
            return objString.toString();
        }
    }

    @versionClass(value=version0.class)
    @wsdlName(value="DrRecoveryRecoveryManagerDiscoverPlanClusterResult")
    @data
    @propertyOrder(value={"recoveryPlan", "clusters"})
    public static class DiscoverPlanClusterResult
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public ManagedObjectReference recoveryPlan;
        public ManagedObjectReference[] clusters;

        public DiscoverPlanClusterResult() {
        }

        public DiscoverPlanClusterResult(ManagedObjectReference recoveryPlan, ManagedObjectReference[] clusters) {
            this.recoveryPlan = recoveryPlan;
            this.clusters = clusters;
        }

        @managedObjectType(value="com.vmware.vim.binding.dr.recovery.RecoveryPlan")
        @versionClass(value=version0.class)
        public ManagedObjectReference getRecoveryPlan() {
            return this.recoveryPlan;
        }

        @managedObjectType(value="com.vmware.vim.binding.dr.recovery.RecoveryPlan")
        @versionClass(value=version0.class)
        public void setRecoveryPlan(ManagedObjectReference recoveryPlan) {
            this.recoveryPlan = recoveryPlan;
        }

        @managedObjectType(value="com.vmware.vim.binding.vim.ClusterComputeResource")
        @map
        @optional
        @versionClass(value=version0.class)
        public ManagedObjectReference[] getClusters() {
            return this.clusters;
        }

        @managedObjectType(value="com.vmware.vim.binding.vim.ClusterComputeResource")
        @map
        @optional
        @versionClass(value=version0.class)
        public void setClusters(ManagedObjectReference[] clusters) {
            this.clusters = clusters;
        }

        public String toString() {
            int i;
            StringBuilder objString = new StringBuilder(160);
            objString.append("(dr.recovery.DiscoverPlanClusterResult) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("recoveryPlan = ");
            if (this.getRecoveryPlan() == null) {
                objString.append("null");
            } else {
                objString.append(StringUtil.indent((String)("" + this.getRecoveryPlan()), (boolean)false));
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("clusters = ");
            if (this.getClusters() == null) {
                objString.append("null");
            } else {
                objString.append("(vim.ClusterComputeResource) [\n");
                for (i = 0; i < this.getClusters().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getClusters()[i]), (boolean)true));
                    if (i < this.getClusters().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append("\n}");
            return objString.toString();
        }
    }

    @versionClass(value=version0.class)
    @wsdlName(value="DrRecoveryRecoveryManagerRecoveryPlanOperationStatus")
    @data
    @propertyOrder(value={"validWorkflows", "validOperations", "runningWorkflow", "workflowCancellable", "workflowCancelled"})
    public static class RecoveryPlanOperationStatus
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public RecoveryWorkflow[] validWorkflows;
        public RecoveryPlanConfigureOperation[] validOperations;
        public boolean runningWorkflow;
        public boolean workflowCancellable;
        public boolean workflowCancelled;

        public RecoveryPlanOperationStatus() {
        }

        public RecoveryPlanOperationStatus(RecoveryWorkflow[] validWorkflows, RecoveryPlanConfigureOperation[] validOperations, boolean runningWorkflow, boolean workflowCancellable, boolean workflowCancelled) {
            this.validWorkflows = validWorkflows;
            this.validOperations = validOperations;
            this.runningWorkflow = runningWorkflow;
            this.workflowCancellable = workflowCancellable;
            this.workflowCancelled = workflowCancelled;
        }

        @list
        @optional
        @versionClass(value=version0.class)
        public RecoveryWorkflow[] getValidWorkflows() {
            return this.validWorkflows;
        }

        @list
        @optional
        @versionClass(value=version0.class)
        public void setValidWorkflows(RecoveryWorkflow[] validWorkflows) {
            this.validWorkflows = validWorkflows;
        }

        @list
        @optional
        @versionClass(value=version0.class)
        public RecoveryPlanConfigureOperation[] getValidOperations() {
            return this.validOperations;
        }

        @list
        @optional
        @versionClass(value=version0.class)
        public void setValidOperations(RecoveryPlanConfigureOperation[] validOperations) {
            this.validOperations = validOperations;
        }

        @versionClass(value=version0.class)
        public boolean isRunningWorkflow() {
            return this.runningWorkflow;
        }

        @versionClass(value=version0.class)
        public void setRunningWorkflow(boolean runningWorkflow) {
            this.runningWorkflow = runningWorkflow;
        }

        @versionClass(value=version0.class)
        public boolean isWorkflowCancellable() {
            return this.workflowCancellable;
        }

        @versionClass(value=version0.class)
        public void setWorkflowCancellable(boolean workflowCancellable) {
            this.workflowCancellable = workflowCancellable;
        }

        @versionClass(value=version0.class)
        public boolean isWorkflowCancelled() {
            return this.workflowCancelled;
        }

        @versionClass(value=version0.class)
        public void setWorkflowCancelled(boolean workflowCancelled) {
            this.workflowCancelled = workflowCancelled;
        }

        public String toString() {
            int i;
            StringBuilder objString = new StringBuilder(280);
            objString.append("(dr.recovery.RecoveryPlanOperationStatus) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("validWorkflows = ");
            if (this.getValidWorkflows() == null) {
                objString.append("null");
            } else {
                objString.append("(dr.recovery.RecoveryWorkflow) [\n");
                for (i = 0; i < this.getValidWorkflows().length; ++i) {
                    objString.append("      ");
                    objString.append((Object)this.getValidWorkflows()[i]);
                    if (i < this.getValidWorkflows().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("validOperations = ");
            if (this.getValidOperations() == null) {
                objString.append("null");
            } else {
                objString.append("(dr.recovery.RecoveryPlanConfigureOperation) [\n");
                for (i = 0; i < this.getValidOperations().length; ++i) {
                    objString.append("      ");
                    objString.append((Object)this.getValidOperations()[i]);
                    if (i < this.getValidOperations().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("runningWorkflow = ");
            objString.append(this.isRunningWorkflow());
            objString.append(",\n");
            objString.append("   ");
            objString.append("workflowCancellable = ");
            objString.append(this.isWorkflowCancellable());
            objString.append(",\n");
            objString.append("   ");
            objString.append("workflowCancelled = ");
            objString.append(this.isWorkflowCancelled());
            objString.append("\n}");
            return objString.toString();
        }
    }

    @versionClass(value=version0.class)
    @wsdlName(value="DrRecoveryRecoveryManagerRecoveryPlanConfigureOperation")
    public static enum RecoveryPlanConfigureOperation {
        reconfigure,
        destroy;

    }

    @versionClass(value=version0.class)
    @wsdlName(value="DrRecoveryRecoveryManagerRecoveryWorkflow")
    public static enum RecoveryWorkflow {
        testFailover,
        cleanup,
        failover,
        reprotect;

    }

    @versionClass(value=version0.class)
    @wsdlName(value="DrRecoveryRecoveryManagerPlanVmSettingMapping")
    @Deprecated
    @data
    @propertyOrder(value={"key", "settings", "status"})
    public static class PlanVmSettingMapping
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public String key;
        public VmRecoverySettings settings;
        public RecoveryPlan.RecoveryStatus status;

        public PlanVmSettingMapping() {
        }

        public PlanVmSettingMapping(String key, VmRecoverySettings settings, RecoveryPlan.RecoveryStatus status) {
            this.key = key;
            this.settings = settings;
            this.status = status;
        }

        @versionClass(value=version0.class)
        @Deprecated
        public String getKey() {
            return this.key;
        }

        @versionClass(value=version0.class)
        @Deprecated
        public void setKey(String key) {
            this.key = key;
        }

        @versionClass(value=version0.class)
        @Deprecated
        public VmRecoverySettings getSettings() {
            return this.settings;
        }

        @versionClass(value=version0.class)
        @Deprecated
        public void setSettings(VmRecoverySettings settings) {
            this.settings = settings;
        }

        @versionClass(value=version0.class)
        @Deprecated
        public RecoveryPlan.RecoveryStatus getStatus() {
            return this.status;
        }

        @versionClass(value=version0.class)
        @Deprecated
        public void setStatus(RecoveryPlan.RecoveryStatus status) {
            this.status = status;
        }

        public String toString() {
            StringBuilder objString = new StringBuilder(200);
            objString.append("(dr.recovery.PlanVmSettingMapping) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("key = ");
            objString.append(this.getKey());
            objString.append(",\n");
            objString.append("   ");
            objString.append("settings = ");
            if (this.getSettings() == null) {
                objString.append("null");
            } else {
                objString.append(StringUtil.indent((String)("" + (Object)((Object)this.getSettings())), (boolean)false));
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("status = ");
            objString.append((Object)this.getStatus());
            objString.append("\n}");
            return objString.toString();
        }
    }

    @versionClass(value=version0.class)
    @wsdlName(value="DrRecoveryRecoveryManagerVmSettingMapping")
    @Deprecated
    @data
    @propertyOrder(value={"key", "settings"})
    public static class VmSettingMapping
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public String key;
        public VmRecoverySettings settings;

        public VmSettingMapping() {
        }

        public VmSettingMapping(String key, VmRecoverySettings settings) {
            this.key = key;
            this.settings = settings;
        }

        @versionClass(value=version0.class)
        @Deprecated
        public String getKey() {
            return this.key;
        }

        @versionClass(value=version0.class)
        @Deprecated
        public void setKey(String key) {
            this.key = key;
        }

        @versionClass(value=version0.class)
        @Deprecated
        public VmRecoverySettings getSettings() {
            return this.settings;
        }

        @versionClass(value=version0.class)
        @Deprecated
        public void setSettings(VmRecoverySettings settings) {
            this.settings = settings;
        }

        public String toString() {
            StringBuilder objString = new StringBuilder(160);
            objString.append("(dr.recovery.VmSettingMapping) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("key = ");
            objString.append(this.getKey());
            objString.append(",\n");
            objString.append("   ");
            objString.append("settings = ");
            if (this.getSettings() == null) {
                objString.append("null");
            } else {
                objString.append(StringUtil.indent((String)("" + (Object)((Object)this.getSettings())), (boolean)false));
            }
            objString.append("\n}");
            return objString.toString();
        }
    }
}

