/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.client.view.availability;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.Stream;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.srm.client.topology.client.Topology;
import com.vmware.srm.client.topology.client.view.Server;
import com.vmware.srm.client.topology.client.view.availability.PairSetup;
import com.vmware.srm.client.topology.client.view.vc.VcServer;
import com.vmware.srm.client.topology.client.vmomi.Service;
import com.vmware.srm.client.topology.impl.utils.L10N;
import java.net.URI;
import org.apache.commons.lang.Validate;

public interface ExtensionServer<T extends Service<?, ?>>
extends Server<T> {
    public VcServer vc();

    public Stream<? extends PairSetup<? extends ExtensionServer<T>>> getPairs();

    default public Promise<? extends PairSetup<? extends ExtensionServer<T>>> getPairBy(String pairVcGuid) {
        Validate.notEmpty((String)pairVcGuid, (String)"pairVcGuid");
        return this.getPairs().filter(pairSetup -> pairVcGuid.equals(pairSetup.pairVcGuid())).next().materialize().thenCompose(promiseResult -> {
            if (promiseResult.isSuccessful()) {
                return Promises.resolve((Object)promiseResult.getResult());
            }
            Exception cause = promiseResult.getError();
            if (cause instanceof Stream.StreamCompleteException) {
                return Promises.reject((Exception)new GetPairFailedException(pairVcGuid));
            }
            return Promises.reject((Exception)cause);
        });
    }

    public static class GetPairFailedException
    extends Topology.TopologyException {
        private static final String MSG_KEY = "extServer.retrievePairsFailed";

        public GetPairFailedException(URI extUrl, Exception cause) {
            super(L10N.localize(MSG_KEY, extUrl) + cause.getLocalizedMessage(), cause);
        }

        public GetPairFailedException(String msg) {
            super(msg);
        }

        public GetPairFailedException(Exception cause) {
            super(cause);
        }
    }
}

