/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.core.mxn.nodes;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.Publisher;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.dr.ui.tools.reactive.impl.Streams;
import com.vmware.dr.ui.tools.utilities.Exceptions;
import com.vmware.dr.ui.tools.utilities.HashUtils;
import com.vmware.dr.ui.tools.utilities.RotationManager;
import com.vmware.dr.ui.tools.utilities.StringUtils;
import com.vmware.srm.client.topology.impl.core.engine.Node;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.BaseNode;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.NodeContext;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.utils.LsppHelper;
import com.vmware.srm.client.topology.impl.core.operations.faults.ProviderNotAuthenticatedException;
import com.vmware.srm.client.topology.impl.init.Config;
import com.vmware.srm.client.topology.impl.lspp.LsppNegotiator;
import com.vmware.srm.client.topology.impl.lspp.Types;
import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppService;
import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppServiceEndpoint;
import com.vmware.srm.client.topology.impl.sso.CertificateUtils;
import com.vmware.srm.client.topology.impl.sso.SsoUtils;
import com.vmware.srm.client.topology.impl.view.ServersViewImpl;
import com.vmware.srm.client.topology.impl.vmomi.TokenProvider;
import com.vmware.vim.sso.client.exception.ServerCommunicationException;
import com.vmware.vim.vmomi.client.common.UnexpectedStatusCodeException;
import com.vmware.vim.vmomi.client.exception.ConnectionException;
import com.vmware.vim.vmomi.client.exception.SslException;
import com.vmware.vim.vmomi.client.exception.TransportProtocolException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseLsppNode
extends BaseNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseLsppNode.class);
    private final AtomicReference<RotationManager<LsppService>> _rmRef;
    private final Set<String> _ssoUuids = new HashSet<String>();
    private final int _hashCode;

    BaseLsppNode(Set<LsppService> lsppSsos) {
        if (lsppSsos == null || lsppSsos.isEmpty()) {
            throw new IllegalArgumentException("lsppSsoSet");
        }
        this._rmRef = new AtomicReference<RotationManager>(new RotationManager(lsppSsos));
        for (LsppService sso : lsppSsos) {
            this._ssoUuids.add(sso.getId());
        }
        this._hashCode = HashUtils.getHashCode((Object[])new Object[]{this._ssoUuids});
    }

    @Override
    public void update(Node<NodeContext> suggested, NodeContext context) {
        RotationManager<LsppService> rm;
        BaseLsppNode suggestedLspp = (BaseLsppNode)suggested;
        RotationManager<LsppService> suggestedRm = suggestedLspp._rmRef.get();
        while (!(rm = this._rmRef.get()).equals(suggestedRm)) {
            if (!this._rmRef.compareAndSet(rm, suggestedRm)) continue;
            LOGGER.info("Changed rotationManager from '{}' to '{}'", rm, suggestedRm);
            break;
        }
        suggestedLspp._rmRef.lazySet(null);
    }

    @Override
    public Promise<Set<? extends Node<NodeContext>>> discoverNeighbours(NodeContext context) {
        TokenProvider tokenProvider = this.getTokenProvider();
        if (!tokenProvider.isTokenAvailable()) {
            return Promises.reject((Exception)((Object)new ProviderNotAuthenticatedException(tokenProvider)));
        }
        RotationManager<LsppService> rm = this.getManager();
        RotationManager.Rotation rotation = rm.create();
        return BaseLsppNode.execute((RotationManager.Rotation<LsppService>)rotation).thenApply(map -> {
            List<LsppHelper.DrSite> sites = LsppHelper.createDrSites(map);
            LOGGER.debug("Lspp node '{}' - DrSites '{}'", (Object)this, sites);
            return this.getNeighbours(sites, context.getView(), this.getTokenProvider());
        });
    }

    protected abstract Set<Node<NodeContext>> getNeighbours(List<LsppHelper.DrSite> var1, ServersViewImpl var2, TokenProvider var3);

    abstract TokenProvider getTokenProvider();

    public final RotationManager<LsppService> getManager() {
        return this._rmRef.get();
    }

    @Override
    public String toString() {
        HashMap<String, RotationManager<LsppService>> members = new HashMap<String, RotationManager<LsppService>>();
        members.put("_rotationManager", this.getManager());
        String instanceName = this.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(this));
        return StringUtils.getToStringValue((String)instanceName, members);
    }

    @Override
    public int hashCode() {
        return this._hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BaseLsppNode)) {
            return false;
        }
        BaseLsppNode other = (BaseLsppNode)obj;
        return HashUtils.areEqual(this._ssoUuids, other._ssoUuids);
    }

    public static LsppNegotiator createNegotiator(LsppService lspp) {
        URI lsppUrl;
        KeyStore store;
        Validate.notNull((Object)lspp, (String)"lspp");
        LsppServiceEndpoint ep = SsoUtils.getAdminEndpoint(lspp);
        try {
            store = CertificateUtils.createTrustStore(ep.getCertificates());
        }
        catch (IOException | GeneralSecurityException e) {
            throw Exceptions.getRuntimeException((Throwable)e);
        }
        try {
            lsppUrl = Config.createLsppUrl(ep.url.getHost(), ep.url.getPort());
        }
        catch (URISyntaxException e) {
            throw Exceptions.getRuntimeException((Throwable)e);
        }
        return new LsppNegotiator(lsppUrl, null, store);
    }

    private static Promise<Map<Types.LsppType, Set<LsppService>>> queryServices(LsppService lspp) {
        Promise<Map<Types.LsppType, Set<LsppService>>> result;
        LsppNegotiator ln = BaseLsppNode.createNegotiator(lspp);
        try {
            result = LsppHelper.listServers(ln, Types.LsppType.Vc, Types.LsppType.Spbm, Types.LsppType.Is, Types.LsppType.Srm, Types.LsppType.Hms);
        }
        catch (Exception exc) {
            LOGGER.error("Failed to list servers for {}", (Object)lspp, (Object)exc);
            ln.close();
            return Promises.reject((Exception)exc);
        }
        result.materialize().onSuccess(unused -> ln.close());
        return result;
    }

    private static boolean shouldRotate(Exception exc) {
        if (exc instanceof SslException) {
            return false;
        }
        return exc instanceof ConnectionException || exc instanceof TransportProtocolException || exc instanceof UnexpectedStatusCodeException || exc instanceof ServerCommunicationException;
    }

    private static Promise<Map<Types.LsppType, Set<LsppService>>> execute(RotationManager.Rotation<LsppService> rotation) {
        LsppService current = (LsppService)rotation.getCurrent();
        LsppService next = (LsppService)rotation.peekNext();
        Promise promise = next == null ? BaseLsppNode.queryServices(current) : Promises.anyOf((Promise[])new Promise[]{BaseLsppNode.queryServices(current), BaseLsppNode.queryServices(next)});
        return Streams.from((Publisher[])new Publisher[]{promise.materialize()}).flatMap(pr -> {
            if (pr.isSuccessful()) {
                return Promises.resolve((Object)pr.getResult());
            }
            Exception cause = pr.getError();
            if (BaseLsppNode.shouldRotate(cause) && next != null && RotationManager.shift((RotationManager.Rotation)rotation, (int)2)) {
                return BaseLsppNode.execute(rotation);
            }
            return Promises.reject((Exception)cause);
        }).next();
    }
}

