/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.core.mxn.nodes;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.srm.client.topology.client.view.availability.srm.SrmServer;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.BasePairNode;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.NodeContext;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.utils.PairSetupPublisher;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.utils.SrmHelper;
import com.vmware.srm.client.topology.impl.utils.L10N;
import com.vmware.srm.client.topology.impl.view.ServersViewImpl;
import com.vmware.srm.client.topology.impl.view.availability.srm.SrmPairSetupImpl;
import com.vmware.srm.client.topology.impl.view.availability.srm.SrmServerImpl;
import com.vmware.srm.client.topology.impl.vmomi.ClientUtils;
import com.vmware.srm.client.topology.impl.vmomi.TokenProvider;
import com.vmware.srm.client.topology.impl.vmomi.srm.SrmServiceImpl;
import com.vmware.vim.binding.dr.SessionManager;
import com.vmware.vim.binding.dr.fault.AlreadyLoggedInFault;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.Stub;
import java.util.function.Supplier;

class SrmPairNode
extends BasePairNode<SrmServerImpl, SrmPairSetupImpl, SrmHelper.PairInfo> {
    SrmPairNode(SrmServerImpl srm, SrmHelper.PairInfo pairInfo) {
        super(pairInfo.lsppUrl, pairInfo.lsppThumbprint, srm.guid(), pairInfo.srmUuid, srm, pairInfo, new PairSetupPublisher<SrmPairSetupImpl>(srm, 1));
    }

    @Override
    protected SrmPairSetupImpl createPairSetup(NodeContext context, ServersViewImpl view, SrmServerImpl server, SrmHelper.PairInfo pairInfo) {
        SrmPairSetupImpl ps = new SrmPairSetupImpl(view, server, pairInfo.lsppUrl, pairInfo.lsppThumbprint, pairInfo.srmUrl, pairInfo.srmName, pairInfo.srmUuid, pairInfo.vcUuid, pairInfo.vcName, pairInfo.remoteSiteRef, pairInfo.vcUrl);
        context.getRecorder().recordSrmPair(ps);
        return ps;
    }

    @Override
    protected void completePairSetup(SrmPairSetupImpl ps, TokenProvider tp) {
        ps.complete(new LoginRemoteSiteTask(ps, tp));
    }

    private static class LoginRemoteSiteTask
    implements Supplier<Promise<Void>> {
        private final SrmPairSetupImpl _pairSetup;
        private final TokenProvider _provider;

        LoginRemoteSiteTask(SrmPairSetupImpl pairSetup, TokenProvider provider) {
            this._pairSetup = pairSetup;
            this._provider = provider;
        }

        @Override
        public Promise<Void> get() {
            SrmServiceImpl service = (SrmServiceImpl)((SrmServer)this._pairSetup.server()).service();
            return service.getContent().thenCompose(content -> {
                SessionManager sm = (SessionManager)service.createStub(content.getSessionManager());
                ClientUtils.setAuthenticationData((Stub)sm, this._provider.getToken(), this._provider.getPrivateKey());
                FuturePromise result = new FuturePromise();
                sm.loginRemoteSiteByToken(this._pairSetup.pairServerVmomiRef(), L10N.getLocaleId(), (Future)result);
                return result;
            }).materialize().thenCompose(pr -> {
                if (pr.isSuccessful()) {
                    return Promises.resolve(null);
                }
                Exception cause = pr.getError();
                if (cause instanceof AlreadyLoggedInFault) {
                    return Promises.resolve(null);
                }
                return Promises.reject((Exception)cause);
            });
        }
    }
}

