/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.sso;

import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.srm.client.topology.impl.common.SyncUtils;
import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppService;
import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppServiceEndpoint;
import com.vmware.srm.client.topology.impl.sso.CertificateUtils;
import com.vmware.srm.client.topology.impl.sso.DrSecurityTokenService;
import com.vmware.srm.client.topology.impl.sso.SecurityTokenServiceProxy;
import com.vmware.srm.client.topology.impl.sso.SsoServiceImpl;
import com.vmware.srm.client.topology.impl.sso.SsoUtils;
import com.vmware.srm.client.topology.impl.sso.TokenManager;
import com.vmware.srm.client.topology.impl.utils.Exceptions;
import com.vmware.srm.client.topology.impl.vmomi.vlsi.SslTrust;
import com.vmware.srm.client.topology.impl.vmomi.vlsi.VlsiClientUtils;
import com.vmware.vim.binding.sso.admin.ConfigurationManagementService;
import com.vmware.vim.binding.sso.admin.ServiceContent;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.sso.client.SecurityTokenServiceConfig;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.impl.SslUtil;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SsoFacade {
    private static final Logger LOGGER = LoggerFactory.getLogger(SsoFacade.class);
    private static final String SHA256_ALG = "SHA-256";
    private static final TokenManager TOKEN_MANAGER = new TokenManager();

    public static TokenManager getTokenManager() {
        return TOKEN_MANAGER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509Certificate[] getSsoSignCertificates(LsppServiceEndpoint ep) throws GeneralSecurityException, IOException {
        KeyStore store = CertificateUtils.createTrustStore(ep.getCertificates());
        SsoServiceImpl sso = new SsoServiceImpl(ep.url, null, store, null);
        try {
            ManagedObjectReference cmsRef = ((ServiceContent)SyncUtils.getSync(sso.getContent())).getConfigurationManagementService();
            ConfigurationManagementService cms = (ConfigurationManagementService)sso.createStub(cmsRef);
            FuturePromise certs = new FuturePromise();
            cms.getIssuersCertificates((Future)certs);
            X509Certificate[] x509CertificateArray = SsoUtils.generateRootCertificates((String[])SyncUtils.getSync(certs));
            return x509CertificateArray;
        }
        finally {
            sso.dispose();
        }
    }

    public static DrSecurityTokenService createSts(LsppService sso) throws GeneralSecurityException, IOException {
        return SsoFacade.createSts(sso, SsoUtils.CERT, SsoUtils.KEY_PAIR.getPrivate());
    }

    public static DrSecurityTokenService createSts(LsppService sso, X509Certificate hokCerificate, PrivateKey hokPrivateKey) throws GeneralSecurityException, IOException {
        String thumbprint;
        X509Certificate[] sslCerts;
        X509Certificate[] signCerts;
        LsppServiceEndpoint stsEp;
        block7: {
            LsppServiceEndpoint adminEp = SsoUtils.getAdminEndpoint(sso);
            stsEp = SsoUtils.getStsEndpoint(sso);
            signCerts = SsoFacade.getSsoSignCertificates(adminEp);
            KeyStore trustStore = SslTrust.getTrustStore();
            if (trustStore == null) {
                sslCerts = stsEp.getCertificates().toArray(new X509Certificate[0]);
                try {
                    List<X509Certificate> chain = CertificateUtils.buildCertificatePath(stsEp.getCertificates());
                    if (chain.isEmpty()) {
                        LOGGER.warn("Certificate path for '{}' is empty", (Object)sso);
                        thumbprint = null;
                        break block7;
                    }
                    thumbprint = SslUtil.computeCertificateThumbprint((X509Certificate)chain.get(0), (String)SHA256_ALG);
                }
                catch (Exception exc) {
                    LOGGER.error("Unable to build certificate path for '{}'", (Object)sso, (Object)exc);
                    thumbprint = null;
                }
            } else {
                thumbprint = null;
                try {
                    sslCerts = VlsiClientUtils.getCertificates(trustStore).toArray(new X509Certificate[0]);
                }
                catch (KeyStoreException e) {
                    throw Exceptions.getRuntimeException(e);
                }
            }
        }
        SecurityTokenServiceConfig stsConfig = SsoUtils.createStsConfig(stsEp.url.toURL(), hokCerificate, hokPrivateKey, sslCerts, thumbprint, signCerts);
        return SecurityTokenServiceProxy.create(stsConfig);
    }
}

