/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.sso;

import com.vmware.dr.ui.tools.utilities.OperationWaiter;
import com.vmware.srm.client.topology.impl.common.Utils;
import com.vmware.srm.client.topology.impl.utils.L10N;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.sso.client.SecurityTokenService;
import com.vmware.vim.sso.client.TokenSpec;
import com.vmware.vim.sso.client.exception.SsoException;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenManager {
    private static final long DEFAULT_EXP_TIME = 28800L;
    private static final long DEFAULT_MIN_EXP_TIME = 600L;
    private static final long DELEGATED_TOKEN_LIFETIME = 3600L;
    private static final Logger LOGGER = LoggerFactory.getLogger(TokenManager.class);
    private static final ScheduledExecutorService EXEC = Utils.getScheduledExecutor();
    private final ConcurrentMap<SecurityTokenService, OperationWaiter<SamlToken>> _tokenBySts = new ConcurrentHashMap<SecurityTokenService, OperationWaiter<SamlToken>>();
    private final long _defaultExpireTime;
    private final long _minExpireTime;

    public static TokenSpec createSpec(long tokenLifetime) {
        TokenSpec.Builder builder = new TokenSpec.Builder(tokenLifetime);
        builder.delegationSpec(new TokenSpec.DelegationSpec(true));
        builder.renewable(true);
        return builder.createTokenSpec();
    }

    public static TokenSpec createSpec(long tokenLifetime, SamlToken actAsToken) {
        TokenSpec.Builder builder = new TokenSpec.Builder(tokenLifetime);
        builder.delegationSpec(new TokenSpec.DelegationSpec(actAsToken, true));
        builder.renewable(true);
        return builder.createTokenSpec();
    }

    public static TokenSpec createSpecFromToken(SamlToken t) {
        TokenSpec.Builder builder = new TokenSpec.Builder(TokenManager.getTokenLifetimeSecs(t));
        return builder.renewable(t.isRenewable()).createTokenSpec();
    }

    public static long getTokenLifetimeSecs(SamlToken t) {
        Date startDate = t.getStartTime();
        Date expirationDate = t.getExpirationTime();
        long tokenLifetimeMillis = expirationDate.getTime() - startDate.getTime();
        return TimeUnit.MILLISECONDS.toSeconds(tokenLifetimeMillis);
    }

    public static SamlToken acquireDelegatedToken(SecurityTokenService sts, SamlToken token, String delegateTo) throws SsoException {
        Validate.notNull((Object)sts, (String)"sts");
        Validate.notNull((Object)token, (String)"token");
        Validate.notEmpty((String)delegateTo, (String)"delegateTo");
        TokenSpec.Builder builder = new TokenSpec.Builder(3600L).renewable(true);
        builder.delegationSpec(new TokenSpec.DelegationSpec(false, delegateTo));
        return sts.acquireTokenByToken(token, builder.createTokenSpec());
    }

    public TokenManager() {
        this._defaultExpireTime = 28800L;
        this._minExpireTime = 600L;
    }

    public TokenManager(long tokenExpireTime, long minTimeBeforeRenew) {
        this._defaultExpireTime = tokenExpireTime;
        this._minExpireTime = minTimeBeforeRenew;
    }

    public SamlToken acquireToken(SecurityTokenService sts, String user, String password) throws SsoException, TokenRequestExists {
        OperationWaiter waiter = new OperationWaiter();
        if (this._tokenBySts.putIfAbsent(sts, (OperationWaiter<SamlToken>)waiter) != null) {
            throw new TokenRequestExists();
        }
        try {
            SamlToken token = sts.acquireToken(user, password, TokenManager.createSpec(this._defaultExpireTime));
            this.scheduleRenewTaskFor(sts, (OperationWaiter<SamlToken>)waiter, token);
            waiter.setResult((Object)token);
            return token;
        }
        catch (SsoException e) {
            this._tokenBySts.remove(sts);
            waiter.setError((Exception)((Object)e));
            throw e;
        }
        catch (RuntimeException e) {
            this._tokenBySts.remove(sts);
            waiter.setError((Exception)e);
            throw e;
        }
    }

    public SamlToken acquireTokenByCertificate(SecurityTokenService sts) throws SsoException, TokenRequestExists {
        OperationWaiter waiter = new OperationWaiter();
        if (this._tokenBySts.putIfAbsent(sts, (OperationWaiter<SamlToken>)waiter) != null) {
            throw new TokenRequestExists();
        }
        try {
            SamlToken result = sts.acquireTokenByCertificate(TokenManager.createSpec(this._defaultExpireTime));
            this.scheduleRenewTaskFor(sts, (OperationWaiter<SamlToken>)waiter, result);
            waiter.setResult((Object)result);
            return result;
        }
        catch (SsoException e) {
            this._tokenBySts.remove(sts);
            waiter.setError((Exception)((Object)e));
            throw e;
        }
        catch (RuntimeException e) {
            this._tokenBySts.remove(sts);
            waiter.setError((Exception)e);
            throw e;
        }
    }

    public SamlToken acquireImpersonatingToken(SecurityTokenService sts, SamlToken suToken, SamlToken actAsToken) throws SsoException, TokenRequestExists {
        OperationWaiter waiter = new OperationWaiter();
        if (this._tokenBySts.putIfAbsent(sts, (OperationWaiter<SamlToken>)waiter) != null) {
            throw new TokenRequestExists();
        }
        try {
            SamlToken token = sts.acquireTokenByToken(suToken, TokenManager.createSpec(this._defaultExpireTime, actAsToken));
            token = sts.renewToken(token, this._defaultExpireTime);
            this.scheduleRenewTaskFor(sts, (OperationWaiter<SamlToken>)waiter, token);
            waiter.setResult((Object)token);
            return token;
        }
        catch (SsoException e) {
            this._tokenBySts.remove(sts);
            waiter.setError((Exception)((Object)e));
            throw e;
        }
        catch (RuntimeException e) {
            this._tokenBySts.remove(sts);
            waiter.setError((Exception)e);
            throw e;
        }
    }

    public SamlToken acquireDelegatedToken(SecurityTokenService sts, String delegateTo) throws SsoException {
        SamlToken token = this.getCurrentTokenFor(sts);
        if (token == null) {
            throw new RuntimeException(L10N.localize("tokenManager.noTokenAvailable", new Object[0]));
        }
        return TokenManager.acquireDelegatedToken(sts, token, delegateTo);
    }

    public void releaseToken(SecurityTokenService sts) {
        this._tokenBySts.remove(sts);
    }

    public SamlToken getCurrentTokenFor(SecurityTokenService sts) {
        OperationWaiter waiter = (OperationWaiter)this._tokenBySts.get(sts);
        if (waiter == null || waiter.getError() != null) {
            return null;
        }
        return (SamlToken)waiter.get();
    }

    public void dispose() {
        this._tokenBySts.clear();
    }

    private void scheduleRenewTaskFor(SecurityTokenService sts, OperationWaiter<SamlToken> currentWaiter, SamlToken currentToken) {
        Date exp = currentToken.getExpirationTime();
        long lifetimeMillis = exp.getTime() - System.currentTimeMillis();
        long lifetimeSecs = TimeUnit.MILLISECONDS.toSeconds(lifetimeMillis);
        long interval = Math.max(0L, lifetimeSecs - this._minExpireTime);
        EXEC.schedule(new RenewTask(sts, currentWaiter, currentToken), interval, TimeUnit.SECONDS);
    }

    private class RenewTask
    implements Runnable {
        private final WeakReference<SecurityTokenService> _stsRef;
        private final OperationWaiter<SamlToken> _prevWaiter;
        private final SamlToken _prevToken;

        RenewTask(SecurityTokenService sts, OperationWaiter<SamlToken> prevWaiter, SamlToken prevToken) {
            this._stsRef = new WeakReference<SecurityTokenService>(sts);
            this._prevWaiter = prevWaiter;
            this._prevToken = prevToken;
        }

        @Override
        public void run() {
            SecurityTokenService sts = (SecurityTokenService)this._stsRef.get();
            if (sts == null) {
                return;
            }
            OperationWaiter newWaiter = new OperationWaiter();
            if (TokenManager.this._tokenBySts.replace(sts, this._prevWaiter, newWaiter)) {
                try {
                    SamlToken newToken = sts.renewToken(this._prevToken, TokenManager.getTokenLifetimeSecs(this._prevToken));
                    TokenManager.this.scheduleRenewTaskFor(sts, (OperationWaiter<SamlToken>)newWaiter, newToken);
                    newWaiter.setResult((Object)newToken);
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to renew token", (Throwable)e);
                    TokenManager.this._tokenBySts.remove(sts);
                    newWaiter.setError(e);
                }
            }
        }
    }

    public static class TokenRequestExists
    extends RuntimeException {
        private static final long serialVersionUID = 4659085900698244169L;

        TokenRequestExists() {
            super(L10N.localize("tokenManager.requestExists", new Object[0]));
        }
    }
}

