/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.core.soap.impl.unmarshaller;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.exception.UnmarshallException;
import com.vmware.vim.vmomi.core.soap.impl.unmarshaller.Environment;
import com.vmware.vim.vmomi.core.soap.impl.unmarshaller.MoRefStackContext;
import com.vmware.vim.vmomi.core.soap.impl.unmarshaller.StackContext;
import com.vmware.vim.vmomi.core.types.VmodlField;
import com.vmware.vim.vmomi.core.types.VmodlType;
import java.util.Map;
import javax.xml.namespace.QName;

class ManagedObjectStackContext
extends MoRefStackContext {
    private Object _mo;
    private final Environment _env;

    public ManagedObjectStackContext(VmodlField field, VmodlType type, StackContext parent, Map<QName, String> attrs, Environment env) throws UnmarshallException {
        super(field, type, parent, attrs, env);
        this._env = env;
        if (env.isQSFormat()) {
            this.createManagedObject(super.getValue());
        }
    }

    @Override
    public void setValue(Object value) throws UnmarshallException {
        super.setValue(value);
        this.createManagedObject(super.getValue());
    }

    @Override
    public Object getValue() {
        return this._mo;
    }

    private void createManagedObject(Object value) throws UnmarshallException {
        ManagedObjectReference moRef = (ManagedObjectReference)value;
        try {
            this._mo = this._env.getManagedObjectFactory().createManagedObject(this._env.getContext(), this._env.getTypeMap(), this._env.getVersion(), moRef);
        }
        catch (InstantiationException e) {
            throw new UnmarshallException(String.format("Failed to instantiate managed object stub of type '%s'", moRef.getType()), e);
        }
    }
}

