/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.client.http.impl;

import com.vmware.vim.vmomi.core.tracing.GlobalTracer;
import com.vmware.vim.vmomi.core.tracing.TracingFeature;
import io.opentracing.Scope;
import io.opentracing.ScopeManager;
import io.opentracing.Span;

abstract class TracingScopedRunnable
implements Runnable {
    TracingScopedRunnable() {
    }

    @Override
    public void run() {
        if (!TracingFeature.ON) {
            this.invokeWithinScope();
            return;
        }
        Span requestSpan = (Span)this.getTracingSpan();
        ScopeManager sm = GlobalTracer.get().scopeManager();
        try (Scope scope = sm.activate(requestSpan);){
            this.invokeWithinScope();
        }
    }

    protected abstract void invokeWithinScope();

    protected abstract Object getTracingSpan();
}

