/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.dr.ui.tools.utilities;

import com.vmware.dr.ui.tools.utilities.OperationWaiter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class ParallelExecutor {
    private final Executor _exec;

    public ParallelExecutor(Executor exec) {
        this._exec = exec;
    }

    public <T> Task<T> submit(Callable<T> call) {
        TaskImpl<T> result = new TaskImpl<T>(null, call);
        this.execute(result);
        return result;
    }

    @SafeVarargs
    public final <T extends Callable<?>> AggregateTask submit(T ... calls) {
        return this.submit(Arrays.asList(calls));
    }

    public AggregateTask submit(List<? extends Callable<?>> calls) {
        AggregateTaskImpl result = new AggregateTaskImpl(new HashSet(calls));
        result.submit();
        return result;
    }

    void execute(Runnable r) {
        this._exec.execute(r);
    }

    private class AggregateTaskImpl
    implements AggregateTask {
        private final AtomicInteger _allTasks;
        private final AtomicReference<Exception> _firstError = new AtomicReference();
        private final Map<Callable<?>, TaskImpl<?>> _taskByCallable;
        private final CountDownLatch _complete = new CountDownLatch(1);

        AggregateTaskImpl(Set<Callable<?>> tasks) {
            this._allTasks = new AtomicInteger(tasks.size());
            this._taskByCallable = new HashMap(tasks.size());
            for (Callable<?> c : tasks) {
                this._taskByCallable.put(c, new TaskImpl(this, c));
            }
        }

        @Override
        public Void getResult() throws TaskException {
            Exception err = this.getError();
            if (err != null) {
                throw new TaskException(err);
            }
            return null;
        }

        @Override
        public Exception getError() {
            Exception err;
            while ((err = this._firstError.get()) == null) {
                if (this._allTasks.get() == 0) {
                    return this._firstError.get();
                }
                try {
                    this._complete.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return null;
                }
            }
            return err;
        }

        @Override
        public <T> Task<T> getTaskBy(Callable<T> c) {
            return this._taskByCallable.get(c);
        }

        void submit() {
            for (TaskImpl<?> t : this._taskByCallable.values()) {
                ParallelExecutor.this.execute(t);
            }
        }

        void taskFinished(TaskImpl<?> task, Exception err) {
            boolean firstError;
            boolean bl = firstError = err != null && this._firstError.compareAndSet(null, err);
            if (firstError || this._allTasks.decrementAndGet() == 0 && err == null) {
                this._complete.countDown();
            }
            if (firstError) {
                for (TaskImpl<?> t : this._taskByCallable.values()) {
                    if (t == task) continue;
                    task.cancel();
                }
            }
        }
    }

    private static class TaskImpl<T>
    implements Task<T>,
    Runnable {
        private final AggregateTaskImpl _parent;
        private final FutureTask<T> _innerTask;
        private final OperationWaiter<T> _waiter = new OperationWaiter();

        TaskImpl(AggregateTaskImpl parent, Callable<T> task) {
            this._parent = parent;
            this._innerTask = new FutureTask<T>(task){

                @Override
                protected void setException(Throwable t) {
                    super.setException(t);
                    Exception err = t instanceof Exception ? (Exception)t : new Exception(t);
                    _waiter.setError(err);
                    this.notifyParent(err);
                }

                @Override
                protected void set(T result) {
                    super.set(result);
                    _waiter.setResult(result);
                    this.notifyParent(null);
                }
            };
        }

        @Override
        public T getResult() throws TaskException {
            Exception err = this._waiter.getError();
            if (err != null) {
                throw new TaskException(err);
            }
            return this._waiter.get();
        }

        @Override
        public Exception getError() {
            return this._waiter.getError();
        }

        @Override
        public void run() {
            this._innerTask.run();
        }

        void cancel() {
            if (this._innerTask.cancel(false)) {
                TaskCanceledException err = new TaskCanceledException();
                this._waiter.setError(err);
                this.notifyParent(err);
            }
        }

        void notifyParent(Exception err) {
            if (this._parent != null) {
                this._parent.taskFinished(this, err);
            }
        }
    }

    public static interface AggregateTask
    extends Task<Void> {
        public <T> Task<T> getTaskBy(Callable<T> var1);
    }

    public static interface Task<T> {
        public T getResult() throws TaskException;

        public Exception getError();
    }

    public static class TaskCanceledException
    extends RuntimeException {
        private static final long serialVersionUID = 2785400804178533629L;

        public TaskCanceledException() {
            super("Task is canceled.");
        }
    }

    public static class TaskException
    extends RuntimeException {
        private static final long serialVersionUID = -6127673081746183775L;

        public TaskException(Exception cause) {
            super(cause);
        }
    }
}

