/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vr.client.impex.tool;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.vim.binding.dr.vvolProvider.DomainInfo;
import com.vmware.vim.binding.pbm.profile.Profile;
import com.vmware.vr.client.impex.importers.inventory.InventoryExtractor;

public abstract class ImpexStageExecutor<T> {
    protected final StageParams _stageParams = new StageParams();

    protected ImpexStageExecutor() {
    }

    public final Promise<Void> start() {
        T startContext;
        ImpexStage startStage;
        try {
            startStage = this.initialStage();
        }
        catch (Exception e) {
            return Promises.reject((Exception)e);
        }
        try {
            startContext = this.initialContext();
        }
        catch (Exception e) {
            return Promises.reject((Exception)e);
        }
        return this.startStage(startStage, startContext).thenApply(unused -> null);
    }

    protected T initialContext() {
        return null;
    }

    protected abstract ImpexStage initialStage();

    protected final Promise<ImpexStage> startStage(ImpexStage stage, T context) {
        return stage.execute().materialize().thenCompose(pr -> {
            Object nextContext;
            if (!pr.isSuccessful()) {
                Exception cause = pr.getError();
                try {
                    this.stageFailed(stage, cause, context);
                }
                catch (Exception e) {
                    cause.addSuppressed(e);
                }
                return Promises.reject((Exception)cause);
            }
            ImpexStage nextStage = (ImpexStage)pr.getResult();
            try {
                nextContext = this.stageComplete(stage, nextStage, context);
            }
            catch (Exception e) {
                return Promises.reject((Exception)e);
            }
            if (nextStage == null) {
                return Promises.resolve(null);
            }
            return this.startStage(nextStage, nextContext);
        });
    }

    protected T stageComplete(ImpexStage stage, ImpexStage nextStage, T context) {
        return context;
    }

    protected void stageFailed(ImpexStage stage, Exception cause, T context) {
    }

    protected static abstract class ImpexStage {
        private final StageParams _stageParams;

        protected ImpexStage(StageParams stageParams) {
            this._stageParams = stageParams;
        }

        public final Promise<? extends ImpexStage> execute() {
            Promise<StageParams> paramsPromise;
            try {
                paramsPromise = this.process(this._stageParams);
            }
            catch (Exception e) {
                return Promises.reject((Exception)e);
            }
            return paramsPromise.thenApply(this::getNext);
        }

        protected abstract Promise<StageParams> process(StageParams var1);

        protected abstract ImpexStage getNext(StageParams var1);
    }

    public static final class StageParams {
        final InventoryExtractor.InventoryLookup inventory;
        final Profile[] localProfiles;
        final Profile[] remoteProfiles;
        final DomainInfo[] localDomainInfos;
        final DomainInfo[] remoteDomainInfos;

        public StageParams() {
            this.inventory = null;
            this.localProfiles = null;
            this.remoteProfiles = null;
            this.localDomainInfos = null;
            this.remoteDomainInfos = null;
        }

        public StageParams(InventoryExtractor.InventoryLookup inventory, Profile[] localProfiles, Profile[] remoteProfiles, DomainInfo[] localDomainInfos, DomainInfo[] remoteDomainInfos) {
            this.inventory = inventory;
            this.localProfiles = localProfiles;
            this.remoteProfiles = remoteProfiles;
            this.localDomainInfos = localDomainInfos;
            this.remoteDomainInfos = remoteDomainInfos;
        }

        StageParams setInventory(InventoryExtractor.InventoryLookup inventory) {
            return new StageParams(inventory, this.localProfiles, this.remoteProfiles, this.localDomainInfos, this.remoteDomainInfos);
        }

        StageParams setProfiles(Profile[] localProfiles, Profile[] remoteProfiles) {
            return new StageParams(this.inventory, localProfiles, remoteProfiles, this.localDomainInfos, this.remoteDomainInfos);
        }

        StageParams setFaultDomains(DomainInfo[] localDomainInfos, DomainInfo[] remoteDomainInfos) {
            return new StageParams(this.inventory, this.localProfiles, this.remoteProfiles, localDomainInfos, remoteDomainInfos);
        }
    }
}

