/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vr.client.impex.utils;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.PromiseImpl;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.dr.ui.tools.reactive.impl.Streams;
import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.srm.client.topology.client.vmomi.availability.hms.HmsService;
import com.vmware.vim.binding.hms.HmsTask;
import com.vmware.vim.binding.vim.TaskInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vr.client.impex.tool.HmsServersDataWrapper;
import com.vmware.vr.client.impex.utils.TaskMonitor;
import java.util.HashSet;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HmsTaskMonitorImpl
implements TaskMonitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(HmsTaskMonitorImpl.class);
    private final HmsServersDataWrapper _serversDataWrapper;
    private final ConcurrentMap<ManagedObjectReference, PromiseImpl> _taskRefCache = new ConcurrentHashMap<ManagedObjectReference, PromiseImpl>();
    private final AtomicBoolean _isRunning = new AtomicBoolean(false);

    public HmsTaskMonitorImpl(HmsServersDataWrapper serversDataWrapper) {
        this._serversDataWrapper = serversDataWrapper;
    }

    @Override
    public <T> Promise<T> monitor(ManagedObjectReference taskRef) {
        PromiseImpl result = new PromiseImpl();
        if (!taskRef.getServerGuid().equals(this._serversDataWrapper.getLocalContent().siteUuid) && !taskRef.getServerGuid().equals(this._serversDataWrapper.getRemoteContent().siteUuid)) {
            return Promises.reject((Exception)new RuntimeException("Unsupported server moRef, it is not " + this._serversDataWrapper.getLocalContent().siteUuid + "nor " + this._serversDataWrapper.getRemoteContent().siteUuid));
        }
        PromiseImpl prev = this._taskRefCache.putIfAbsent(taskRef, result);
        if (prev != null) {
            return prev;
        }
        LOGGER.trace("Added task to monitor '{}'", (Object)taskRef);
        if (this._isRunning.compareAndSet(false, true)) {
            this.startMonitor();
        }
        return result;
    }

    private void startMonitor() {
        HashSet tasks = new HashSet(this._taskRefCache.keySet());
        LOGGER.debug("Monitoring {} tasks.", (Object)tasks.size());
        Streams.from(this._taskRefCache.keySet()).flatMap(taskRef -> this._serversDataWrapper.getView().getHmsBy(taskRef.getServerGuid()).thenCompose(hmsServer -> {
            HmsTask task = (HmsTask)((HmsService)hmsServer.service()).createStub(taskRef);
            Promise<TaskInfo> taskPromise = HmsTaskMonitorImpl.getTaskInfo(task);
            return taskPromise.materialize().thenApply(pr -> {
                if (pr.isSuccessful()) {
                    return (TaskInfo)pr.getResult();
                }
                LOGGER.warn("Error happen while retrieving the task.", (Throwable)pr.getError());
                PromiseImpl taskResult = (PromiseImpl)this._taskRefCache.remove(taskRef);
                taskResult.setError(pr.getError());
                return null;
            });
        })).filter(Objects::nonNull).map(taskInfo -> {
            TaskInfo.State taskState = taskInfo.getState();
            LOGGER.trace("Retrieved task state '{}' for '{}'.", (Object)taskState, (Object)taskInfo.getTask());
            switch (taskState) {
                case queued: 
                case running: {
                    break;
                }
                case success: {
                    this.removeTask(this._taskRefCache, taskInfo.getTask()).setResult(taskInfo.result);
                    break;
                }
                case error: {
                    this.removeTask(this._taskRefCache, taskInfo.getTask()).setError(taskInfo.getError());
                }
            }
            return taskInfo;
        }).collect().thenApply(unused -> {
            this.checkStatus();
            return null;
        });
    }

    public static Promise<TaskInfo> getTaskInfo(HmsTask hmsTask) {
        FuturePromise taskInfoFuturePromise = new FuturePromise();
        hmsTask.getInfo((Future)taskInfoFuturePromise);
        return taskInfoFuturePromise.onError(ex -> LOGGER.error("Failed to get task info: ", (Throwable)ex));
    }

    private PromiseImpl removeTask(ConcurrentMap<ManagedObjectReference, PromiseImpl> taskRefCache, ManagedObjectReference task) {
        LOGGER.debug("Task {} to be finished and removed from task monitor.", (Object)task.getValue());
        return ((Stream)taskRefCache.keySet().stream().parallel()).filter(mor -> mor.getValue().equals(task.getValue())).findFirst().map(mor -> {
            LOGGER.info("Task {} removed.", (Object)task.getValue());
            return (PromiseImpl)taskRefCache.remove(mor);
        }).orElseGet(() -> {
            LOGGER.warn("No task need to be removed.");
            return new PromiseImpl();
        });
    }

    private void checkStatus() {
        LOGGER.debug("Monitoring {} tasks.", (Object)this._taskRefCache.size());
        if (this._taskRefCache.isEmpty()) {
            LOGGER.debug("No tasks left.");
            this._isRunning.set(false);
            if (!this._taskRefCache.isEmpty() && this._isRunning.compareAndSet(false, true)) {
                this.startMonitor();
            }
            return;
        }
        Promises.createDelayedPromise((long)1000L, (Object)Boolean.TRUE).onSuccess(unused -> this.startMonitor());
    }
}

