/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.vmomi.vlsi;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.srm.client.topology.impl.vmomi.invocation.ShutdownException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;

public abstract class Coordinator {
    private final AtomicBoolean _running = new AtomicBoolean(true);
    private final AtomicInteger _ongoingInvocations = new AtomicInteger(0);
    private final AtomicBoolean _doShutdown = new AtomicBoolean(false);

    public Promise invoke(Supplier<Promise> supplier) {
        Promise result;
        if (!this._running.get()) {
            return Promises.reject((Exception)new ShutdownException(this.getHost()));
        }
        this._ongoingInvocations.incrementAndGet();
        if (!this._running.get()) {
            if (this._ongoingInvocations.decrementAndGet() == 0) {
                this.internalShutdown();
            }
            return Promises.reject((Exception)new ShutdownException(this.getHost()));
        }
        try {
            result = supplier.get();
        }
        catch (RuntimeException re) {
            if (this._ongoingInvocations.decrementAndGet() == 0 && !this._running.get()) {
                this.internalShutdown();
            }
            return Promises.reject((Exception)re);
        }
        result.materialize().onSuccess(unused -> {
            if (this._ongoingInvocations.decrementAndGet() == 0 && !this._running.get()) {
                this.internalShutdown();
            }
        });
        return result;
    }

    public void shutdown() {
        if (this._running.getAndSet(false) && this._ongoingInvocations.get() == 0) {
            this.internalShutdown();
        }
    }

    abstract String getHost();

    abstract void doShutdown();

    private void internalShutdown() {
        if (this._doShutdown.compareAndSet(false, true)) {
            this.doShutdown();
        }
    }
}

