/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.spec;

import java.security.spec.AlgorithmParameterSpec;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.crypto.general.GOST28147;
import org.bouncycastle.util.Arrays;

public class GOST28147ParameterSpec
implements AlgorithmParameterSpec {
    private final byte[] iv;
    private final byte[] sBox;

    public GOST28147ParameterSpec(byte[] byArray) {
        this(byArray, null);
    }

    public GOST28147ParameterSpec(byte[] byArray, byte[] byArray2) {
        this.sBox = Arrays.clone(byArray);
        this.iv = Arrays.clone(byArray2);
    }

    public GOST28147ParameterSpec(String string) {
        this(string, null);
    }

    public GOST28147ParameterSpec(String string, byte[] byArray) {
        this.sBox = GOST28147.getSBox(string);
        this.iv = Arrays.clone(byArray);
    }

    public GOST28147ParameterSpec(ASN1ObjectIdentifier aSN1ObjectIdentifier, byte[] byArray) {
        this.sBox = GOST28147.getSBox(aSN1ObjectIdentifier);
        this.iv = Arrays.clone(byArray);
    }

    public byte[] getSBox() {
        return Arrays.clone(this.sBox);
    }

    public byte[] getIV() {
        return Arrays.clone(this.iv);
    }
}

