/*
 * Decompiled with CFR 0.152.
 */
package dochandling;

import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LinkParser {
    private static Pattern _pattern = Pattern.compile("\\{@link.*?\\}", 32);
    private ArrayList<Link> _links;
    private StringBuilder _docComment;

    public LinkParser(String docComment) {
        this._docComment = new StringBuilder(docComment == null ? "" : docComment);
        this._links = new ArrayList();
        Matcher m = _pattern.matcher(docComment == null ? "" : docComment);
        while (m.find()) {
            String link = docComment.substring(m.start() + 6, m.end() - 1).trim();
            Link l = new Link();
            this._links.add(0, l);
            l.offset = m.start();
            l.lengh = m.end() - m.start();
            int space = link.indexOf(32);
            if (space == -1) {
                l.setTarget(link);
                continue;
            }
            l.setTarget(link.substring(0, space).trim());
            l.setLabel(link.substring(space).trim());
        }
    }

    public Collection<Link> getLinks() {
        return this._links;
    }

    public void updateDocumentation(Link link) {
        this._docComment.replace(link.offset, link.lengh + link.offset, link.getLinkHtml());
    }

    public String getFinalDocumentation() {
        return this._docComment.toString();
    }

    public static class Link {
        private int offset;
        private int lengh;
        private String target;
        private String label;
        private String linkHtml;

        public void setTarget(String target) {
            this.target = target;
        }

        public String getTarget() {
            return this.target;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLinkHtml(String linkHtml) {
            this.linkHtml = linkHtml;
        }

        public String getLinkHtml() {
            return this.linkHtml;
        }
    }
}

