/*
 * Decompiled with CFR 0.152.
 */
package emitters.backend;

import emitters.backend.FeatureState;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class FssConfig {
    private Map<String, FeatureState> _map;
    private String _product;
    private final boolean _isFrozen;

    public FssConfig(int numFeatures, boolean isFrozen) {
        this._map = new HashMap<String, FeatureState>(numFeatures);
        this._isFrozen = isFrozen;
    }

    public void addFeature(String name, FeatureState state) {
        this._map.put(name, state);
    }

    public void setProduct(String product) {
        this._product = product;
    }

    public void seal() {
        this._map = Collections.unmodifiableMap(this._map);
    }

    public FeatureState getState(String featureName) {
        FeatureState state = this._map.get(featureName);
        if (state == null) {
            throw new RuntimeException("Unknown feature: " + featureName);
        }
        return state;
    }

    public String getProduct() {
        return this._product;
    }

    public boolean isFrozen() {
        return this._isFrozen;
    }
}

