/*
 * Decompiled with CFR 0.152.
 */
package emitters.core;

import emitters.model.Privilege;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PrivilegeDefinitionBuilder {
    public static final String PRIV_SYSTEM_ANONYMOUS = "System.Anonymous";
    public static final String PRIV_SYSTEM_VIEW = "System.View";
    public static final String PRIV_SYSTEM_READ = "System.Read";
    private List<Privilege> _privList = new ArrayList<Privilege>();
    private List<String> _systemPrivs = new ArrayList<String>();

    public PrivilegeDefinitionBuilder() {
        this._systemPrivs.add(PRIV_SYSTEM_ANONYMOUS);
        this._systemPrivs.add(PRIV_SYSTEM_VIEW);
        this._systemPrivs.add(PRIV_SYSTEM_READ);
    }

    public List<String> systemDefinedPrivileges() {
        return this._systemPrivs;
    }

    public List<Privilege> loadPrivileges(String privXml) {
        Document document;
        if (privXml == null) {
            throw new RuntimeException("Privilege definition xml file not specified");
        }
        this._privList.clear();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(new File(privXml));
        }
        catch (SAXException sxe) {
            throw new RuntimeException("Parse error: " + sxe.getMessage());
        }
        catch (ParserConfigurationException pce) {
            throw new RuntimeException("Parse configuration error: " + pce.getMessage());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new RuntimeException(ioe);
        }
        Element root = document.getDocumentElement();
        if (!root.getNodeName().equals("privileges")) {
            throw new RuntimeException(privXml + ": <privileges> node not found");
        }
        this.findPrivileges(root, null);
        return this._privList;
    }

    private void findPrivileges(Element e, String parentPath) {
        List<Element> groups = this.getChildElements(e, "group");
        List<Element> privs = this.getChildElements(e, "privilege");
        if (groups.size() > 0) {
            if (privs.size() > 0) {
                throw new RuntimeException("A privilege group can hold either groups or privileges, but not both");
            }
            for (int i = 0; i < groups.size(); ++i) {
                Element group = groups.get(i);
                String groupName = this.getElementValue(group, "name");
                if (groupName == null) {
                    throw new RuntimeException("Missing group name tag");
                }
                if (parentPath == null) {
                    this.findPrivileges(group, groupName);
                    continue;
                }
                this.findPrivileges(group, parentPath + "." + groupName);
            }
        } else {
            if (parentPath == null) {
                throw new RuntimeException("Privileges must be contained in a group");
            }
            for (int j = 0; j < privs.size(); ++j) {
                Element priv = privs.get(j);
                String privId = this.getElementValue(priv, "id");
                if (privId == null) {
                    throw new RuntimeException("Missing privilege id tag");
                }
                boolean onParent = false;
                String onParentTag = this.getElementValue(priv, "onParent");
                if (onParentTag != null && onParentTag.equalsIgnoreCase("true")) {
                    onParent = true;
                }
                String privReferenceId = parentPath + "." + privId;
                this._privList.add(new Privilege(privReferenceId, parentPath, onParent));
            }
        }
    }

    private List<Element> getChildElements(Element e, String name) {
        ArrayList<Element> list = new ArrayList<Element>();
        NodeList children = e.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !child.getNodeName().equals(name)) continue;
            list.add((Element)child);
        }
        return list;
    }

    private String getElementValue(Element e, String tag) {
        NodeList children = e.getChildNodes();
        Node sub = null;
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !child.getNodeName().equals(tag)) continue;
            if (sub != null) {
                throw new RuntimeException("Multiple values for \"" + tag + "\"");
            }
            sub = (Element)child;
        }
        if (sub == null) {
            return null;
        }
        String text = sub.getTextContent().trim();
        if (text.isEmpty()) {
            throw new RuntimeException("Missing value for \"" + tag + "\"");
        }
        return text;
    }
}

