/*
 * Decompiled with CFR 0.152.
 */
package emitters.generators.joap;

import emitters.ObjectRegistry;
import emitters.Versions;
import emitters.generators.joap.JoapEmitter;
import emitters.generators.joap.ObjectsEnumerator;
import emitters.generators.joap.OperationId;
import emitters.model.DataObject;
import emitters.model.Enum;
import emitters.model.ManagedObject;
import emitters.model.ManagedProperty;
import emitters.model.Method;
import emitters.model.Property;
import emitters.model.VmodlApi;
import emitters.model.VmodlDecl;
import emitters.model.VmodlObject;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class OpenAPI3
extends JoapEmitter {
    private final OP_ID_FLAVOR _opIdFlavor;
    private final boolean _variableNamespace;
    private final boolean _variableVersion;
    private final ManagedObject[] _managedObjects;
    private final DataObject[] _dataObjects;
    private final Enum[] _enums;
    private static final Comparator<VmodlApi> NameComparator = new Comparator<VmodlApi>(){

        @Override
        public int compare(VmodlApi lhs, VmodlApi rhs) {
            return lhs.getName().compareTo(rhs.getName());
        }
    };
    private static final Comparator<VmodlObject> VmodlObjectComparator = new Comparator<VmodlObject>(){

        @Override
        public int compare(VmodlObject lhs, VmodlObject rhs) {
            return JoapEmitter.getJsonName(lhs).compareTo(JoapEmitter.getJsonName(rhs));
        }
    };
    private static final String NAMESPACE_PARAM_NAME = "urlNamespace";
    private static final String NAMESPACE_PARAM_SCHEMA_NAME = "urlNamespace";
    private static final String VERSION_PARAM_NAME = "urlVersion";
    private static final String VERSION_PARAM_SCHEMA_NAME = "urlVersion";
    private static final Method[] METHOD_ARRAY = new Method[0];
    private static final Property[] PROPERTY_ARRAY = new Property[0];
    private static final DataObject[] DATA_OBJECT_ARRAY = new DataObject[0];
    private static final List<DataObject> NO_FAULTS = new ArrayList<DataObject>();
    private static final String BYTE_MIN = "-128";
    private static final String BYTE_MAX = "127";
    private static final String SHORT_MIN = "-32768";
    private static final String SHORT_MAX = "32767";
    private static final String APPLICATION_JSON = "application/json:";

    public OpenAPI3(Map<String, String> options, String folder) {
        super(folder);
        OP_ID_FLAVOR opIdFlavor_ = OP_ID_FLAVOR.DEFAULT;
        String opIdFlavor = options.get("opid.flavor");
        if (opIdFlavor != null) {
            if (opIdFlavor.equals("with.hash")) {
                opIdFlavor_ = OP_ID_FLAVOR.WITH_HASH;
            } else if (opIdFlavor.equals("optimized")) {
                opIdFlavor_ = OP_ID_FLAVOR.OPTIMIZED;
            } else {
                throw new RuntimeException("Unkwnown opid.flavor: " + opIdFlavor);
            }
        }
        this._opIdFlavor = opIdFlavor_;
        boolean variableNamespace_ = false;
        boolean variableVersion_ = false;
        String urlFlavor = options.get("url.flavor");
        if (urlFlavor != null) {
            if (urlFlavor.equals("variable.namespace")) {
                variableNamespace_ = true;
            } else if (urlFlavor.equals("variable.version")) {
                variableVersion_ = true;
            } else if (urlFlavor.equals("variable.schema")) {
                variableNamespace_ = true;
                variableVersion_ = true;
            } else {
                throw new RuntimeException("Unkown url.flavor: " + urlFlavor);
            }
        }
        this._variableNamespace = variableNamespace_;
        this._variableVersion = variableVersion_;
        ObjectsEnumerator enumerator = OpenAPI3.enumerateObjects();
        this._managedObjects = enumerator.getManagedObjects();
        this._dataObjects = enumerator.getDataObjects();
        this._enums = enumerator.getEnums();
        this.preprocessManagedObjects();
        this.setIndentSpaces("  ");
    }

    void preprocessManagedObjects() {
        switch (this._opIdFlavor) {
            case WITH_HASH: {
                this.setOpIdHashes();
                break;
            }
            case OPTIMIZED: {
                this.setOnDemandOpIdHashes();
                break;
            }
        }
    }

    private void setOpIdHashes() {
        for (ManagedObject managedObject : this._managedObjects) {
            String opId;
            String hash = OpenAPI3.calcHash(managedObject);
            for (Method method : managedObject.getMethodList()) {
                opId = OpenAPI3.getNameHashCombo(method.getName(), hash);
                method.setCustomName(opId);
            }
            for (Property property : OpenAPI3.getReleasedProperties(managedObject)) {
                opId = OpenAPI3.getNameHashCombo(property.getName(), hash);
                ((ManagedProperty)property).setCustomName(opId);
            }
        }
    }

    private void setOnDemandOpIdHashes() {
        ArrayList<OperationId> opList = new ArrayList<OperationId>(this._managedObjects.length * 4);
        for (ManagedObject managedObject : this._managedObjects) {
            String hash = OpenAPI3.calcHash(managedObject);
            for (Method method : managedObject.getMethodList()) {
                opList.add(new OperationId(hash, method));
            }
            for (Property property : OpenAPI3.getReleasedProperties(managedObject)) {
                opList.add(new OperationId(hash, property));
            }
        }
        OperationId[] operations = opList.toArray(new OperationId[0]);
        Arrays.sort(operations, OperationId.getComparator());
        String lastName = null;
        int startIndex = 0;
        int size = operations.length;
        for (int i = 0; i < size; ++i) {
            String name = operations[i].getName();
            if (name.equals(lastName)) continue;
            if (i - startIndex > 1) {
                this.setOpIdHashes(operations, startIndex, i);
            }
            startIndex = i;
            lastName = name;
        }
        if (size - startIndex > 1) {
            this.setOpIdHashes(operations, startIndex, size);
        }
    }

    private void setOpIdHashes(OperationId[] operations, int index, int endIndex) {
        while (index < endIndex) {
            operations[index++].setName();
        }
    }

    @Override
    public void emitObjects(List<VmodlObject> objects) {
        this.beginFile(this._folderPrefix + _targetVersion.getNamespace() + ".yaml");
        this.emitHeader("vSphere " + _targetVersion.getNamespace().toUpperCase() + " APIs");
        this.emitLine("paths:", INDENT);
        for (ManagedObject managedObject : this._managedObjects) {
            this.emitMethods(managedObject);
            this.emitManagedPropertyGetters(managedObject);
        }
        this.unindent();
        this.emitLine("components:", INDENT);
        this.emitLine("schemas:", INDENT);
        this.emitCoreObjects();
        this.emitMethodParamsObjects();
        this.emitDataObjects();
        this.emitEnums();
        this.unindent();
        this.emitLine("parameters:", INDENT);
        this.emitMoIdParameter();
        if (this._variableNamespace) {
            this.emitNamespaceParameter();
        }
        if (this._variableVersion) {
            this.emitVersionParameter();
        }
        this.unindent();
        this.unindent();
        this.emitLine("externalDocs:", INDENT);
        this.emitLine("description: The online vSphere management API documentation");
        this.emitLine("url: https://code.vmware.com/apis/1131/vsphere");
        this.unindent();
        this.endFile();
    }

    private void emitHeader(String title) {
        this.emitLine("openapi: 3.0.0");
        this.emitLine("info:", INDENT);
        this.emitLine("title: ", OpenAPI3.qs(title));
        this.emitLine("version: ", _targetVersion.getWireId());
        this.unindent();
        this.emitGap();
        this.emitLine("servers:", INDENT);
        this.emitLine("- url: http://localhost/sdk");
        this.unindent();
        this.emitGap();
    }

    private void emitMethods(ManagedObject managedObject) {
        Method[] methods = OpenAPI3.getReleasedMethods(managedObject).toArray(METHOD_ARRAY);
        Arrays.sort(methods, NameComparator);
        String moType = OpenAPI3.getJsonName(managedObject);
        for (Method method : methods) {
            if (!OpenAPI3.shouldEmit(method)) continue;
            this.pushIndent();
            this.emitOperation(moType, method, this.getOpId(moType, method), "post");
            DataObject methodParams = this.registerMethodParams(managedObject, method);
            if (methodParams != null) {
                this.emitRequestBody(OpenAPI3.getJsonName(methodParams));
            }
            VmodlDecl result = method.isTask() ? Method.taskReturnDecl() : method.getReturnDecl();
            this.emitResponse(result, method.getFaultList());
            this.popIndent();
            this.emitGap();
        }
    }

    private void emitManagedPropertyGetters(ManagedObject managedObject) {
        Property[] properties = OpenAPI3.getReleasedProperties(managedObject).toArray(PROPERTY_ARRAY);
        Arrays.sort(properties, NameComparator);
        String moType = OpenAPI3.getJsonName(managedObject);
        for (Property property : properties) {
            if (!OpenAPI3.shouldEmit(property)) continue;
            this.pushIndent();
            this.emitOperation(moType, property, this.getOpId(moType, property), "get");
            this.emitResponse(property.getDecl(), NO_FAULTS);
            this.popIndent();
            this.emitGap();
        }
    }

    private void emitOperation(String moTypeId, VmodlApi vmodlApi, String opId, String httpMethod) {
        this.emitOperationSchema();
        this.emitLine("/", moTypeId, "/{", "moId", "}/", vmodlApi.getName(), ":");
        this.emitLine(INDENT, httpMethod, ":");
        this.emitLine(INDENT, "tags: [", moTypeId, "]");
        this.emitLine("operationId: ", opId);
        this.emitComment(vmodlApi.getComment());
        this.emitLine("parameters:", INDENT);
        this.emitLine("- $ref: '#/components/parameters/", "moId", "'");
        this.emitOperationSchemaParams();
        this.unindent();
    }

    private void emitOperationSchema() {
        if (this._variableNamespace) {
            this.emitPartial("/{", "urlNamespace", "}");
        } else {
            this.emitPartial("/", _targetVersion.getNamespace());
        }
        if (this._variableVersion) {
            this.emitPartial("/{", "urlVersion", "}");
        } else {
            this.emitPartial("/", _targetVersion.getWireId());
        }
    }

    private void emitOperationSchemaParams() {
        if (this._variableNamespace) {
            this.emitLine("- $ref: '#/components/parameters/", "urlNamespace", "'");
        }
        if (this._variableVersion) {
            this.emitLine("- $ref: '#/components/parameters/", "urlVersion", "'");
        }
    }

    private String getOpId(String moType, Method method) {
        switch (this._opIdFlavor) {
            case WITH_HASH: {
                return method.getCustomName();
            }
            case OPTIMIZED: {
                String customName = method.getCustomName();
                return customName != null ? customName : method.getName();
            }
        }
        return moType + "." + method.getName();
    }

    private String getOpId(String moType, Property property) {
        ManagedProperty managedProperty = (ManagedProperty)property;
        switch (this._opIdFlavor) {
            case WITH_HASH: {
                return this.getterName(managedProperty.getCustomName());
            }
            case OPTIMIZED: {
                String customName = managedProperty.getCustomName();
                return this.getterName(customName != null ? customName : managedProperty.getName());
            }
        }
        return moType + "." + this.getterName(managedProperty.getName());
    }

    private String getterName(String name) {
        return "get" + OpenAPI3.capitalize(name);
    }

    private void emitRequestBody(String schemaId) {
        this.pushIndent();
        this.emitLine("requestBody:", INDENT);
        this.emitLine("required: true");
        this.emitContentTags();
        this.emitRef(schemaId);
        this.popIndent();
    }

    private void emitResponse(VmodlDecl result, List<DataObject> faults) {
        this.emitLine("responses:", INDENT);
        this.pushIndent();
        if (result.getTypeId() == VmodlDecl.TypeId.VOID) {
            this.emitLine("'204':", INDENT);
            this.emitOpenAPI_description("No Content");
        } else {
            this.emitLine("'200':", INDENT);
            this.emitOpenAPI_description("OK");
            this.emitContentTags();
            if (result.isOptional()) {
                this.emitLine("nullable: true");
                this.emitLine("allOf:", INDENT);
                this.emitPartial("- ");
                this.indent();
            }
            this.emitDecl(result);
        }
        this.popIndent();
        if (faults.size() > 0) {
            this.emitLine("'500':", INDENT);
            this.emitOpenAPI_description("Failure");
            this.emitContentTags();
            this.emitRef(this.getCommonAncestor(faults));
        }
    }

    VmodlObject getCommonAncestor(List<DataObject> faults) {
        VmodlObject firstFault = faults.get(0);
        if (faults.size() == 1) {
            return firstFault;
        }
        ArrayList<VmodlObject> faultsList = this.getParentsList(firstFault);
        int index = 0;
        block0: for (DataObject fault : faults) {
            ArrayList<VmodlObject> parentsList = this.getParentsList(fault);
            int faultsIndex = faultsList.size();
            int parentsIndex = parentsList.size();
            while (faultsIndex > index && parentsIndex > 0) {
                if (faultsList.get(--faultsIndex) == parentsList.get(--parentsIndex)) continue;
                index = faultsIndex + 1;
                continue block0;
            }
        }
        return faultsList.get(index);
    }

    ArrayList<VmodlObject> getParentsList(VmodlObject fault) {
        ArrayList<VmodlObject> result = new ArrayList<VmodlObject>();
        do {
            result.add(fault);
        } while ((fault = fault.getBaseObject()) != null);
        return result;
    }

    private void emitContentTags() {
        this.emitLine("content:", INDENT);
        this.emitLine(APPLICATION_JSON, INDENT);
        this.emitLine("schema:", INDENT);
    }

    private void emitCoreObjects() {
        this.emitAnySchema();
        this.emitMoRefSchema();
        for (JoapEmitter.Primitive primitive : PRIMITIVES) {
            this.emitBoxedPrimitive(primitive);
        }
    }

    private void emitAnySchema() {
        this.emitSchemaObject(this._Any);
        this.pushIndent();
        this.emitLine(INDENT, "discriminator:");
        this.emitLine(INDENT, "propertyName: ", "className");
        this.popIndent();
    }

    private void emitMoRefSchema() {
        this.emitSchemaObject(this._MoRef);
        this.emitEnumSchema(this._moTypesList.fillEnum(this._managedObjects));
    }

    private void emitBoxedPrimitive(JoapEmitter.Primitive primitive) {
        JoapEmitter.BoxedPair boxedPair = this.createBoxedPrimitive(primitive);
        this.emitSchemaObject(boxedPair._boxedObject);
        this.emitSchemaObject(boxedPair._boxedArray);
    }

    private void emitMethodParamsObjects() {
        DataObject[] methodParamsList = this._methodParams.toArray(DATA_OBJECT_ARRAY);
        Arrays.sort(methodParamsList, VmodlObjectComparator);
        for (DataObject methodParams : methodParamsList) {
            this.emitSchemaObject(methodParams);
        }
    }

    private void emitDataObjects() {
        for (DataObject dataObject : this._dataObjects) {
            if (!OpenAPI3.shouldEmit(dataObject)) continue;
            this.emitSchemaObject(dataObject);
            this.emitSchemaObject(this.createBoxedArray(dataObject));
        }
    }

    private void emitEnums() {
        for (Enum enum_ : this._enums) {
            if (!OpenAPI3.shouldEmit(enum_)) continue;
            this.emitEnumSchema(enum_);
            JoapEmitter.BoxedPair boxedPair = this.createBoxedEnum(enum_);
            this.emitSchemaObject(boxedPair._boxedObject);
            this.emitSchemaObject(boxedPair._boxedArray);
        }
    }

    private void emitEnumSchema(Enum enum_) {
        this.pushIndent();
        this.emitSchemaEntry(OpenAPI3.getJsonName(enum_));
        this.emitLine("type: string");
        this.emitLine("enum:", INDENT);
        for (String value : enum_.getValueList()) {
            this.emitLine("- ", value);
        }
        this.emitGap();
        this.popIndent();
    }

    private void emitSchemaObject(DataObject object) {
        this.pushIndent();
        this.emitSchemaEntry(OpenAPI3.getJsonName(object));
        this.emitOpenAPI_object(object);
        this.emitGap();
        this.popIndent();
    }

    private void emitSchemaEntry(String id) {
        this.emitLine(id, ":");
        this.indent();
    }

    private void emitDashRef(VmodlObject object) {
        this.emitPartial("- ");
        this.emitRef(object);
    }

    private void emitRef(VmodlObject object) {
        this.emitRef(OpenAPI3.getJsonName(object));
    }

    private void emitRef(String typeName) {
        this.emitPartial("$ref: ");
        this.emitSchemaRef(typeName);
    }

    private void emitSchemaRef(String schemaId) {
        this.emitLine("'#/components/schemas/", schemaId, "'");
    }

    private void emitDecl(VmodlDecl decl) {
        if (decl.isArray()) {
            this.emitLine("type: array");
            this.emitLine("items:", INDENT);
        }
        switch (decl.getTypeId()) {
            case BOOLEAN: {
                this.emitOpenAPI_type("boolean");
                break;
            }
            case BYTE: {
                this.emitOpenAPI_int(BYTE_MIN, BYTE_MAX);
                break;
            }
            case SHORT: {
                this.emitOpenAPI_int(SHORT_MIN, SHORT_MAX);
                break;
            }
            case INT: {
                this.emitOpenAPI_type("integer", "int32");
                break;
            }
            case LONG: {
                this.emitOpenAPI_type("integer", "int64");
                break;
            }
            case FLOAT: {
                this.emitOpenAPI_type("number", "float");
                break;
            }
            case DOUBLE: {
                this.emitOpenAPI_type("number", "double");
                break;
            }
            case BINARY: {
                this.emitOpenAPI_type("string", "byte");
                break;
            }
            case DATETIME: {
                this.emitOpenAPI_type("string", "date-time");
                break;
            }
            case URI: 
            case METHODNAME: 
            case PROPPATH: 
            case TYPENAME: {
                this.emitOpenAPI_type("string");
                return;
            }
            case STRING: {
                if (decl.isSecret()) {
                    this.emitOpenAPI_type("string", "password");
                    break;
                }
                this.emitOpenAPI_type("string");
                break;
            }
            case ANY: {
                this.emitRef("Any");
                break;
            }
            case MANAGED: {
                this.emitRef("MoRef");
                break;
            }
            case ENUM: 
            case DATA: {
                this.emitRef(decl.getObject());
                break;
            }
            default: {
                throw new RuntimeException("Unexpected object type: " + (Object)((Object)decl.getTypeId()));
            }
        }
    }

    private void emitOpenAPI_type(String type) {
        this.emitLine("type: ", type);
    }

    private void emitOpenAPI_type(String type, String format) {
        this.emitOpenAPI_type(type);
        this.emitLine("format: ", format);
    }

    private void emitOpenAPI_int(String min, String max) {
        this.emitOpenAPI_type("integer");
        this.emitLine("minimum: ", min);
        this.emitLine("maximum: ", max);
    }

    private void emitOpenAPI_object(VmodlObject object) {
        VmodlObject base = object.getBaseObject();
        if (base != null) {
            this.emitLine("allOf:", INDENT);
            this.emitDashRef(base);
            this.emitPartial("- ");
            this.indent();
        }
        this.emitLine("type: object");
        this.emitComment(object.getComment());
        List<Property> properties = object.getPropertyListWithOverrides();
        boolean isEmpty = true;
        for (Property property : properties) {
            if (!OpenAPI3.shouldEmit(property)) continue;
            isEmpty = false;
            break;
        }
        if (isEmpty) {
            return;
        }
        ArrayList<String> requiredFields = new ArrayList<String>();
        this.emitLine("properties:", INDENT);
        for (Property property : properties) {
            if (!OpenAPI3.shouldEmit(property)) continue;
            VmodlDecl decl = property.getDecl();
            String name = property.getName();
            if (!decl.isOptional()) {
                requiredFields.add(name);
            }
            this.pushIndent();
            this.emitLine(name, ":");
            this.indent();
            this.emitComment(property.getComment());
            this.emitDecl(decl);
            this.popIndent();
        }
        this.unindent();
        if (!requiredFields.isEmpty()) {
            this.emitLine("required:", INDENT);
            for (String name : requiredFields) {
                this.emitLine("- ", name);
            }
            this.unindent();
        }
    }

    private void emitOpenAPI_description(String description) {
        this.emitLine("description: \"", description, "\"");
    }

    private void emitMoIdParameter() {
        this.pushIndent();
        this.emitLine("moId", ":");
        this.emitLine(INDENT, "name: ", "moId");
        this.emitLine("in: path");
        this.emitLine("required: true");
        this.emitLine("schema:", INDENT);
        this.emitLine("type: string");
        this.emitGap();
        this.popIndent();
    }

    private void emitNamespaceParameter() {
        this.pushIndent();
        this.emitLine("urlNamespace", ":");
        this.emitLine(INDENT, "name: ", "urlNamespace");
        this.emitLine("in: path");
        this.emitLine("required: true");
        this.emitLine("schema:", INDENT);
        this.emitLine("type: string");
        this.emitGap();
        this.popIndent();
    }

    private void emitVersionParameter() {
        this.pushIndent();
        this.emitLine("urlVersion", ":");
        this.emitLine(INDENT, "name: ", "urlVersion");
        this.emitLine("in: path");
        this.emitLine("required: true");
        this.emitLine("schema:", INDENT);
        this.emitLine("type: string");
        this.emitGap();
        this.popIndent();
    }

    private void emitComment(String comment) {
        char c;
        if (comment == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        int dotPos = comment.indexOf(46);
        if (dotPos != -1) {
            sb.append(comment.substring(0, dotPos + 1));
        } else {
            sb.append(comment);
        }
        if (sb.indexOf("@") != -1) {
            return;
        }
        while (sb.length() > 0 && ((c = sb.charAt(0)) == ' ' || c == '\n')) {
            sb.deleteCharAt(0);
        }
        while (sb.length() > 0 && ((c = sb.charAt(sb.length() - 1)) == ' ' || c == '\n')) {
            sb.deleteCharAt(0);
        }
        boolean isWhiteSpace = false;
        for (int i = sb.length() - 1; i >= 0; --i) {
            c = sb.charAt(i);
            if (c == '\"' || c == '\\') {
                sb.insert(i, '\\');
            }
            if (isWhiteSpace) {
                if (c == ' ' || c == '\n') {
                    sb.deleteCharAt(i);
                    continue;
                }
                isWhiteSpace = false;
                continue;
            }
            if (c == ' ') {
                isWhiteSpace = true;
                continue;
            }
            if (c != '\n') continue;
            sb.setCharAt(i, ' ');
            isWhiteSpace = true;
        }
        if (sb.length() == 0) {
            return;
        }
        this.emitOpenAPI_description(sb.toString());
    }

    @Override
    protected String getLink(VmodlObject object) {
        return OpenAPI3.getJsonName(object);
    }

    private static ObjectsEnumerator enumerateObjects() {
        class EnumeratorFilter
        implements ObjectsEnumerator.Filter {
            EnumeratorFilter() {
            }

            @Override
            public boolean shouldEmit(VmodlObject object) {
                return JoapEmitter.shouldEmit(object) && !JoapEmitter.CORE_OBJECTS.contains(object);
            }
        }
        return new ObjectsEnumerator(ObjectRegistry.getAllObjects(), new EnumeratorFilter());
    }

    private static String calcHash(ManagedObject managedObject) {
        MessageDigest digest = Versions.initDigest();
        digest.update(VmodlDecl.toBytes(OpenAPI3.getJsonName(managedObject)));
        byte[] result = digest.digest();
        return String.format("%02x%02x", result[0], result[1]);
    }

    static String getNameHashCombo(String name, String hash) {
        return name + "_" + hash;
    }

    protected static List<Method> getReleasedMethods(ManagedObject managedObject) {
        List<Method> allMethods = managedObject.getMethodList();
        ArrayList<Method> methods = new ArrayList<Method>(allMethods.size());
        for (Method method : allMethods) {
            if (!OpenAPI3.shouldEmit(method)) continue;
            methods.add(method);
        }
        return methods;
    }

    protected static List<Property> getReleasedProperties(ManagedObject object) {
        List<Property> allProperties = object.getPropertyListWithOverrides();
        ArrayList<Property> properties = new ArrayList<Property>(allProperties.size());
        for (Property property : allProperties) {
            if (!OpenAPI3.shouldEmit(property)) continue;
            properties.add(property);
        }
        return properties;
    }

    static enum OP_ID_FLAVOR {
        DEFAULT,
        WITH_HASH,
        OPTIMIZED;

    }
}

