/*
 * Decompiled with CFR 0.152.
 */
package emitters.generators.xml;

import emitters.ObjectRegistry;
import emitters.VmodlEmitter;
import emitters.model.VmodlObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class EventExtensionEmitter
extends VmodlEmitter {
    private static final String EVENTS_FILE_NAME = "events.xml";
    private static final String EVENT_NS_OPTIONS = "namespace";
    private static final String EVENT_FILE_NAME_OPTION = "file";
    private static final String EMITTED_EVENT_START = "<event id=\"";
    private static final String EMITTED_EVENT_END = "\" />";
    private String _eventNS;
    private String _outputFileName = "events.xml";
    private final VmodlObject _eventBase;
    private final Set<String> _events = new TreeSet<String>();

    public EventExtensionEmitter(Map<String, String> options, String eventBase) {
        this._eventBase = ObjectRegistry.getObject(eventBase);
        if (this._eventBase == null) {
            throw new RuntimeException("Event base class \"" + eventBase + "\" is not defined");
        }
        for (Map.Entry<String, String> entry : options.entrySet()) {
            String optionName = entry.getKey();
            String optionValue = entry.getValue();
            if (optionName.equals(EVENT_NS_OPTIONS)) {
                this._eventNS = optionValue;
                continue;
            }
            if (!optionName.equals(EVENT_FILE_NAME_OPTION)) continue;
            this._outputFileName = optionValue;
        }
        if (this._eventNS == null) {
            throw new RuntimeException("Event Namespace options must be specified");
        }
    }

    private boolean isEvent(VmodlObject obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this._eventBase) {
            return true;
        }
        return this.isEvent(obj.getBaseObject());
    }

    private void gatherEventObjects(Iterable<VmodlObject> objects) {
        for (VmodlObject obj : objects) {
            if (this.isEvent(obj)) {
                this._events.add(obj.getName());
            }
            this.gatherEventObjects(obj.getNestedList());
        }
    }

    private void emitHeader() {
        this.emitLine("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.emitLine("<events>");
        this.indent();
        this.emitLine("<!-- AUTOMATICALLY GENERATED CODE - DO NOT EDIT -->");
    }

    private void emitEvents() {
        for (String eventId : this._events) {
            this.emitLine(EMITTED_EVENT_START, this._eventNS, eventId, EMITTED_EVENT_END);
        }
    }

    private void emitFooter() {
        this.unindent();
        this.emitLine("</events>");
    }

    @Override
    public void emitObjects(List<VmodlObject> objects) {
        this._events.clear();
        this.gatherEventObjects(objects);
        this.beginFile(this._outputFileName);
        this.emitHeader();
        this.emitEvents();
        this.emitFooter();
        this.endFile();
    }
}

