/*
 * Decompiled with CFR 0.152.
 */
package emitters.javac;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.LineMap;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import emitters.model.SourcePos;
import emitters.model.VmodlObject;
import java.io.File;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

public class Platform
extends emitters.backend.Platform {
    static ProcessingEnvironment _env;
    static Types _typeUtils;
    static Elements _elementUtils;
    static Messager _messager;
    static Trees _trees;
    static Set<TypeElement> _typeElements;
    static RoundEnvironment _roundEnv;
    static boolean _isWindows;

    static void init(ProcessingEnvironment env) {
        emitters.backend.Platform.init(new Platform());
        _env = env;
        _elementUtils = env.getElementUtils();
        _typeUtils = env.getTypeUtils();
        _trees = Trees.instance(env);
        _messager = env.getMessager();
        if (System.getProperty("os.name").startsWith("Windows")) {
            _isWindows = true;
        }
        Platform.setupStandardLocationPrefix(env.getFiler());
    }

    private static void setupStandardLocationPrefix(Filer filer) {
        FileObject fObj;
        try {
            fObj = filer.createResource(StandardLocation.SOURCE_OUTPUT, "", ManagementFactory.getRuntimeMXBean().getName(), new Element[0]);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.toString());
        }
        String fileName = fObj.getName();
        fObj.delete();
        int pastLastSlash = fileName.lastIndexOf(File.separator) + 1;
        _outputPathPrefix = fileName.substring(0, pastLastSlash);
    }

    private static void flattenTypeElements(Collection<? extends Element> els) {
        for (Element element : els) {
            if (element instanceof TypeElement) {
                _typeElements.add((TypeElement)element);
            }
            if (element.getKind().equals((Object)ElementKind.ANNOTATION_TYPE)) continue;
            Platform.flattenTypeElements(element.getEnclosedElements());
        }
    }

    public static void setupRound(RoundEnvironment roundEnv) {
        _typeElements = new HashSet<TypeElement>();
        _roundEnv = roundEnv;
        Platform.flattenTypeElements(roundEnv.getRootElements());
    }

    static RoundEnvironment getRoundEnv() {
        return _roundEnv;
    }

    public static Types getTypeUtils() {
        return _typeUtils;
    }

    public static Elements getElementUtils() {
        return _elementUtils;
    }

    static Collection<TypeElement> getRootElements() {
        return _typeElements;
    }

    private static TypeElement getTypeElement(String name) {
        return _elementUtils.getTypeElement(name);
    }

    public static PackageElement getPackage(String name) {
        return _elementUtils.getPackageElement(name);
    }

    public static Map<String, String> getOptions() {
        return _env.getOptions();
    }

    @Override
    protected Map<String, String> getOptionsImpl() {
        return _env.getOptions();
    }

    @Override
    protected void printErrorImpl(String msg) {
        _messager.printMessage(Diagnostic.Kind.ERROR, msg);
    }

    @Override
    protected void printWarningImpl(String msg) {
        _messager.printMessage(Diagnostic.Kind.WARNING, msg);
    }

    @Override
    protected PrintWriter createTextFileImpl(File file) {
        String msg;
        int retries;
        File parent;
        File fObj;
        String path = _outputPathPrefix + file.getPath();
        try {
            fObj = new File(path);
            parent = fObj.getParentFile();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        for (retries = 0; retries < 10; ++retries) {
            try {
                parent.mkdirs();
                break;
            }
            catch (Exception e) {
                msg = e.getMessage();
                if (msg != null) {
                    throw new RuntimeException(msg);
                }
                try {
                    Thread.sleep(2000 + (int)(Math.random() % 2000.0));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                continue;
            }
        }
        if (retries == 5) {
            throw new RuntimeException("Could not create parent directories");
        }
        for (retries = 0; retries < 5; ++retries) {
            try {
                return new PrintWriter(fObj);
            }
            catch (Exception e) {
                msg = e.getMessage();
                if (msg != null) {
                    throw new RuntimeException(msg);
                }
                try {
                    Thread.sleep(2000 + (int)(Math.random() % 1000.0));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                continue;
            }
        }
        throw new RuntimeException("Could not create file");
    }

    static SourcePos fillSourcePos(Element el) {
        long posStart;
        SourcePositions sourcePositions = _trees.getSourcePositions();
        TreePath treePath = _trees.getPath(el);
        if (treePath == null) {
            return new SourcePos();
        }
        CompilationUnitTree compUnitTree = treePath.getCompilationUnit();
        Tree tree = treePath.getLeaf();
        long column = posStart = sourcePositions.getStartPosition(compUnitTree, tree);
        long line = posStart;
        LineMap lineMap = compUnitTree.getLineMap();
        if (lineMap != null) {
            column = lineMap.getColumnNumber(posStart);
            line = lineMap.getLineNumber(posStart);
        }
        String absoluteName = compUnitTree.getSourceFile().getName();
        return new SourcePos(absoluteName, absoluteName, (int)line, (int)column);
    }

    static SourcePos getSourcePos(Element el) {
        return Platform.fillSourcePos(el);
    }

    @Override
    protected SourcePos getSourcePosImpl(String fullName) {
        TypeElement el = Platform.getTypeElement(fullName);
        return Platform.fillSourcePos(el);
    }

    @Override
    protected SourcePos getSourcePosImpl(VmodlObject obj) {
        TypeElement el = Platform.getTypeElement(obj.getQualifiedVmodlType());
        return Platform.fillSourcePos(el);
    }

    @Override
    protected SourcePos getSourcePosImpl(VmodlObject obj, String simpleName) {
        TypeElement el = Platform.getTypeElement(obj.getQualifiedVmodlType());
        for (Element element : el.getEnclosedElements()) {
            if (!element.getSimpleName().toString().equals(simpleName)) continue;
            return Platform.fillSourcePos(element);
        }
        throw new RuntimeException(String.format("Invalid method or property \"%s\" specified for object %s", simpleName, obj.getQualifiedVmodlType()));
    }
}

