/*
 * Decompiled with CFR 0.152.
 */
package emitters.javac;

import emitters.Utils;
import emitters.javac.Platform;
import emitters.javac.Tools;
import emitters.model.Version;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import vmodl.internal;
import vmodl.sessionSpecific;
import vmodl.undocumented;

public class RawObject
extends emitters.model.raw.RawObject {
    private final TypeElement _typeElement;

    public RawObject() {
        this(null);
    }

    public RawObject(TypeElement typeElement) {
        this._typeElement = typeElement;
    }

    @Override
    public String getName() {
        return this._typeElement.getSimpleName().toString();
    }

    @Override
    public String getPackage() {
        Element el = this._typeElement;
        while (el.getEnclosingElement() != null && el.getKind() != ElementKind.PACKAGE) {
            el = el.getEnclosingElement();
        }
        PackageElement pkg = (PackageElement)el;
        return pkg.getQualifiedName().toString();
    }

    @Override
    public String getWsdlName() {
        return Tools.schemaTypeName(this._typeElement);
    }

    @Override
    public String getComment() {
        return Platform.getElementUtils().getDocComment(this._typeElement);
    }

    @Override
    public boolean isDeprecated() {
        return this._typeElement.getAnnotation(Deprecated.class) != null;
    }

    @Override
    public boolean isUndocumented() {
        return this._typeElement.getAnnotation(undocumented.class) != null;
    }

    @Override
    public boolean isInternal() {
        return this._typeElement.getAnnotation(internal.class) != null;
    }

    @Override
    public Version internalBefore() {
        return Tools.getInternalBefore(this._typeElement);
    }

    @Override
    public boolean isFault() {
        if (!this._typeElement.getKind().equals((Object)ElementKind.CLASS)) {
            return false;
        }
        TypeElement it = this._typeElement;
        while (it != null) {
            Name name = it.getQualifiedName();
            String className = name.toString();
            if (className.equals(Utils.MethodFaultClassName) || className.equals(Utils.RuntimeFaultClassName)) {
                return true;
            }
            if (it.getSuperclass() == null) {
                return false;
            }
            it = (TypeElement)Platform.getTypeUtils().asElement(it.getSuperclass());
        }
        return false;
    }

    @Override
    public boolean isSessionSpecific() {
        return this._typeElement.getAnnotation(sessionSpecific.class) != null;
    }

    @Override
    public String getQualifiedName() {
        return this._typeElement.getQualifiedName().toString();
    }
}

