/*
 * Decompiled with CFR 0.152.
 */
package emitters.model;

import emitters.Utils;
import emitters.model.Method;
import emitters.model.Parameter;
import emitters.model.Property;
import emitters.model.Version;
import emitters.model.VmodlDecl;
import emitters.model.VmodlObject;

public class DataProperty
extends Property {
    private final int _propertyIndex;

    public DataProperty(VmodlObject container, String name, String wsdlName2, VmodlDecl decl, boolean readonly2, String privId, Version version, String comment, int propertyIndex) {
        super(container, name, wsdlName2, decl, readonly2, privId, version, comment);
        this._propertyIndex = propertyIndex;
    }

    DataProperty(DataProperty dprop, Version version) {
        super(dprop, version);
        this._propertyIndex = -1;
    }

    @Override
    public Method getAccessor() {
        String accessorName = this.getAccessorPrefix() + Utils.capitalize(this._name);
        return new Method(this._container, accessorName, this._decl, this._version, this._comment);
    }

    @Override
    public Method getMutator() {
        String mutatorName = this.getMutatorPrefix() + Utils.capitalize(this._name);
        Method method = new Method(this._container, mutatorName, VmodlDecl.voidType, this._version, this._comment);
        method.addParameter(new Parameter("val", this._decl, this._version, this._comment));
        return method;
    }

    @Override
    public Method getUnsetter() {
        String unsetterName = this.getUnsetterPrefix() + Utils.capitalize(this._name);
        return new Method(this._container, unsetterName, VmodlDecl.voidType, this._version, this._comment);
    }

    @Override
    public Method getPeeker() {
        String peekerName = this.getPeekerPrefix() + Utils.capitalize(this._name);
        return new Method(this._container, peekerName, this._decl, this._version, this._comment);
    }

    @Override
    public Method getSwapper() {
        String swapperName = this.getSwapperPrefix() + Utils.capitalize(this._name);
        Method method = new Method(this._container, swapperName, VmodlDecl.voidType, this._version, this._comment);
        method.addParameter(new Parameter("val", this._decl, this._version, this._comment));
        return method;
    }

    @Override
    public String getAccessorPrefix() {
        return this._decl.isBoolean() ? "Is" : "Get";
    }

    @Override
    public String getMutatorPrefix() {
        return "Set";
    }

    @Override
    public String getUnsetterPrefix() {
        if (this._decl.isOptional() && this._decl.isSingleValue()) {
            return "Unset";
        }
        throw new RuntimeException("Unset used for non-optional value type");
    }

    @Override
    public String getPeekerPrefix() {
        return "Peek";
    }

    @Override
    public String getSwapperPrefix() {
        return "Swap";
    }

    public Method getIsSet() {
        String isSetName = this.getIsSetPrefix() + Utils.capitalize(this._name);
        return new Method(this._container, isSetName, this._decl, this._version, this._comment);
    }

    private String getIsSetPrefix() {
        if (!this._decl.isArray()) {
            throw new RuntimeException("IsSet accessor applies only to arrays");
        }
        return "IsSet";
    }

    public Method getGetPtr() {
        String getPtrName = this.getGetPtrPrefix() + Utils.capitalize(this._name);
        return new Method(this._container, getPtrName, this._decl, this._version, this._comment);
    }

    private String getGetPtrPrefix() {
        return "GetPtr";
    }

    public int getPropIndex() {
        if (this._propertyIndex < 0) {
            throw new RuntimeException("The property index has not been set");
        }
        return this._propertyIndex;
    }

    @Override
    public boolean isInternal() {
        return false;
    }

    @Override
    public Version getInternalBefore() {
        return null;
    }
}

