/*
 * Decompiled with CFR 0.152.
 */
package emitters.model;

import emitters.Versions;
import emitters.model.Field;
import emitters.model.Method;
import emitters.model.SourcePos;
import emitters.model.Version;
import emitters.model.VmodlApi;
import emitters.model.VmodlDecl;
import emitters.model.VmodlObject;
import java.security.MessageDigest;

public abstract class Property
extends Field
implements VmodlApi {
    protected final VmodlObject _container;
    protected final boolean _readonly;
    protected final String _wsdlName;
    private SourcePos _sourcePos;

    Property(VmodlObject container, String name, String wsdlName2, VmodlDecl decl, boolean readonly2, String privId, Version version, String comment) {
        super(name, decl, privId, version, comment);
        this._container = container;
        this._readonly = readonly2;
        this._wsdlName = wsdlName2;
    }

    Property(Property prop, Version version) {
        super(prop._name, prop._decl, prop._privId, version, prop._comment);
        this._container = prop._container;
        this._readonly = prop._readonly;
        this._wsdlName = prop._wsdlName;
    }

    @Override
    public void setSourcePos(SourcePos sourcePos) {
        this._sourcePos = sourcePos;
    }

    public boolean isReadonly() {
        return this._readonly;
    }

    public VmodlObject getContainer() {
        return this._container;
    }

    @Override
    public String getWsdlName() {
        return this._wsdlName;
    }

    @Override
    public SourcePos getSourcePos() {
        return this._sourcePos;
    }

    @Override
    public boolean isUndocumented() {
        return this._decl.isUndocumented();
    }

    @Override
    void updateDigest(MessageDigest digest) {
        if (Versions.skipDigesting(this._version)) {
            return;
        }
        Versions.logDigesting("Property %s", this._wsdlName);
        digest.update(VmodlDecl.toBytes(this._wsdlName));
        Versions.digestLoggerIncreaseNesting();
        super.updateDigest(digest);
        Versions.digestLoggerDecreaseNesting();
    }

    @Override
    void print(String indent) {
        super.print(indent);
        System.out.print(", Container: " + this._container.getQualifiedVmodlType());
        System.out.print(", WSDL name: " + (this._wsdlName != null ? this._wsdlName : "None"));
        System.out.print(", " + (this._readonly ? "read-only" : "r/w"));
    }

    public abstract Method getAccessor();

    public abstract Method getMutator();

    public abstract Method getUnsetter();

    public abstract Method getPeeker();

    public abstract Method getSwapper();

    public abstract String getAccessorPrefix();

    public abstract String getMutatorPrefix();

    public abstract String getUnsetterPrefix();

    public abstract String getPeekerPrefix();

    public abstract String getSwapperPrefix();
}

