/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.http;

import com.vmware.dr.ui.tools.reactive.impl.PromiseImpl;
import com.vmware.dr.ui.tools.reactive.impl.utils.Exceptions;
import com.vmware.srm.client.infrastructure.requestHandlers.protocol.DrClientProtocolException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import org.apache.commons.lang.Validate;

public class ReadListenerPromise
extends PromiseImpl<byte[]>
implements ReadListener {
    static final int BUFFER_SIZE = 1024;
    private final int _maxRequestSize;
    private final ServletInputStream _input;
    private final ByteArrayOutputStream _inputBuffer;
    private volatile int _bytesRead = 0;

    public ReadListenerPromise(ServletInputStream input, int maxRequestSizeBytes) {
        Validate.isTrue((maxRequestSizeBytes > 0 ? 1 : 0) != 0);
        this._maxRequestSize = maxRequestSizeBytes;
        this._input = input;
        this._inputBuffer = new ByteArrayOutputStream(1024);
    }

    public void onDataAvailable() throws IOException {
        byte[] buffer = new byte[1024];
        while (this._input.isReady()) {
            int len = this._input.read(buffer);
            if (len == -1) {
                this.setResult(this._inputBuffer.toByteArray());
                return;
            }
            this._bytesRead += len;
            if (this._bytesRead > this._maxRequestSize) {
                throw new DrClientProtocolException("Max request size exceeded.");
            }
            this._inputBuffer.write(buffer, 0, len);
        }
    }

    public void onAllDataRead() throws IOException {
        this.setResult(this._inputBuffer.toByteArray());
    }

    public void onError(Throwable t) {
        this.setError(Exceptions.wrap((Throwable)t));
    }
}

