/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.websso;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.Publisher;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.dr.ui.tools.reactive.impl.Streams;
import com.vmware.dr.ui.tools.utilities.Exceptions;
import com.vmware.identity.websso.client.IDPConfiguration;
import com.vmware.identity.websso.client.MetadataSettings;
import com.vmware.identity.websso.client.MetadataSettingsImpl;
import com.vmware.identity.websso.client.SPConfiguration;
import com.vmware.srm.client.infrastructure.websso.IDPConfigRetriever;
import com.vmware.srm.client.infrastructure.websso.LsppQuery;
import com.vmware.srm.client.infrastructure.websso.SPConfigFactory;
import com.vmware.srm.client.infrastructure.websso.SolutionUserTokenManager;
import com.vmware.srm.client.infrastructure.websso.SsoContextBuilder;
import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.srm.client.topology.impl.init.Config;
import com.vmware.srm.client.topology.impl.lspp.Types;
import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppService;
import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppServiceEndpoint;
import com.vmware.srm.client.topology.impl.sso.CertificateUtils;
import com.vmware.srm.client.topology.impl.sso.SolutionUserConfig;
import com.vmware.srm.client.topology.impl.sso.SsoServiceImpl;
import com.vmware.srm.client.topology.impl.sso.SsoUtils;
import com.vmware.srm.client.topology.impl.vmomi.TokenProvider;
import com.vmware.vim.binding.sso.admin.ConfigurationManagementService;
import com.vmware.vim.vmomi.core.Future;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class SsoContext {
    public static final String WEBSSO = "websso";
    public static final String WEBSSO_LOGIN_RESPONSE_PATH = "authentication/websso/webssologin";
    public static final String WEBSSO_LOGOUT_RESPONSE_PATH = "authentication/websso/webssologout";
    private final SolutionUserTokenManager _suTokenManager;
    private final IDPConfiguration _idpConfig;
    private final SPConfiguration _spConfig;
    private final LsppService _ssoReg;
    private final long _clockTolerance;
    private final X509Certificate[] _signingCerts;
    private final MetadataSettings _metadataSettings;

    private static SsoServiceImpl createVmomiService(LsppService ssoReg, int usersCount) {
        KeyStore store;
        LsppServiceEndpoint ep = SsoUtils.getAdminEndpoint((LsppService)ssoReg);
        try {
            store = CertificateUtils.createTrustStore((Collection)ep.getCertificates());
        }
        catch (IOException | GeneralSecurityException e) {
            throw Exceptions.getRuntimeException((Throwable)e);
        }
        final AtomicInteger usage = new AtomicInteger(usersCount);
        return new SsoServiceImpl(ep.url, null, store, null){

            public void dispose() {
                if (usage.decrementAndGet() == 0) {
                    super.dispose();
                }
            }
        };
    }

    private static SPConfiguration createSPConfig() {
        Config appConfig = Config.get();
        SolutionUserConfig suConfig = SolutionUserConfig.get();
        SPConfigFactory spFactory = new SPConfigFactory();
        try {
            return spFactory.create(appConfig.getAppUrl(), suConfig.getCert(), suConfig.getKey(), WEBSSO_LOGIN_RESPONSE_PATH, WEBSSO_LOGOUT_RESPONSE_PATH);
        }
        catch (URISyntaxException e) {
            throw Exceptions.getRuntimeException((Throwable)e);
        }
    }

    public static Promise<LsppService> getSsoReg() {
        Config config = Config.get();
        LsppQuery query = new LsppQuery(config.getLsppUrl(), config.getLsppThumbprint());
        Promise<Set<LsppService>> queryResult = query.query(Types.LsppType.Sso);
        queryResult.materialize().onSuccess(rp -> query.dispose());
        return queryResult.thenApply(set -> (LsppService)set.iterator().next());
    }

    private static Promise<SolutionUserTokenManager> createTokenManager(LsppService ssoReg) {
        SolutionUserConfig config = SolutionUserConfig.get();
        SolutionUserTokenManager tm = new SolutionUserTokenManager(config.getCert(), config.getKey());
        return Promises.from(() -> {
            tm.setSso(ssoReg);
            return tm;
        });
    }

    private static Promise<IDPConfiguration> getIDPConfig(LsppService ssoReg) {
        IDPConfigRetriever retriever = new IDPConfigRetriever(ssoReg);
        try {
            return retriever.retrieve();
        }
        catch (IOException | GeneralSecurityException e) {
            throw Exceptions.getRuntimeException((Throwable)e);
        }
    }

    private static Promise<Long> getClockTolerance(SsoServiceImpl service) {
        return service.getContent().thenCompose(content -> {
            ConfigurationManagementService cms = (ConfigurationManagementService)service.createStub(content.getConfigurationManagementService());
            FuturePromise result = new FuturePromise();
            cms.getClockTolerance((Future)result);
            result.materialize().onSuccess(unused -> service.dispose());
            return result;
        });
    }

    private static Promise<X509Certificate[]> getSigningCerts(SsoServiceImpl service) {
        return service.getContent().thenCompose(content -> {
            ConfigurationManagementService cms = (ConfigurationManagementService)service.createStub(content.getConfigurationManagementService());
            FuturePromise result = new FuturePromise();
            cms.getIssuersCertificates((Future)result);
            result.materialize().onSuccess(unused -> service.dispose());
            return result;
        }).thenApply(certs -> {
            try {
                return SsoUtils.generateRootCertificates((String[])certs);
            }
            catch (CertificateException e) {
                throw Exceptions.getRuntimeException((Throwable)e);
            }
        });
    }

    public static Promise<SsoContext> create() {
        return Streams.from((Publisher[])new Publisher[]{SsoContext.getSsoReg()}).flatMap(ssoReg -> {
            Promise ssoRegConsumer = Promises.resolve(builder -> builder.setSsoReg((LsppService)ssoReg));
            Promise<SolutionUserTokenManager> tmPromise = SsoContext.createTokenManager(ssoReg);
            Promise tmConsumer = tmPromise.thenApply(tm -> builder -> builder.setSuTokenManager((SolutionUserTokenManager)tm));
            Promise metaConsumer = SsoContext.getIDPConfig(ssoReg).thenApply(idp -> {
                MetadataSettingsImpl meta = new MetadataSettingsImpl();
                SPConfiguration sp = SsoContext.createSPConfig();
                meta.addIDPConfiguration(idp);
                meta.addSPConfiguration(sp);
                return builder -> builder.setMetadataSettings((MetadataSettings)meta).setIdpConfig((IDPConfiguration)idp).setSpConfig(sp);
            });
            Promise adminSsoConsumer = Promises.resolve((Object)SsoContext.createVmomiService(ssoReg, 2)).thenCompose(service -> SsoContext.getClockTolerance(service).thenCombine(SsoContext.getSigningCerts(service), (tolerance, certs) -> builder -> builder.setClockTolerance((long)tolerance).setSigningCerts((X509Certificate[])certs)));
            Promises.all((Promise[])new Promise[]{ssoRegConsumer, tmConsumer, metaConsumer, adminSsoConsumer}).onError(exc -> tmPromise.onSuccess(SolutionUserTokenManager::dispose));
            return Streams.from((Publisher[])new Publisher[]{ssoRegConsumer, tmConsumer, metaConsumer, adminSsoConsumer});
        }).reduce((Object)new SsoContextBuilder(), (builder, consumer) -> {
            consumer.accept(builder);
            return builder;
        }).thenApply(SsoContextBuilder::build);
    }

    SsoContext(SolutionUserTokenManager suTokenManager, IDPConfiguration idpConfig, SPConfiguration spConfig, LsppService ssoReg, long clockTolerance, X509Certificate[] signingCerts, MetadataSettings metadataSettings) {
        this._suTokenManager = suTokenManager;
        this._idpConfig = idpConfig;
        this._spConfig = spConfig;
        this._ssoReg = ssoReg;
        this._clockTolerance = clockTolerance;
        this._signingCerts = signingCerts;
        this._metadataSettings = metadataSettings;
    }

    public IDPConfiguration getIDPConfig() {
        return this._idpConfig;
    }

    public SPConfiguration getSpConfig() {
        return this._spConfig;
    }

    public LsppService getSsoRegistration() {
        return this._ssoReg;
    }

    public long getClockTolerance() {
        return this._clockTolerance;
    }

    public X509Certificate[] getSigningCerts() {
        return this._signingCerts;
    }

    public TokenProvider getSolutionUserTokenProvider() {
        return this._suTokenManager.getTokenProvider();
    }

    public MetadataSettings getMetadataSettings() {
        return this._metadataSettings;
    }
}

