/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.websso;

import com.vmware.identity.websso.client.endpoint.SharedComponent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.Validate;
import org.opensaml.core.config.InitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WebSsoWorkflow {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSsoWorkflow.class);

    public static URI addPath(URI base, String path) throws URISyntaxException {
        String basePath = base.getPath();
        path = ((String)path).startsWith("/") ? path : "/" + (String)path;
        String string = basePath = basePath != null && basePath.endsWith("/") ? basePath.substring(0, basePath.length() - 1) : basePath;
        if (basePath != null) {
            path = basePath + (String)path;
        }
        return new URI(base.getScheme(), null, base.getHost(), base.getPort(), (String)path, null, null);
    }

    public static String encodeBase64(String value) {
        Validate.notNull((Object)value, (String)"value");
        return Base64.getEncoder().encodeToString(value.getBytes(StandardCharsets.UTF_8));
    }

    public static String decodeBase64(String encoded) {
        Validate.notNull((Object)encoded, (String)"encoded");
        byte[] result = Base64.getDecoder().decode(encoded);
        return new String(result, StandardCharsets.UTF_8);
    }

    protected static void handleError(HttpServletResponse response, int statusCode, String errMsg) {
        LOGGER.error("WebSso operation failed: {}", (Object)errMsg);
        try {
            response.sendError(statusCode, StringEscapeUtils.escapeHtml((String)errMsg));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected static void handleError(HttpServletResponse response, Exception exc) {
        WebSsoWorkflow.handleError(response, 500, exc.getLocalizedMessage());
    }

    static {
        try {
            SharedComponent.bootstrap();
        }
        catch (InitializationException e) {
            throw new RuntimeException("Failed to bootstrap 'SharedComponent'.", e);
        }
    }
}

