#!/bin/sh -e
# You need to set 2 env variables: AXISHOME and JAVAHOME, or modify the 2
# values here

SAMPLEDIR=.

if [ "${AXISHOME}" == "" ] ; then
    echo "AXISHOME not defined.  Must be defined to run java apps.">&2
    exit 2
fi

if [ "${JAVAHOME}" == "" ] ; then
    echo "JAVAHOME not defined.  Must be defined to run java apps.">&2
    exit 2
fi

PATH="${JAVAHOME}/bin:${AXISHOME}/bin:${PATH}"
export PATH

# Cleanup mail jar files. dont need all of them.
LOCALCLASSPATH="${PWD}:${AXISHOME}/lib/axis-ant.jar:${AXISHOME}/lib/commons-logging-1.0.4.jar:${AXISHOME}/lib/saaj.jar:${AXISHOME}/lib/axis.jar:${AXISHOME}/lib/jaxrpc.jar:${AXISHOME}/lib/wsdl4j-1.5.1.jar:${AXISHOME}/lib/commons-discovery-0.2.jar:${AXISHOME}/lib/log4j-1.2.8.jar:${PWD}/srm.jar:${PWD}/apputils.jar:${PWD}/samples.jar"
LOCALCLASSPATH="${LOCALCLASSPATH}:${CLASSPATH}"

pushd ../..
"${JAVAHOME}/bin/java" -cp "${LOCALCLASSPATH}" -Xmx1024M $*

echo Done.
