/* ****************************************************************************
 * Copyright 2013-2014 VMware, Inc.  All rights reserved.
 * ***************************************************************************/

package com.vmware.samples.srm;

import java.net.URL;


/**
 * This class encapsulates configuration data (from the command-line) required
 * to run the sample application.
 */
public class Options {

   ////////////////////////////////////////////////////////////////////////////
   // Inner classes:
   ////////////////////////////////////////////////////////////////////////////

   /**
    * Thrown to indicate that the user has given invalid or unusable
    * command-line arguments.
    */
   public static class InvalidCliArgumentException
      extends java.lang.Exception {

      /**
       * Generated ID for object serialization.
       * @see java.io.Serializable
       */
      private static final long serialVersionUID = -7094364368235844645L;

      /**
       * Constructs an {@code InvalidCliArgumentException} with the specified
       * detail message.
       *
       * @param msg The detail message.
       */
      public InvalidCliArgumentException(final String msg) {
         super(msg);
      }

      /**
       * Constructs a new exception with the specified detail message and cause.
       * <p>
       * Note that the detail message associated with {@code cause} is
       * <em>not</em> automatically incorporated in this exception's detail
       * message.
       *
       * @param msg   The detail message (which is saved for later retrieval by
       *    the {@link Throwable#getMessage()} method.
       * @param cause The cause (which is saved for later retrieval by the
       *    {@link Throwable#getCause()} method).  (A {@code null} value is
       *    permitted, and indicates that the cause is nonexistent or unknown.)
       */
      public InvalidCliArgumentException(
         final String msg, final Throwable cause) {
         super(msg, cause);
      }
   }

   /**
    * Thrown to indicate that command-line processing has stopped, and a help
    * message should be displayed.
    */
   public static final class ShowHelpThrowable
      extends java.lang.Throwable {

      /**
       * Generated ID for object serialization.
       * @see java.io.Serializable
       */
      private static final long serialVersionUID = -8353364258918139617L;
   }

   ////////////////////////////////////////////////////////////////////////////
   // Public data:
   ////////////////////////////////////////////////////////////////////////////

   /** The user has requested to ignore SSL certificates in SRM connections. */
   public final boolean _ignoreCert;

   /** The URL used to contact the SRM API. */
   public final URL _url;

   /** SRM user name. */
   public final String _userName;

   /** SRM password for {@link #_userName}. */
   public final String _password;

   ////////////////////////////////////////////////////////////////////////////
   // Interface:
   ////////////////////////////////////////////////////////////////////////////

   /**
    * Construct a container for the generic sample configuration.
    *
    * @param url        The URL used to contact the SRM API.
    * @param userName   SRM user name.
    * @param password   SRM password for {@link #_userName}.
    * @param ignoreCert The user has requested to ignore SSL certificates in SRM
    *    connections.
    */
   public Options(
      final URL     url,
      final String  userName,
      final String  password,
      final boolean ignoreCert) {

      _ignoreCert = ignoreCert;
      _password   = password;
      _url        = url;
      _userName   = userName;
   }
}
