/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.client.common.impl;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoggingFilterInputStream
extends FilterInputStream {
    private static AtomicInteger _suffix = new AtomicInteger();
    private static Log _logger = LogFactory.getLog(LoggingFilterInputStream.class);
    private BufferedOutputStream _outputStream = null;

    public LoggingFilterInputStream(InputStream inputStream, String path) throws IOException {
        super(inputStream);
        path = String.format("%1$s-%2$04d.log", path, _suffix.getAndIncrement());
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)String.format("Logging response to '%1$s'", path));
        }
        this._outputStream = new BufferedOutputStream(new FileOutputStream(path, true));
    }

    public void closeLog() throws IOException {
        this._outputStream.close();
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.closeLog();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        int ret = super.read();
        if (ret >= 0) {
            this._outputStream.write(ret);
        }
        return ret;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int ret = super.read(b);
        if (ret > 0) {
            this._outputStream.write(b, 0, ret);
        }
        return ret;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int ret = super.read(b, off, len);
        if (ret > 0) {
            this._outputStream.write(b, off, ret);
        }
        return ret;
    }
}

