/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.core.common.impl;

import com.vmware.vim.vmomi.core.common.LifecycleListener;
import com.vmware.vim.vmomi.core.common.LifecycleManager;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BasicLifecycleManager
implements LifecycleManager {
    private Log _logger = LogFactory.getLog(this.getClass());
    private List<LifecycleListener> _lifecycleListeners;
    private boolean _stopped = false;

    @Override
    public synchronized void setLifecycleListeners(List<LifecycleListener> lifecycleListeners) {
        if (this._stopped) {
            throw new IllegalStateException("Can not set the lifecycle listeners of stopped lifecycle manager!");
        }
        this._lifecycleListeners = lifecycleListeners;
    }

    @Override
    public synchronized void addLifecycleListener(LifecycleListener lifecycleListener) {
        if (this._stopped) {
            throw new IllegalStateException("Can not add lifecycle listener to stopped lifecycle manager!");
        }
        if (this._lifecycleListeners == null) {
            this._lifecycleListeners = new ArrayList<LifecycleListener>();
        }
        this._lifecycleListeners.add(lifecycleListener);
    }

    @Override
    public synchronized void shutdown() {
        if (this._stopped) {
            return;
        }
        this._stopped = true;
        if (this._lifecycleListeners != null) {
            if (this._logger.isInfoEnabled()) {
                this._logger.info((Object)"Stopping lifecycle listeners.");
            }
            for (LifecycleListener shutdownable : this._lifecycleListeners) {
                shutdownable.shutdown();
            }
        }
    }

    @Override
    public synchronized void shutdownNow() {
        if (this._stopped) {
            return;
        }
        this._stopped = true;
        if (this._lifecycleListeners != null) {
            if (this._logger.isInfoEnabled()) {
                this._logger.info((Object)"Stopping lifecycle listeners immediately.");
            }
            for (LifecycleListener shutdownable : this._lifecycleListeners) {
                shutdownable.shutdownNow();
            }
        }
    }
}

