/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.core.types.impl;

import com.vmware.vim.vmomi.core.types.VmodlVersion;
import com.vmware.vim.vmomi.core.types.VmodlVersionMap;
import com.vmware.vim.vmomi.core.types.impl.VmodlVersionImpl;
import com.vmware.vim.vmomi.core.util.Validate;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class VmodlVersionMapImpl
implements VmodlVersionMap {
    private Map<String, VmodlVersion> _versionIdMap = new ConcurrentHashMap<String, VmodlVersion>();
    private Map<String, VmodlVersion> _wsdlNamespaceMap = new ConcurrentHashMap<String, VmodlVersion>();
    private Map<Class<?>, VmodlVersion> _versionClassMap = new ConcurrentHashMap();

    public void init() {
    }

    @Override
    public VmodlVersion getVersion(Class<?> version) {
        return this._versionClassMap.get(version);
    }

    @Override
    public VmodlVersion findVersion(String wsdlNamespace, String versionId2) {
        for (VmodlVersion version : this._versionClassMap.values()) {
            if (!wsdlNamespace.equals(version.getNamespace()) || !versionId2.equals(version.getVersionId())) continue;
            return version;
        }
        return null;
    }

    @Override
    public VmodlVersion getVersionByWsdlNamespace(String wsdlNamespace) {
        return this._wsdlNamespaceMap.get(wsdlNamespace);
    }

    @Override
    public void addVersion(Class<?> version) {
        if (this._versionClassMap.containsKey(version)) {
            return;
        }
        VmodlVersionImpl newVersion = VmodlVersionImpl.getOrRegister(version);
        String versionId2 = newVersion.getVersionId();
        if (versionId2 != null && versionId2.length() > 0) {
            this._versionIdMap.put(versionId2, newVersion);
        } else {
            String wsdlNamespace = newVersion.getNamespace();
            if (wsdlNamespace != null && wsdlNamespace.length() > 0) {
                this._wsdlNamespaceMap.put(wsdlNamespace, newVersion);
            }
        }
        this._versionClassMap.put(version, newVersion);
    }

    @Override
    public VmodlVersion findVersion(String wsdlNamespace, String versionId2, boolean internal2) {
        Validate.notNull("wsdlNamespace is required", wsdlNamespace);
        Validate.notNull("versionId is required", versionId2);
        if (internal2 && !wsdlNamespace.startsWith("internal")) {
            wsdlNamespace = "internal" + wsdlNamespace;
        } else if (!internal2 && wsdlNamespace.startsWith("internal")) {
            wsdlNamespace = wsdlNamespace.substring("internal".length());
        }
        return this.findVersion(wsdlNamespace, versionId2);
    }
}

