/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.utilities.ContextApplier;
import com.vmware.dr.ui.tools.utilities.ThreadContext;
import com.vmware.dr.ui.tools.utilities.threadcontexthelpers.LogContextSetter;
import com.vmware.srm.client.impex.configurables.basicInfo.Summary;
import com.vmware.srm.client.impex.tool.ConfigurablesWrapper;
import com.vmware.srm.client.impex.tool.JaxbContextLoader;
import com.vmware.srm.client.impex.tool.SrmServersDataWrapper;
import com.vmware.srm.client.impex.tool.XmlExportEngine;
import com.vmware.srm.client.impex.tool.XmlImporter;
import com.vmware.srm.client.impex.tool.io.IOHelper;
import com.vmware.srm.client.impex.tool.io.InputWaiterRequester;
import com.vmware.srm.client.impex.tool.io.args.Arguments;
import com.vmware.srm.client.impex.tool.io.args.ArgumentsParser;
import com.vmware.srm.client.impex.tool.io.data.UserInputProperties;
import com.vmware.srm.client.impex.workflow.SrmTopologyCreator;
import com.vmware.srm.client.impex.workflow.TopologyCreator;
import com.vmware.srm.client.impex.workflow.UserInteractor;
import com.vmware.srm.client.topology.client.view.availability.PairSetup;
import com.vmware.srm.client.topology.client.view.availability.srm.SrmServer;
import com.vmware.srm.client.topology.impl.core.TopologyImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.Callable;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger LOGGER = LoggerFactory.getLogger(Main.class);
    private static IOHelper ioHelper;
    private static InputWaiterRequester waiter;

    public static void main(String[] args) throws IOException {
        InputWaiterRequester.ExitStatus exitStatus;
        ConfigurablesWrapper importConfigurables;
        Arguments arguments;
        Main.logVersionAndBuildNumber();
        ioHelper = UserInteractor.getIoHelper();
        ioHelper.writeln("***Copyright (c) 2018-2022 VMware, Inc. All rights reserved.***");
        try {
            arguments = ArgumentsParser.parse(args);
        }
        catch (Exception e) {
            LOGGER.error("ERROR_LOG_PREFIX_" + e.getMessage());
            System.exit(1);
            return;
        }
        String propertiesFilePath = arguments.getPropertiesFilePath();
        if (Objects.isNull(propertiesFilePath)) {
            ioHelper.writeln("Initiating CMD interaction.");
            if (arguments.isInteractive()) {
                UserInteractor.initFromStdIn();
            } else {
                UserInteractor.initFromStdInUsingCmdArgs(arguments);
            }
        } else {
            ioHelper.writeln("Initiating using properties file.");
            try {
                UserInteractor.initFromFile(propertiesFilePath);
            }
            catch (UserInputProperties.InvalidPropertyException | IOException e) {
                LOGGER.error("ERROR_LOG_PREFIX_" + e.getMessage());
                ioHelper.writeln("Unable to initiate using properties file: " + e.getMessage());
                System.exit(2);
                return;
            }
        }
        if (arguments.doImport()) {
            try {
                importConfigurables = Main.readConfigurables(arguments.getPath());
            }
            catch (IOException | JAXBException | XMLStreamException e) {
                LOGGER.error("ERROR_LOG_PREFIX_" + e.getMessage());
                ioHelper.writeln("Unable to read import file: " + arguments.getPath() + e.getMessage());
                System.exit(11);
                return;
            }
            Summary summary = importConfigurables.getSummary();
            if (summary != null) {
                ioHelper.writeln(Main.getSummary(summary));
            }
        } else {
            importConfigurables = null;
        }
        waiter = UserInteractor.getInputWaiter();
        Callable<Promise> impexTask = () -> TopologyCreator.create().onError(e -> Main.completeWithError(3, e.getMessage())).thenCompose(topology -> SrmTopologyCreator.getInstance().selectServerPair(arguments.doImport(), (TopologyImpl)topology).onError(e -> Main.completeWithError(4, e.getMessage())).thenCompose(pairSetup -> SrmTopologyCreator.createWrapper(topology, (PairSetup<SrmServer>)pairSetup).onError(e -> Main.completeWithError(5, e.getMessage())).thenCompose(serversData -> {
            if (arguments.doImport()) {
                return Main.doImport(serversData, importConfigurables, arguments.getSrmRetriesDelay(), arguments.getSrmRetriesCount(), arguments.allowOverrideProtectionSettings());
            }
            return Main.doExport(serversData, arguments.formatted(), arguments.getExportPath());
        })).onError(e -> Main.completeWithError(6, e.getMessage())));
        try {
            ThreadContext.setupContext(impexTask, (ContextApplier)LogContextSetter.createApplier((String)"operationID", (Object)"impex-fixed-op-id"));
        }
        catch (Exception e) {
            Main.completeWithError(10, "Unable to configure logging.");
        }
        try {
            exitStatus = waiter.waitForInput();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            exitStatus = new InputWaiterRequester.ExitStatus(7, "Unable to complete task.");
        }
        LOGGER.error("ERROR_LOG_PREFIX_" + exitStatus.getMessage());
        ioHelper.writeln(exitStatus.getMessage());
        System.exit(exitStatus.getCode());
    }

    private static void logVersionAndBuildNumber() throws IOException {
        Properties buildProperties = new Properties();
        try (InputStream in = Main.class.getResourceAsStream("/plugin-version.properties");){
            buildProperties.load(in);
        }
        LOGGER.info(String.format("Version %s. Build %s.", buildProperties.getProperty("version", "unknown"), buildProperties.getProperty("buildNumber", "unknown")));
    }

    private static ConfigurablesWrapper readConfigurables(String path) throws IOException, JAXBException, XMLStreamException {
        ConfigurablesWrapper configurables;
        File file = Paths.get(path, new String[0]).toFile();
        if (!file.exists()) {
            throw new IllegalArgumentException(String.format("File does not exist %s.", file.getAbsoluteFile()));
        }
        IOHelper ioHelper = UserInteractor.getIoHelper();
        ioHelper.writeln("Reading file...");
        try (FileInputStream inputStream = new FileInputStream(file);){
            configurables = (ConfigurablesWrapper)JaxbContextLoader.unmarshal((InputStream)inputStream, ConfigurablesWrapper.class);
        }
        ioHelper.writeln("Reading file done.");
        return configurables;
    }

    private static String getSummary(Summary summary) {
        SimpleDateFormat formatter = new SimpleDateFormat("dd MMMM yyyy HH:mm:ss");
        return String.format("Export details:\nBuild number: %s\nVersion: %s\nDate: %s\nLocal site name: %s\nRemote site name: %s", summary.getBuildNumber(), summary.getVersion(), formatter.format(new Date(summary.getTimestamp())), summary.getLocalSiteName(), summary.getRemoteSiteName());
    }

    private static Promise<Void> doExport(SrmServersDataWrapper serversData, Boolean formatted, String path) {
        ioHelper.writeln("Starting export...");
        return new XmlExportEngine().export(serversData, formatted, path).onSuccess(done -> waiter.complete(0, "Export ended successfully.")).onSuccess(done -> LOGGER.info("Export SRM configuration ended.")).onError(error -> {
            String errorMsg = error.getLocalizedMessage();
            Main.completeWithError(8, (String)(StringUtils.isEmpty(errorMsg) ? "Export ended with errors, check log for more information." : "Export ended with errors, check log for more information. Error: " + errorMsg));
        }).onError(error -> LOGGER.error("Export SRM configuration ended.", (Throwable)error)).materialize().thenApply(result -> null);
    }

    private static Promise<Void> doImport(SrmServersDataWrapper serversData, ConfigurablesWrapper configurablesWrapper, Integer srmRetriesDelay, Integer srmRetriesCount, boolean allowOverrideProtectionSettings) {
        return new XmlImporter().importSrmConfigurables(srmRetriesDelay, srmRetriesCount, allowOverrideProtectionSettings, serversData, configurablesWrapper).onSuccess(done -> waiter.complete(0, "Import ended successfully.")).onSuccess(done -> LOGGER.info("Import SRM configuration ended.")).onError(error -> {
            String errorMsg = error.getLocalizedMessage();
            Main.completeWithError(9, (String)(StringUtils.isEmpty(errorMsg) ? "Import ended with errors, check log for more information." : "Import ended with errors, check log for more information. Error: " + errorMsg));
        }).onError(error -> LOGGER.error("Import SRM configuration ended.", (Throwable)error)).materialize().thenApply(result -> null);
    }

    private static void completeWithError(int exitCode, String errorMessage) {
        waiter.complete(exitCode, errorMessage);
    }
}

