/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.tool;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.PromiseResult;
import com.vmware.dr.ui.tools.reactive.Publisher;
import com.vmware.dr.ui.tools.reactive.Stream;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.dr.ui.tools.reactive.impl.Streams;
import com.vmware.srm.client.impex.configurables.arrayManagers.IeArrayManager;
import com.vmware.srm.client.impex.importers.arrayManagers.ArrayManagerImporter;
import com.vmware.srm.client.impex.importers.arrayManagers.ArrayPairImporter;
import com.vmware.srm.client.impex.tool.ImpexImportSrmContext;
import com.vmware.srm.client.impex.tool.io.IOHelper;
import com.vmware.srm.client.impex.tool.io.InputWaiterRequester;
import com.vmware.srm.client.impex.workflow.UserInteractor;
import com.vmware.srm.client.infrastructure.tuple.Tuple2;
import com.vmware.srm.client.topology.impl.utils.Exceptions;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;

public class InteractiveArrayManagerImporter {
    private final ArrayManagerImporter _arrayManagerImporter = new ArrayManagerImporter();
    private final ArrayPairImporter _arrayPairImporter = new ArrayPairImporter();

    public Promise<Boolean> createArrayManagers() {
        LinkedList<IeArrayManager> toCreate = new LinkedList<IeArrayManager>(ImpexImportSrmContext.get().getConfigurablesWrapper().getArrayManagers());
        IOHelper ioHelper = UserInteractor.getIoHelper();
        return this.createArrayManagers(toCreate, UserInteractor.getInputWaiter().continueOnAmError()).reduce(new HashMap(), (map, pair) -> {
            map.put((IeArrayManager)pair.getFirst(), (PromiseResult)pair.getSecond());
            return map;
        }).onSuccess(unused -> ioHelper.writeln("Done creating array managers.\nAdding array pairs and starting discover devices...")).onError(error -> ioHelper.writeln("Unable to create array managers, error: " + error)).thenCompose(this::addArrayPairs).onSuccess(unused -> ioHelper.writeln("Adding pairs and discover devices are done.")).onError(error -> ioHelper.writeln("Unable to add array pairs or discover devices, error: " + error));
    }

    private Stream<Pair> createArrayManagers(Queue<IeArrayManager> toCreate, InputWaiterRequester.AmErrorHandling amErrorHandling) {
        if (toCreate.isEmpty()) {
            return Streams.empty();
        }
        IeArrayManager ieArrayManager = toCreate.peek();
        return this.createArrayManager(ieArrayManager).materialize().toStream().flatMap(promiseResult -> {
            if (promiseResult.isSuccessful() || promiseResult.getError() instanceof InputWaiterRequester.RejectedException) {
                toCreate.poll();
                return Streams.just((Object[])new Pair[]{new Pair(ieArrayManager, (PromiseResult<ManagedObjectReference>)promiseResult)}).merge(new Publisher[]{this.createArrayManagers(toCreate, amErrorHandling)});
            }
            switch (amErrorHandling) {
                case CONTINUE: {
                    toCreate.poll();
                    return Streams.just((Object[])new Pair[]{new Pair(ieArrayManager, (PromiseResult<ManagedObjectReference>)promiseResult)}).merge(new Publisher[]{this.createArrayManagers(toCreate, amErrorHandling)});
                }
                case INTERRUPT: {
                    return Promises.reject((Exception)new RuntimeException("Array manager creation interrupted."));
                }
                case PROMPT: {
                    return this.createArrayManagers(toCreate, amErrorHandling);
                }
            }
            return Promises.reject((Exception)new IllegalStateException("Unsupported value: " + amErrorHandling));
        });
    }

    private Promise<ManagedObjectReference> createArrayManager(IeArrayManager arrayManager) {
        IOHelper ioHelper = UserInteractor.getIoHelper();
        InputWaiterRequester waiter = UserInteractor.getInputWaiter();
        String amName = arrayManager.getName();
        return waiter.promptForAmCredentials(amName).thenCompose(credentials -> {
            ioHelper.writeln(String.format("Creating array manager '%s'...", amName));
            return this._arrayManagerImporter.create(arrayManager, credentials.getUsername(), credentials.getPassword());
        }).materialize().thenApply(result -> {
            if (result.isSuccessful()) {
                ioHelper.writeln(String.format("Array manager '%s' created successfully.", amName));
                return (ManagedObjectReference)result.getResult();
            }
            ioHelper.writeln(String.format("Could not create array manager '%s'. Reason: %s", arrayManager.getName(), result.getError().getMessage()));
            throw Exceptions.getRuntimeException((Throwable)result.getError());
        });
    }

    private Promise<Boolean> addArrayPairs(Map<IeArrayManager, PromiseResult<ManagedObjectReference>> amMoRefToIeAm) {
        return Streams.from((Publisher[])((Publisher[])amMoRefToIeAm.entrySet().stream().filter(entry -> ((PromiseResult)entry.getValue()).isSuccessful()).filter(entry -> ((IeArrayManager)entry.getKey()).isLocal()).map(entry -> this._arrayPairImporter.addPair((ManagedObjectReference)((PromiseResult)entry.getValue()).getResult(), ((IeArrayManager)entry.getKey()).getArrayPairs(), ((IeArrayManager)entry.getKey()).getName())).map(Promise::materialize).toArray(Promise[]::new))).collect().thenApply(unused -> amMoRefToIeAm.values().stream().anyMatch(promiseResult -> !promiseResult.isSuccessful() && !(promiseResult.getError() instanceof InputWaiterRequester.RejectedException)));
    }

    private static final class Pair
    extends Tuple2<IeArrayManager, PromiseResult<ManagedObjectReference>> {
        Pair(IeArrayManager first, PromiseResult<ManagedObjectReference> second) {
            super((Object)first, second);
        }
    }
}

