/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.tool.io;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.srm.client.impex.tool.io.IOHelper;
import com.vmware.srm.client.impex.tool.io.InputWaiterRequester;
import com.vmware.srm.client.impex.tool.io.data.ArrayManagerCredentials;
import com.vmware.srm.client.impex.tool.io.data.Credentials;
import com.vmware.srm.client.impex.tool.io.data.KeyStoreData;
import com.vmware.srm.client.impex.tool.io.data.Lspp;
import com.vmware.srm.client.impex.tool.io.data.UserInputProperties;
import com.vmware.srm.client.impex.tool.io.request.FinalRequest;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public class FileInputWR
extends InputWaiterRequester {
    private final UserInputProperties _properties;
    private final AtomicBoolean _localCredentialsRequested = new AtomicBoolean(false);
    private final AtomicBoolean _remoteCredentialsRequested = new AtomicBoolean(false);
    private final Set<String> _requestedAms = Collections.synchronizedSet(new HashSet());

    public FileInputWR(IOHelper ioHelper, UserInputProperties properties) {
        super(ioHelper);
        this._properties = properties;
    }

    @Override
    public Promise<Lspp> promptForLspp() {
        return Promises.resolve((Object)this._properties.getLspp());
    }

    @Override
    public Promise<Boolean> promptForThumbprint(String host, String thumbprint) {
        return Promises.resolve((Object)true);
    }

    @Override
    public Promise<Boolean> promptForUsingLocalKeyStore(String host) {
        return Promises.resolve((Object)this._properties.isLocalUseKeyStore());
    }

    @Override
    public Promise<Credentials> promptForLocalCredentials(String host) {
        if (this._localCredentialsRequested.getAndSet(true)) {
            return Promises.reject((Exception)new InputWaiterRequester.RejectedException("Local credentials have already been requested."));
        }
        return this.validateCredentials(this._properties.getLocalCredentials(), host);
    }

    @Override
    public Promise<KeyStoreData> promptForLocalKeyStoreData() {
        if (this._localCredentialsRequested.getAndSet(true)) {
            return Promises.reject((Exception)new InputWaiterRequester.RejectedException("Local keystore data has already been requested."));
        }
        return Promises.resolve((Object)this._properties.getLocalKeyStoreData());
    }

    @Override
    public Promise<String> promptForSrmServer(Map<String, String> guidToName) {
        return this.promptForServer(guidToName, this._properties.getLocalSrmName());
    }

    private Promise<String> promptForServer(Map<String, String> guidToName, String serverName) {
        String guid = guidToName.entrySet().stream().filter(entry -> serverName.equals(entry.getValue())).map(Map.Entry::getKey).findFirst().orElse(null);
        if (Objects.isNull(guid)) {
            return Promises.reject((Exception)new IllegalArgumentException("No server named '" + serverName + "' is found."));
        }
        return Promises.resolve((Object)guid);
    }

    @Override
    public Promise<Boolean> promptForUsingRemoteKeyStore(String host) {
        return Promises.resolve((Object)this._properties.isRemoteUseKeyStore());
    }

    @Override
    public Promise<Credentials> promptForRemoteCredentials(String srmName) {
        if (this._remoteCredentialsRequested.getAndSet(true)) {
            return Promises.reject((Exception)new InputWaiterRequester.RejectedException("Remote credentials have already been requested."));
        }
        return this.validateCredentials(this._properties.getRemoteCredentials(), srmName);
    }

    @Override
    public Promise<KeyStoreData> promptForRemoteKeyStoreData() {
        if (this._remoteCredentialsRequested.getAndSet(true)) {
            return Promises.reject((Exception)new InputWaiterRequester.RejectedException("Remote keystore data has already been requested."));
        }
        return Promises.resolve((Object)this._properties.getRemoteKeyStoreData());
    }

    @Override
    public InputWaiterRequester.AmErrorHandling continueOnAmError() {
        if (this._properties.continueAfterAmError()) {
            return InputWaiterRequester.AmErrorHandling.CONTINUE;
        }
        return InputWaiterRequester.AmErrorHandling.INTERRUPT;
    }

    @Override
    public Promise<Credentials> promptForAmCredentials(String amName) {
        ArrayManagerCredentials amCredentials = this._properties.getArrayManagerCredentials(amName);
        if (Objects.isNull(amCredentials)) {
            return Promises.reject((Exception)new InputWaiterRequester.RejectedException(String.format("Missing array manager properties for array manager '%s'.", amName)));
        }
        if (amCredentials.doSkip()) {
            return Promises.reject((Exception)new InputWaiterRequester.RejectedException("User rejected."));
        }
        if (!this._requestedAms.add(amName)) {
            return Promises.reject((Exception)new InputWaiterRequester.RejectedException(String.format("Credentials for array manger '%s' already requested.", amName)));
        }
        Credentials credentials = amCredentials.getCredentials();
        return this.validateCredentials(credentials, amName);
    }

    @Override
    public void complete(int exitCode, String completionMessage) {
        this._requests.add(new FinalRequest(exitCode, completionMessage));
    }

    private Promise<Credentials> validateCredentials(Credentials credentials, String target) {
        if (Objects.isNull((Object)credentials)) {
            return Promises.reject((Exception)new InputWaiterRequester.RejectedException("No credentials provided for: " + target));
        }
        return Promises.resolve((Object)((Object)credentials));
    }
}

