/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.tool.io.args;

import com.vmware.srm.client.impex.tool.io.IOHelper;
import com.vmware.srm.client.impex.tool.io.args.Arguments;
import com.vmware.srm.client.impex.tool.io.data.Credentials;
import com.vmware.srm.client.impex.tool.io.data.KeyStoreData;
import com.vmware.srm.client.impex.tool.io.data.Lspp;
import com.vmware.srm.client.impex.workflow.UserInteractor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import joptsimple.BuiltinHelpFormatter;
import joptsimple.HelpFormatter;
import joptsimple.OptionDescriptor;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpecBuilder;
import joptsimple.ValueConversionException;
import joptsimple.ValueConverter;

public class ArgumentsParser {
    private static final String CMD_PARAM_SRM_IMPORT_RETRIES_COUNT = "retries";
    private static final String CMD_PARAM_SRM_IMPORT_DELAY = "delay";
    private static final String CMD_PARAM_SRM_IMPORT_ALLOW_OVERRIDE_PROTECTION_SETTINGS = "overrideProtectionSettings";
    private static final String CMD_PARAM_SRM_NAME = "localSrmName";
    private static final String CMD_PARAM_SRM_GUID = "localSrmGuid";
    private static final String CMD_PARAM_CONN_LSPP = "lspp";
    private static final String CMD_PARAM_CONN_PORT = "port";
    private static final String CMD_PARAM_AUTH_L_USE_KEYSTORE = "localAuthUseKeystore";
    private static final String CMD_PARAM_AUTH_L_CREDS_USERNAME = "localAuthCredsUsername";
    private static final String CMD_PARAM_AUTH_L_CREDS_PASS = "localAuthCredsPass";
    private static final String CMD_PARAM_AUTH_L_KS_TYPE = "localAuthKsType";
    private static final String CMD_PARAM_AUTH_L_KS_PATH = "localAuthKsPath";
    private static final String CMD_PARAM_AUTH_L_KS_PASS = "localAuthKsPass";
    private static final String CMD_PARAM_AUTH_L_KS_CERT_ALIAS = "localAuthKsCertAlias";
    private static final String CMD_PARAM_AUTH_L_KS_KEY_ALIAS = "localAuthKsKeyAlias";
    private static final String CMD_PARAM_AUTH_L_KS_KEY_PASS = "localAuthKsKeyPass";
    private static final String CMD_PARAM_AUTH_R_USE_KEYSTORE = "remoteAuthUseKeystore";
    private static final String CMD_PARAM_AUTH_R_CREDS_USERNAME = "remoteAuthCredsUsername";
    private static final String CMD_PARAM_AUTH_R_CREDS_PASS = "remoteAuthCredsPass";
    private static final String CMD_PARAM_AUTH_R_KS_TYPE = "remoteAuthKsType";
    private static final String CMD_PARAM_AUTH_R_KS_PATH = "remoteAuthKsPath";
    private static final String CMD_PARAM_AUTH_R_KS_PASS = "remoteAuthKsPass";
    private static final String CMD_PARAM_AUTH_R_KS_CERT_ALIAS = "remoteAuthKsCertAlias";
    private static final String CMD_PARAM_AUTH_R_KS_KEY_ALIAS = "remoteAuthKsKeyAlias";
    private static final String CMD_PARAM_AUTH_R_KS_KEY_PASS = "remoteAuthKsKeyPass";
    private static final String CMD_PARAM_EXPORT_FORMAT = "format";
    private static final String CMD_PARAM_EXPORT_PATH = "exportPath";
    private static final String CMD_PARAM_CONF_EXPORT_CMD = "export";
    private static final String CMD_PARAM_CONF_EXPORT_INTERACTIVE = "exportInteractive";
    private static final String CMD_PARAM_CONF_EXPORT_PROPERTIES = "exportProperties";
    private static final String CMD_PARAM_IMPORT_PATH = "path";
    private static final String CMD_PARAM_CONF_IMPORT_INTERACTIVE = "importInteractive";
    private static final String CMD_PARAM_CONF_IMPORT_PROPERTIES = "importProperties";

    public static Arguments parse(String[] args) {
        OptionParser parser = ArgumentsParser.createParser();
        try {
            OptionSet options = parser.parse(args);
            ArgumentsParser.checkConfigArgs(options);
            ArgumentsParser.checkExportArgs(options);
            ArgumentsParser.checkImportArgs(options);
            ArgumentsParser.checkSrmConnectionArgs(options);
            ArgumentsParser.checkLocalAuthArgs(options);
            ArgumentsParser.checkRemoteAuthArgs(options);
            return ArgumentsParser.getArguments(options);
        }
        catch (RuntimeException e) {
            IOHelper ioHelper = UserInteractor.getIoHelper();
            ioHelper.writeln(e.getMessage());
            Throwable cause = e.getCause();
            if (cause != null) {
                ioHelper.writeln(cause.getMessage());
            }
            try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                parser.printHelpOn((OutputStream)os);
                ioHelper.writeln(os.toString(StandardCharsets.UTF_8.toString()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new RuntimeException("Invalid arguments.");
        }
    }

    private static Arguments getArguments(OptionSet options) {
        boolean isImport;
        Lspp lspp = null;
        boolean lUseKs = options.has(CMD_PARAM_AUTH_L_USE_KEYSTORE);
        Credentials lCreds = null;
        KeyStoreData lKsData = null;
        boolean rUseKs = options.has(CMD_PARAM_AUTH_R_USE_KEYSTORE);
        Credentials rCreds = null;
        KeyStoreData rKsData = null;
        String localSrmName = null;
        String localSrmGuid = null;
        if (options.has(CMD_PARAM_CONF_EXPORT_CMD)) {
            lspp = new Lspp((String)options.valueOf(CMD_PARAM_CONN_LSPP), (Integer)options.valueOf(CMD_PARAM_CONN_PORT));
            if (options.has(CMD_PARAM_SRM_NAME)) {
                localSrmName = (String)options.valueOf(CMD_PARAM_SRM_NAME);
            } else {
                localSrmGuid = (String)options.valueOf(CMD_PARAM_SRM_GUID);
            }
            if (lUseKs) {
                lKsData = new KeyStoreData((String)options.valueOf(CMD_PARAM_AUTH_L_KS_TYPE), (String)options.valueOf(CMD_PARAM_AUTH_L_KS_PATH), (String)options.valueOf(CMD_PARAM_AUTH_L_KS_PASS), (String)options.valueOf(CMD_PARAM_AUTH_L_KS_CERT_ALIAS), (String)options.valueOf(CMD_PARAM_AUTH_L_KS_KEY_ALIAS), (String)options.valueOf(CMD_PARAM_AUTH_L_KS_KEY_PASS));
            } else {
                lCreds = new Credentials((String)options.valueOf(CMD_PARAM_AUTH_L_CREDS_USERNAME), (String)options.valueOf(CMD_PARAM_AUTH_L_CREDS_PASS));
            }
            if (rUseKs) {
                rKsData = new KeyStoreData((String)options.valueOf(CMD_PARAM_AUTH_R_KS_TYPE), (String)options.valueOf(CMD_PARAM_AUTH_R_KS_PATH), (String)options.valueOf(CMD_PARAM_AUTH_R_KS_PASS), (String)options.valueOf(CMD_PARAM_AUTH_R_KS_CERT_ALIAS), (String)options.valueOf(CMD_PARAM_AUTH_R_KS_KEY_ALIAS), (String)options.valueOf(CMD_PARAM_AUTH_R_KS_KEY_PASS));
            } else {
                rCreds = new Credentials((String)options.valueOf(CMD_PARAM_AUTH_R_CREDS_USERNAME), (String)options.valueOf(CMD_PARAM_AUTH_R_CREDS_PASS));
            }
        }
        String properties = (String)((isImport = ArgumentsParser.isImport(options)) ? options.valueOf(CMD_PARAM_CONF_IMPORT_PROPERTIES) : options.valueOf(CMD_PARAM_CONF_EXPORT_PROPERTIES));
        return new Arguments(isImport, ArgumentsParser.isInteractive(options), properties, options.has(CMD_PARAM_EXPORT_FORMAT), (String)options.valueOf(CMD_PARAM_EXPORT_PATH), (String)options.valueOf(CMD_PARAM_IMPORT_PATH), (Integer)options.valueOf(CMD_PARAM_SRM_IMPORT_RETRIES_COUNT), (Integer)options.valueOf(CMD_PARAM_SRM_IMPORT_DELAY), options.has(CMD_PARAM_SRM_IMPORT_ALLOW_OVERRIDE_PROTECTION_SETTINGS), lspp, localSrmName, localSrmGuid, lUseKs, lCreds, lKsData, rUseKs, rCreds, rKsData);
    }

    private static OptionParser createParser() {
        OptionParser parser = new OptionParser();
        parser.formatHelpWith((HelpFormatter)new NonAlphabeticalHelpFormatter());
        ArgumentsParser.addConfigArgs(parser);
        ArgumentsParser.addConnectionArgs(parser);
        ArgumentsParser.addLocalAuthArgs(parser);
        ArgumentsParser.addRemoteAuthArgs(parser);
        ArgumentsParser.addImportArgs(parser);
        ArgumentsParser.addExportArgs(parser);
        return parser;
    }

    private static void addConfigArgs(OptionParser parser) {
        OptionSpecBuilder exportCmd = parser.accepts(CMD_PARAM_CONF_EXPORT_CMD, "Use to start an export passing the needed information on the command line.");
        OptionSpecBuilder exportProperties = parser.accepts(CMD_PARAM_CONF_EXPORT_PROPERTIES, "Use to start an export using properties file to pass the needed information.");
        OptionSpecBuilder exportInteractive = parser.accepts(CMD_PARAM_CONF_EXPORT_INTERACTIVE, "Use to start an export interactively, being prompted for needed information.");
        OptionSpecBuilder importProperties = parser.accepts(CMD_PARAM_CONF_IMPORT_PROPERTIES, "Use to start an import using properties file to pass the needed information.");
        OptionSpecBuilder importInteractive = parser.accepts(CMD_PARAM_CONF_IMPORT_INTERACTIVE, "Use to start an import interactively, being prompted for needed information.");
        exportProperties.withRequiredArg().ofType(String.class);
        importProperties.withRequiredArg().ofType(String.class);
        exportCmd.requiredUnless(CMD_PARAM_CONF_EXPORT_PROPERTIES, new String[]{CMD_PARAM_CONF_EXPORT_INTERACTIVE, CMD_PARAM_CONF_IMPORT_PROPERTIES, CMD_PARAM_CONF_IMPORT_INTERACTIVE});
        exportProperties.requiredUnless(CMD_PARAM_CONF_EXPORT_CMD, new String[]{CMD_PARAM_CONF_EXPORT_INTERACTIVE, CMD_PARAM_CONF_IMPORT_PROPERTIES, CMD_PARAM_CONF_IMPORT_INTERACTIVE});
        exportInteractive.requiredUnless(CMD_PARAM_CONF_EXPORT_CMD, new String[]{CMD_PARAM_CONF_EXPORT_PROPERTIES, CMD_PARAM_CONF_IMPORT_PROPERTIES, CMD_PARAM_CONF_IMPORT_INTERACTIVE});
        importProperties.requiredUnless(CMD_PARAM_CONF_EXPORT_CMD, new String[]{CMD_PARAM_CONF_EXPORT_PROPERTIES, CMD_PARAM_CONF_EXPORT_INTERACTIVE, CMD_PARAM_CONF_IMPORT_INTERACTIVE});
        importInteractive.requiredUnless(CMD_PARAM_CONF_EXPORT_CMD, new String[]{CMD_PARAM_CONF_EXPORT_PROPERTIES, CMD_PARAM_CONF_EXPORT_INTERACTIVE, CMD_PARAM_CONF_IMPORT_PROPERTIES});
    }

    private static void checkConfigArgs(OptionSet optionSet) {
        boolean hasExportCmd = optionSet.has(CMD_PARAM_CONF_EXPORT_CMD);
        boolean hasExportProperties = optionSet.has(CMD_PARAM_CONF_EXPORT_PROPERTIES);
        boolean hasExportInteractive = optionSet.has(CMD_PARAM_CONF_EXPORT_INTERACTIVE);
        boolean hasImportProperties = optionSet.has(CMD_PARAM_CONF_IMPORT_PROPERTIES);
        boolean hasImportInteractive = optionSet.has(CMD_PARAM_CONF_IMPORT_INTERACTIVE);
        int sum = hasExportCmd ? 1 : 0;
        sum += hasExportProperties ? 1 : 0;
        sum += hasExportInteractive ? 1 : 0;
        sum += hasImportProperties ? 1 : 0;
        if ((sum += hasImportInteractive ? 1 : 0) != 1) {
            throw new RuntimeException("Options 'export', 'exportProperties', 'exportInteractive', 'importProperties' and 'importInteractive' cannot be used together.");
        }
    }

    private static void addExportArgs(OptionParser parser) {
        parser.accepts(CMD_PARAM_EXPORT_FORMAT, "[export] Use to make the exported XML file formatted and human-readable. *This will significantly increase the file size!");
        parser.accepts(CMD_PARAM_EXPORT_PATH, "[export] Pass a directory in which the exported file to be created.").withRequiredArg().ofType(String.class);
    }

    private static void checkExportArgs(OptionSet optionSet) {
        if (ArgumentsParser.isImport(optionSet) && (optionSet.has(CMD_PARAM_EXPORT_FORMAT) || optionSet.has(CMD_PARAM_EXPORT_PATH))) {
            throw new RuntimeException("Options 'format' and 'exportPath' are relevant when doing an export only.");
        }
    }

    private static void addImportArgs(OptionParser parser) {
        parser.accepts(CMD_PARAM_IMPORT_PATH, "[import] Path of the file to load - the previously exported file.").requiredIf(CMD_PARAM_CONF_IMPORT_INTERACTIVE, new String[]{CMD_PARAM_CONF_IMPORT_PROPERTIES}).withRequiredArg().ofType(String.class);
        parser.accepts(CMD_PARAM_SRM_IMPORT_DELAY, "[import SRM] An integer value for the desired delay between retries in milliseconds when importing VM recovery settings.").withRequiredArg().ofType(Integer.class).defaultsTo((Object)10000, (Object[])new Integer[0]).withValuesConvertedBy((ValueConverter)new RangeValueConverter());
        parser.accepts(CMD_PARAM_SRM_IMPORT_RETRIES_COUNT, "[import SRM] An integer value for the count of the retries when importing VM recovery settings.").withRequiredArg().ofType(Integer.class).defaultsTo((Object)5, (Object[])new Integer[0]).withValuesConvertedBy((ValueConverter)new RangeValueConverter());
        parser.accepts(CMD_PARAM_SRM_IMPORT_ALLOW_OVERRIDE_PROTECTION_SETTINGS, "[import SRM] Use to enable overriding virtual machine protection settings regarding network mappings.");
    }

    private static void checkImportArgs(OptionSet optionSet) {
        if ((optionSet.has(CMD_PARAM_IMPORT_PATH) || optionSet.has(CMD_PARAM_SRM_IMPORT_DELAY) || optionSet.has(CMD_PARAM_SRM_IMPORT_RETRIES_COUNT) || optionSet.has(CMD_PARAM_SRM_IMPORT_ALLOW_OVERRIDE_PROTECTION_SETTINGS)) && !ArgumentsParser.isImport(optionSet)) {
            throw new RuntimeException("Options 'path', 'delay', 'retries' and 'overrideProtectionSettings' are relevant when doing an import only.");
        }
    }

    private static void addConnectionArgs(OptionParser parser) {
        parser.accepts(CMD_PARAM_CONN_LSPP, "The Platform Services Controller address. Can be an IP address or FQDN.").requiredIf(CMD_PARAM_CONF_EXPORT_CMD, new String[0]).withRequiredArg().ofType(String.class);
        parser.accepts(CMD_PARAM_CONN_PORT, "The port number for the Lookup Service. The default value is 443.").withRequiredArg().ofType(Integer.class).defaultsTo((Object)443, (Object[])new Integer[0]).withValuesConvertedBy((ValueConverter)new RangeValueConverter());
        parser.accepts(CMD_PARAM_SRM_NAME, "The name of the local Site Recovery Manager Server. Required unless 'localSrmGuid'.").withRequiredArg().ofType(String.class);
        parser.accepts(CMD_PARAM_SRM_GUID, "The guid of the local Site Recovery Manager Server. Required unless 'localSrmName'.").withRequiredArg().ofType(String.class);
    }

    private static void checkSrmConnectionArgs(OptionSet optionSet) {
        boolean isExportCmd = optionSet.has(CMD_PARAM_CONF_EXPORT_CMD);
        boolean hasSrmName = optionSet.has(CMD_PARAM_SRM_NAME);
        boolean hasSrmGuid = optionSet.has(CMD_PARAM_SRM_GUID);
        if ((optionSet.has(CMD_PARAM_CONN_LSPP) || optionSet.has(CMD_PARAM_CONN_PORT) || hasSrmName || hasSrmGuid) && !isExportCmd) {
            throw new RuntimeException("Options 'lspp', 'port', 'localSrmName' and 'localSrmGuid' are relevant when using 'export' only.");
        }
        if (isExportCmd && !hasSrmName && !hasSrmGuid) {
            throw new RuntimeException("Option 'localSrmName' (or 'localSrmGuid') is required when using 'export' only.");
        }
        if (hasSrmName && hasSrmGuid) {
            throw new RuntimeException("Options 'localSrmName' and 'localSrmGuid' cannot be used together.");
        }
    }

    private static void addLocalAuthArgs(OptionParser parser) {
        OptionSpecBuilder lUseKeystore = parser.accepts(CMD_PARAM_AUTH_L_USE_KEYSTORE, "Use to specify whether to use a Java Keystore (JKS) file to log in on the local site.");
        parser.accepts(CMD_PARAM_AUTH_L_CREDS_USERNAME, "[Username and password local authentication] Required when not using JKS. The user name for the local vCenter Server.").requiredUnless(CMD_PARAM_CONF_EXPORT_INTERACTIVE, new String[]{CMD_PARAM_CONF_EXPORT_PROPERTIES, CMD_PARAM_CONF_IMPORT_INTERACTIVE, CMD_PARAM_CONF_IMPORT_PROPERTIES, CMD_PARAM_AUTH_L_USE_KEYSTORE}).withRequiredArg().ofType(String.class);
        lUseKeystore.requiredUnless(CMD_PARAM_CONF_EXPORT_INTERACTIVE, new String[]{CMD_PARAM_CONF_EXPORT_PROPERTIES, CMD_PARAM_CONF_IMPORT_INTERACTIVE, CMD_PARAM_CONF_IMPORT_PROPERTIES, CMD_PARAM_AUTH_L_CREDS_USERNAME});
        parser.accepts(CMD_PARAM_AUTH_L_CREDS_PASS, "[Username and password local authentication] Required when not using JKS. The password for the local vCenter Server.").requiredIf(CMD_PARAM_AUTH_L_CREDS_USERNAME, new String[0]).withRequiredArg().ofType(String.class);
        parser.accepts(CMD_PARAM_AUTH_L_KS_TYPE, "[JKS local authentication] Type of the JKS. The default type is JCEKS.").withRequiredArg().ofType(String.class).defaultsTo((Object)"PKCS12", (Object[])new String[0]);
        parser.accepts(CMD_PARAM_AUTH_L_KS_PATH, "[JKS local authentication] Path to the JKS.").requiredIf(CMD_PARAM_AUTH_L_USE_KEYSTORE, new String[0]).withRequiredArg().ofType(String.class);
        parser.accepts(CMD_PARAM_AUTH_L_KS_PASS, "[JKS local authentication] JKS password.").requiredIf(CMD_PARAM_AUTH_L_USE_KEYSTORE, new String[0]).withRequiredArg().ofType(String.class);
        parser.accepts(CMD_PARAM_AUTH_L_KS_CERT_ALIAS, "[JKS local authentication] Certificate alias.").requiredIf(CMD_PARAM_AUTH_L_USE_KEYSTORE, new String[0]).withRequiredArg().ofType(String.class);
        parser.accepts(CMD_PARAM_AUTH_L_KS_KEY_ALIAS, "[JKS local authentication] Key alias.").requiredIf(CMD_PARAM_AUTH_L_USE_KEYSTORE, new String[0]).withRequiredArg().ofType(String.class);
        parser.accepts(CMD_PARAM_AUTH_L_KS_KEY_PASS, "[JKS local authentication] Key password.").requiredIf(CMD_PARAM_AUTH_L_USE_KEYSTORE, new String[0]).withRequiredArg().ofType(String.class);
    }

    private static void checkLocalAuthArgs(OptionSet optionSet) {
        boolean isExportCmd = optionSet.has(CMD_PARAM_CONF_EXPORT_CMD);
        boolean useKS = optionSet.has(CMD_PARAM_AUTH_L_USE_KEYSTORE);
        boolean credsUsername = optionSet.has(CMD_PARAM_AUTH_L_CREDS_USERNAME);
        boolean credsPass = optionSet.has(CMD_PARAM_AUTH_L_CREDS_PASS);
        boolean ksType = optionSet.has(CMD_PARAM_AUTH_L_KS_TYPE);
        boolean ksPath = optionSet.has(CMD_PARAM_AUTH_L_KS_PATH);
        boolean ksPass = optionSet.has(CMD_PARAM_AUTH_L_KS_PASS);
        boolean ksCertAlias = optionSet.has(CMD_PARAM_AUTH_L_KS_CERT_ALIAS);
        boolean ksKeyAlias = optionSet.has(CMD_PARAM_AUTH_L_KS_KEY_ALIAS);
        boolean ksKeyPass = optionSet.has(CMD_PARAM_AUTH_L_KS_KEY_PASS);
        if (!isExportCmd && (useKS || credsUsername || credsPass || ksType || ksPath || ksPass || ksCertAlias || ksKeyAlias || ksKeyPass)) {
            throw new RuntimeException("Options 'localAuthUseKeystore', 'localAuthCredsUsername', 'localAuthCredsPass', 'localAuthKsType', 'localAuthKsPath', 'localAuthKsPass', 'localAuthKsCertAlias', 'localAuthKsKeyAlias' and 'localAuthKsKeyPass' are relevant when using 'export' only.");
        }
        if (useKS && (credsUsername || credsPass)) {
            throw new RuntimeException("Options 'localAuthCredsUsername' and 'localAuthCredsPass' cannot be used along with'localAuthUseKeystore'.");
        }
        if (!useKS && credsUsername && (ksType || ksPath || ksPass || ksCertAlias || ksKeyAlias || ksKeyPass)) {
            throw new RuntimeException("Options 'localAuthKsType', 'localAuthKsPath', 'localAuthKsPass', 'localAuthKsCertAlias', 'localAuthKsKeyAlias' and 'localAuthKsKeyPass' cam only be used along with'localAuthUseKeystore'.");
        }
    }

    private static void addRemoteAuthArgs(OptionParser parser) {
        OptionSpecBuilder rUseKeystore = parser.accepts(CMD_PARAM_AUTH_R_USE_KEYSTORE, "Use to specify whether to use a Java Keystore (JKS) file to log in on the remote site.");
        parser.accepts(CMD_PARAM_AUTH_R_CREDS_USERNAME, "[Username and password remote authentication] Required when not using JKS. The user name for the remote vCenter Server.").requiredUnless(CMD_PARAM_CONF_EXPORT_INTERACTIVE, new String[]{CMD_PARAM_CONF_EXPORT_PROPERTIES, CMD_PARAM_CONF_IMPORT_INTERACTIVE, CMD_PARAM_CONF_IMPORT_PROPERTIES, CMD_PARAM_AUTH_R_USE_KEYSTORE}).withRequiredArg().ofType(String.class);
        rUseKeystore.requiredUnless(CMD_PARAM_CONF_EXPORT_INTERACTIVE, new String[]{CMD_PARAM_CONF_EXPORT_PROPERTIES, CMD_PARAM_CONF_IMPORT_INTERACTIVE, CMD_PARAM_CONF_IMPORT_PROPERTIES, CMD_PARAM_AUTH_R_CREDS_USERNAME});
        parser.accepts(CMD_PARAM_AUTH_R_CREDS_PASS, "[Username and password remote authentication] The password for the vCenter Server.").requiredIf(CMD_PARAM_AUTH_R_CREDS_USERNAME, new String[0]).withRequiredArg().ofType(String.class);
        parser.accepts(CMD_PARAM_AUTH_R_KS_TYPE, "[JKS remote authentication] Type of the JKS. The default type is JCEKS.").withRequiredArg().ofType(String.class).defaultsTo((Object)"PKCS12", (Object[])new String[0]);
        parser.accepts(CMD_PARAM_AUTH_R_KS_PATH, "[JKS remote authentication] Path to the JKS.").requiredIf(CMD_PARAM_AUTH_R_USE_KEYSTORE, new String[0]).withRequiredArg().ofType(String.class);
        parser.accepts(CMD_PARAM_AUTH_R_KS_PASS, "[JKS remote authentication] JKS password.").requiredIf(CMD_PARAM_AUTH_R_USE_KEYSTORE, new String[0]).withRequiredArg().ofType(String.class);
        parser.accepts(CMD_PARAM_AUTH_R_KS_CERT_ALIAS, "[JKS remote authentication] Certificate alias.").requiredIf(CMD_PARAM_AUTH_R_USE_KEYSTORE, new String[0]).withRequiredArg().ofType(String.class);
        parser.accepts(CMD_PARAM_AUTH_R_KS_KEY_ALIAS, "[JKS remote authentication] Key alias.").requiredIf(CMD_PARAM_AUTH_R_USE_KEYSTORE, new String[0]).withRequiredArg().ofType(String.class);
        parser.accepts(CMD_PARAM_AUTH_R_KS_KEY_PASS, "[JKS remote authentication] Key password.").requiredIf(CMD_PARAM_AUTH_R_USE_KEYSTORE, new String[0]).withRequiredArg().ofType(String.class);
    }

    private static void checkRemoteAuthArgs(OptionSet optionSet) {
        boolean isExportCmd = optionSet.has(CMD_PARAM_CONF_EXPORT_CMD);
        boolean useKS = optionSet.has(CMD_PARAM_AUTH_R_USE_KEYSTORE);
        boolean credsUsername = optionSet.has(CMD_PARAM_AUTH_R_CREDS_USERNAME);
        boolean credsPass = optionSet.has(CMD_PARAM_AUTH_R_CREDS_PASS);
        boolean ksType = optionSet.has(CMD_PARAM_AUTH_R_KS_TYPE);
        boolean ksPath = optionSet.has(CMD_PARAM_AUTH_R_KS_PATH);
        boolean ksPass = optionSet.has(CMD_PARAM_AUTH_R_KS_PASS);
        boolean ksCertAlias = optionSet.has(CMD_PARAM_AUTH_R_KS_CERT_ALIAS);
        boolean ksKeyAlias = optionSet.has(CMD_PARAM_AUTH_R_KS_KEY_ALIAS);
        boolean ksKeyPass = optionSet.has(CMD_PARAM_AUTH_R_KS_KEY_PASS);
        if (!isExportCmd && (useKS || credsUsername || credsPass || ksType || ksPath || ksPass || ksCertAlias || ksKeyAlias || ksKeyPass)) {
            throw new RuntimeException("Options 'remoteAuthUseKeystore', 'remoteAuthCredsUsername', 'remoteAuthCredsPass', 'remoteAuthKsType', 'remoteAuthKsPath', 'remoteAuthKsPass', 'remoteAuthKsCertAlias', 'remoteAuthKsKeyAlias' and 'remoteAuthKsKeyPass' are relevant when using 'export' only.");
        }
        if (useKS && (credsUsername || credsPass)) {
            throw new RuntimeException("Options 'remoteAuthCredsUsername' and 'remoteAuthCredsPass' cannot be used along with'remoteAuthUseKeystore'.");
        }
        if (!useKS && credsUsername && (ksType || ksPath || ksPass || ksCertAlias || ksKeyAlias || ksKeyPass)) {
            throw new RuntimeException("Options 'remoteAuthKsType', 'remoteAuthKsPath', 'remoteAuthKsPass', 'remoteAuthKsCertAlias', 'remoteAuthKsKeyAlias' and 'remoteAuthKsKeyPass' can only be used along with'remoteAuthUseKeystore'.");
        }
    }

    private static boolean isImport(OptionSet optionSet) {
        return optionSet.has(CMD_PARAM_CONF_IMPORT_PROPERTIES) || optionSet.has(CMD_PARAM_CONF_IMPORT_INTERACTIVE);
    }

    private static boolean isInteractive(OptionSet optionSet) {
        return optionSet.has(CMD_PARAM_CONF_EXPORT_INTERACTIVE) || optionSet.has(CMD_PARAM_CONF_IMPORT_INTERACTIVE);
    }

    private static final class NonAlphabeticalHelpFormatter
    extends BuiltinHelpFormatter {
        private static final int DESIRED_OVERALL_WIDTH = 180;
        private static final int DESIRED_COLUMN_SEPARATOR_WIDTH = 2;

        NonAlphabeticalHelpFormatter() {
            super(180, 2);
        }

        public String format(Map<String, ? extends OptionDescriptor> options) {
            this.addRows(options.values());
            return this.formattedHelpOutput();
        }
    }

    private static final class RangeValueConverter
    implements ValueConverter<Integer> {
        private RangeValueConverter() {
        }

        public Integer convert(String value) {
            int intVal;
            try {
                intVal = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                throw new ValueConversionException("An integer value is required.", e.getCause());
            }
            if (intVal < 0) {
                throw new ValueConversionException("A non-negative integer value is required.");
            }
            return intVal;
        }

        public Class<Integer> valueType() {
            return Integer.class;
        }

        public String valuePattern() {
            return "[1, 2147483647]";
        }
    }
}

